/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.gaxx.grpc;

import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.ChannelFactory;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.grpc.ChannelPrimer;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.bigtable.gaxx.grpc.BigtableChannelPool;
import com.google.cloud.bigtable.gaxx.grpc.BigtableChannelPoolSettings;
import com.google.common.base.Preconditions;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@InternalApi
public final class BigtableTransportChannelProvider
implements TransportChannelProvider {
    private final InstantiatingGrpcChannelProvider delegate;
    private final ChannelPrimer channelPrimer;

    private BigtableTransportChannelProvider(InstantiatingGrpcChannelProvider instantiatingGrpcChannelProvider, ChannelPrimer channelPrimer) {
        this.delegate = (InstantiatingGrpcChannelProvider)Preconditions.checkNotNull((Object)instantiatingGrpcChannelProvider);
        this.channelPrimer = channelPrimer;
    }

    public boolean shouldAutoClose() {
        return this.delegate.shouldAutoClose();
    }

    public boolean needsExecutor() {
        return this.delegate.needsExecutor();
    }

    public BigtableTransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.withExecutor((Executor)executor);
    }

    public BigtableTransportChannelProvider withExecutor(Executor executor) {
        InstantiatingGrpcChannelProvider newChannelProvider = (InstantiatingGrpcChannelProvider)this.delegate.withExecutor(executor);
        return new BigtableTransportChannelProvider(newChannelProvider, this.channelPrimer);
    }

    public boolean needsHeaders() {
        return this.delegate.needsHeaders();
    }

    public BigtableTransportChannelProvider withHeaders(Map<String, String> headers) {
        InstantiatingGrpcChannelProvider newChannelProvider = (InstantiatingGrpcChannelProvider)this.delegate.withHeaders(headers);
        return new BigtableTransportChannelProvider(newChannelProvider, this.channelPrimer);
    }

    public boolean needsEndpoint() {
        return this.delegate.needsEndpoint();
    }

    public TransportChannelProvider withEndpoint(String endpoint) {
        InstantiatingGrpcChannelProvider newChannelProvider = (InstantiatingGrpcChannelProvider)this.delegate.withEndpoint(endpoint);
        return new BigtableTransportChannelProvider(newChannelProvider, this.channelPrimer);
    }

    @Deprecated
    public boolean acceptsPoolSize() {
        return this.delegate.acceptsPoolSize();
    }

    @Deprecated
    public TransportChannelProvider withPoolSize(int size) {
        InstantiatingGrpcChannelProvider newChannelProvider = (InstantiatingGrpcChannelProvider)this.delegate.withPoolSize(size);
        return new BigtableTransportChannelProvider(newChannelProvider, this.channelPrimer);
    }

    public TransportChannel getTransportChannel() throws IOException {
        InstantiatingGrpcChannelProvider singleChannelProvider = this.delegate.toBuilder().setChannelPoolSettings(ChannelPoolSettings.staticallySized((int)1)).build();
        ChannelFactory channelFactory = () -> {
            try {
                GrpcTransportChannel channel = (GrpcTransportChannel)singleChannelProvider.getTransportChannel();
                return (ManagedChannel)channel.getChannel();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        BigtableChannelPoolSettings btPoolSettings = BigtableChannelPoolSettings.copyFrom(this.delegate.getChannelPoolSettings());
        BigtableChannelPool btChannelPool = BigtableChannelPool.create(btPoolSettings, channelFactory, this.channelPrimer);
        return GrpcTransportChannel.create((ManagedChannel)btChannelPool);
    }

    public String getTransportName() {
        return "bigtable";
    }

    public boolean needsCredentials() {
        return this.delegate.needsCredentials();
    }

    public TransportChannelProvider withCredentials(Credentials credentials) {
        InstantiatingGrpcChannelProvider newChannelProvider = (InstantiatingGrpcChannelProvider)this.delegate.withCredentials(credentials);
        return new BigtableTransportChannelProvider(newChannelProvider, this.channelPrimer);
    }

    public static BigtableTransportChannelProvider create(InstantiatingGrpcChannelProvider instantiatingGrpcChannelProvider, ChannelPrimer channelPrimer) {
        return new BigtableTransportChannelProvider(instantiatingGrpcChannelProvider, channelPrimer);
    }
}

