/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.common;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.Type;
import com.google.cloud.bigtable.common.AutoValue_Type_Array;
import com.google.cloud.bigtable.common.AutoValue_Type_Bool;
import com.google.cloud.bigtable.common.AutoValue_Type_Bytes;
import com.google.cloud.bigtable.common.AutoValue_Type_Date;
import com.google.cloud.bigtable.common.AutoValue_Type_Enum;
import com.google.cloud.bigtable.common.AutoValue_Type_Float32;
import com.google.cloud.bigtable.common.AutoValue_Type_Float64;
import com.google.cloud.bigtable.common.AutoValue_Type_Int64;
import com.google.cloud.bigtable.common.AutoValue_Type_Map;
import com.google.cloud.bigtable.common.AutoValue_Type_Proto;
import com.google.cloud.bigtable.common.AutoValue_Type_SchemalessEnum;
import com.google.cloud.bigtable.common.AutoValue_Type_SchemalessProto;
import com.google.cloud.bigtable.common.AutoValue_Type_SchemalessStruct;
import com.google.cloud.bigtable.common.AutoValue_Type_String;
import com.google.cloud.bigtable.common.AutoValue_Type_StructWithSchema_Field;
import com.google.cloud.bigtable.common.AutoValue_Type_Timestamp;
import com.google.cloud.bigtable.data.v2.internal.ColumnToIndexMapper;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

@BetaApi
@InternalApi
public interface Type {

    @InternalApi
    public static class DefaultInstances {
        private static final Bytes BYTES = new AutoValue_Type_Bytes();
        private static final String STRING = new AutoValue_Type_String();
        private static final Int64 INT64 = new AutoValue_Type_Int64();
        private static final Float64 FLOAT64 = new AutoValue_Type_Float64();
        private static final Float32 FLOAT32 = new AutoValue_Type_Float32();
        private static final Bool BOOL = new AutoValue_Type_Bool();
        private static final Timestamp TIMESTAMP = new AutoValue_Type_Timestamp();
        private static final Date DATE = new AutoValue_Type_Date();
        private static final SchemalessStruct SCHEMALESS_STRUCT = new AutoValue_Type_SchemalessStruct();
    }

    @AutoValue
    public static abstract class SchemalessEnum
    implements SqlType.Enum {
        public static SchemalessEnum fromProto(Type.Enum proto) {
            return SchemalessEnum.create(proto.getEnumName(), proto.getSchemaBundleId());
        }

        public static SchemalessEnum create(java.lang.String enumName, java.lang.String schemaBundleId) {
            return new AutoValue_Type_SchemalessEnum(enumName, schemaBundleId);
        }

        @Override
        public abstract java.lang.String getEnumName();

        public abstract java.lang.String schemaBundleId();

        public Function<Integer, ProtocolMessageEnum> getForNumber() {
            throw new UnsupportedOperationException("Cannot get forNumber for unresolved enum type. Please use the getProtoEnum overload that takes a forNumber function.");
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.ENUM;
        }

        public java.lang.String toString() {
            return this.getCode().name() + "{enumName=" + this.getEnumName() + ", schemaBundleId=" + this.schemaBundleId() + "}";
        }
    }

    @AutoValue
    public static abstract class SchemalessProto
    implements SqlType.Proto {
        public static SchemalessProto fromProto(Type.Proto proto) {
            return SchemalessProto.create(proto.getMessageName(), proto.getSchemaBundleId());
        }

        public static SchemalessProto create(java.lang.String messageName, java.lang.String schemaBundleId) {
            return new AutoValue_Type_SchemalessProto(messageName, schemaBundleId);
        }

        @Override
        public abstract java.lang.String getMessageName();

        public abstract java.lang.String schemaBundleId();

        public Parser<AbstractMessage> getParserForType() {
            throw new UnsupportedOperationException("Cannot get parser for unresolved proto type. Please use the getProtoMessage overload that takes a message instance.");
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.PROTO;
        }

        public java.lang.String toString() {
            return this.getCode().name() + "{messageName=" + this.getMessageName() + ", schemaBundleId=" + this.schemaBundleId() + "}";
        }
    }

    @AutoValue
    public static abstract class Enum<T extends ProtocolMessageEnum>
    implements Type,
    SqlType.Enum<T> {
        public static <T extends ProtocolMessageEnum> SqlType.Enum<T> create(Function<Integer, T> forNumber) {
            Preconditions.checkNotNull(forNumber, (Object)"Method may not be null. Use 'MyProtoEnum::forNumber' as a parameter value.");
            return new AutoValue_Type_Enum<T>(forNumber);
        }

        @Override
        @Nonnull
        public abstract Function<Integer, T> getForNumber();

        @Override
        public java.lang.String getEnumName() {
            ProtocolMessageEnum thisEnum = (ProtocolMessageEnum)this.getForNumber().apply(0);
            if (thisEnum == null) {
                return "";
            }
            return thisEnum.getDescriptorForType().getFullName();
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.ENUM;
        }

        public java.lang.String toString() {
            return this.getCode().name() + "{enum=" + this.getEnumName() + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Enum)) {
                return false;
            }
            Enum that = (Enum)o;
            ProtocolMessageEnum thisEnum = (ProtocolMessageEnum)this.getForNumber().apply(0);
            T thatEnum = that.getForNumber().apply(0);
            if (thisEnum == null || thatEnum == null) {
                return this.getForNumber().equals(that.getForNumber());
            }
            return thisEnum.getDescriptorForType().getFullName().equals(((ProtocolMessageEnum)thatEnum).getDescriptorForType().getFullName());
        }

        public int hashCode() {
            ProtocolMessageEnum thisEnum = (ProtocolMessageEnum)this.getForNumber().apply(0);
            if (thisEnum == null) {
                return this.getForNumber().hashCode();
            }
            return Objects.hash(new Object[]{this.getCode(), thisEnum.getDescriptorForType().getFullName()});
        }
    }

    @AutoValue
    public static abstract class Proto<T extends AbstractMessage>
    implements Type,
    SqlType.Proto<T> {
        public static <T extends AbstractMessage> SqlType.Proto<T> create(T message) {
            Preconditions.checkNotNull(message, (Object)"Proto message may not be null. Use 'MyProtoMessage::getDefaultInstance()' as a parameter value.");
            return new AutoValue_Type_Proto<T>(message);
        }

        @Nonnull
        abstract T getMessage();

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.PROTO;
        }

        @Override
        @Nonnull
        public Parser<T> getParserForType() {
            return this.getMessage().getParserForType();
        }

        @Override
        public java.lang.String getMessageName() {
            return this.getMessage().getDescriptorForType().getFullName();
        }

        public java.lang.String toString() {
            return this.getCode().name() + "{message=" + this.getMessageName() + "}";
        }
    }

    @AutoValue
    public static abstract class Map<K, V>
    implements Type,
    SqlType.Map<K, V> {
        public static <K, V> Map<K, V> create(SqlType<K> keyType, SqlType<V> valueType) {
            return new AutoValue_Type_Map<K, V>(keyType, valueType);
        }

        protected abstract SqlType<K> keyType();

        protected abstract SqlType<V> valueType();

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.MAP;
        }

        @Override
        public SqlType<K> getKeyType() {
            return this.keyType();
        }

        @Override
        public SqlType<V> getValueType() {
            return this.valueType();
        }

        public java.lang.String toString() {
            return this.getCode().name() + "{keyType=" + this.getKeyType().toString() + ", valueType=" + this.getValueType().toString() + "}";
        }
    }

    @AutoValue
    public static abstract class Array<Elem>
    implements Type,
    SqlType.Array<Elem> {
        public static <T> Array<T> create(SqlType<T> elemType) {
            return new AutoValue_Type_Array<T>(elemType);
        }

        protected abstract SqlType<Elem> elementType();

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.ARRAY;
        }

        @Override
        public SqlType<Elem> getElementType() {
            return this.elementType();
        }

        public java.lang.String toString() {
            return this.getCode().name() + "{elementType=" + (Object)((Object)this.getElementType().getCode()) + "}";
        }
    }

    public static class StructWithSchema
    extends ColumnToIndexMapper
    implements Type,
    SqlType.Struct {
        private final List<Field> fields;

        @InternalApi(value="Visible for testing")
        public StructWithSchema(List<Field> fields) {
            super(fields);
            this.fields = fields;
        }

        public static StructWithSchema fromProto(Type.Struct proto) {
            ImmutableList.Builder fields = ImmutableList.builder();
            for (Type.Struct.Field protoField : proto.getFieldsList()) {
                fields.add((Object)Field.fromProto(protoField));
            }
            return new StructWithSchema((List<Field>)fields.build());
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.STRUCT;
        }

        public List<Field> getFields() {
            return this.fields;
        }

        @Override
        public SqlType<?> getType(int fieldIndex) {
            return this.fields.get(fieldIndex).type();
        }

        @Override
        public SqlType<?> getType(java.lang.String fieldName) {
            int index = this.getColumnIndex(fieldName);
            return this.getType(index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StructWithSchema struct = (StructWithSchema)obj;
            return com.google.common.base.Objects.equal(this.getFields(), struct.getFields());
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.fields});
        }

        public java.lang.String toString() {
            return this.getCode().name() + "{fields=" + this.fields.toString() + "}";
        }

        @InternalApi(value="Visible for testing")
        @AutoValue
        public static abstract class Field
        implements SqlType.Struct.Field {
            public static Field fromProto(Type.Struct.Field proto) {
                return new AutoValue_Type_StructWithSchema_Field(proto.getFieldName(), SqlType.fromProto(proto.getType()));
            }

            @Override
            public abstract java.lang.String name();

            @Override
            public abstract SqlType<?> type();
        }
    }

    @AutoValue
    public static abstract class SchemalessStruct
    implements Type,
    SqlType.Struct {
        public static SchemalessStruct create() {
            return DefaultInstances.SCHEMALESS_STRUCT;
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.STRUCT;
        }

        public List<SqlType.Struct.Field> getFields() {
            throw new UnsupportedOperationException("Attempting to access schema of Schemaless Struct. These structs should only be used for typing of StructReader data access calls.");
        }

        @Override
        public SqlType<?> getType(int fieldIndex) {
            throw new UnsupportedOperationException("Attempting to access schema of Schemaless Struct. These structs should only be used for typing of StructReader data access calls.");
        }

        @Override
        public SqlType<?> getType(java.lang.String fieldName) {
            throw new UnsupportedOperationException("Attempting to access schema of Schemaless Struct. These structs should only be used for typing of StructReader data access calls.");
        }

        @Override
        public int getColumnIndex(java.lang.String fieldName) {
            throw new UnsupportedOperationException("Attempting to access schema of Schemaless Struct. These structs should only be used for typing of StructReader data access calls.");
        }

        public java.lang.String toString() {
            return this.getCode().name();
        }
    }

    @AutoValue
    public static abstract class Date
    implements Type,
    SqlType<com.google.cloud.Date> {
        public static Date create() {
            return DefaultInstances.DATE;
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.DATE;
        }

        public java.lang.String toString() {
            return this.getCode().name();
        }
    }

    @AutoValue
    public static abstract class Timestamp
    implements Type,
    SqlType<Instant> {
        public static Timestamp create() {
            return DefaultInstances.TIMESTAMP;
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.TIMESTAMP;
        }

        public java.lang.String toString() {
            return this.getCode().name();
        }
    }

    @AutoValue
    public static abstract class Bool
    implements Type,
    SqlType<Boolean> {
        public static Bool create() {
            return DefaultInstances.BOOL;
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.BOOL;
        }

        public java.lang.String toString() {
            return this.getCode().name();
        }
    }

    @AutoValue
    public static abstract class Float32
    implements Type,
    SqlType<Float> {
        public static Float32 create() {
            return DefaultInstances.FLOAT32;
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.FLOAT32;
        }

        public java.lang.String toString() {
            return this.getCode().name();
        }
    }

    @AutoValue
    public static abstract class Float64
    implements Type,
    SqlType<Double> {
        public static Float64 create() {
            return DefaultInstances.FLOAT64;
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.FLOAT64;
        }

        public java.lang.String toString() {
            return this.getCode().name();
        }
    }

    @AutoValue
    public static abstract class Int64
    implements Type,
    SqlType<Long> {
        public static Int64 create() {
            return DefaultInstances.INT64;
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.INT64;
        }

        public java.lang.String toString() {
            return this.getCode().name();
        }
    }

    @AutoValue
    public static abstract class String
    implements Type,
    SqlType<java.lang.String> {
        public static String create() {
            return DefaultInstances.STRING;
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.STRING;
        }

        public java.lang.String toString() {
            return this.getCode().name();
        }
    }

    @AutoValue
    public static abstract class Bytes
    implements Type,
    SqlType<ByteString> {
        public static Bytes create() {
            return DefaultInstances.BYTES;
        }

        @Override
        public SqlType.Code getCode() {
            return SqlType.Code.BYTES;
        }

        public java.lang.String toString() {
            return this.getCode().name();
        }
    }
}

