/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.budgets.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.budgets.v1.Budget;
import com.google.cloud.billing.budgets.v1.BudgetServiceClient;
import com.google.cloud.billing.budgets.v1.CreateBudgetRequest;
import com.google.cloud.billing.budgets.v1.DeleteBudgetRequest;
import com.google.cloud.billing.budgets.v1.GetBudgetRequest;
import com.google.cloud.billing.budgets.v1.ListBudgetsRequest;
import com.google.cloud.billing.budgets.v1.ListBudgetsResponse;
import com.google.cloud.billing.budgets.v1.UpdateBudgetRequest;
import com.google.cloud.billing.budgets.v1.stub.BudgetServiceStub;
import com.google.cloud.billing.budgets.v1.stub.BudgetServiceStubSettings;
import com.google.cloud.billing.budgets.v1.stub.HttpJsonBudgetServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonBudgetServiceStub
extends BudgetServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateBudgetRequest, Budget> createBudgetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.budgets.v1.BudgetService/CreateBudget").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=billingAccounts/*}/budgets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("budget", (Message)request.getBudget(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Budget.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateBudgetRequest, Budget> updateBudgetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.budgets.v1.BudgetService/UpdateBudget").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{budget.name=billingAccounts/*/budgets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "budget.name", (Object)request.getBudget().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("budget", (Message)request.getBudget(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Budget.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetBudgetRequest, Budget> getBudgetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.budgets.v1.BudgetService/GetBudget").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=billingAccounts/*/budgets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Budget.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListBudgetsRequest, ListBudgetsResponse> listBudgetsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.budgets.v1.BudgetService/ListBudgets").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=billingAccounts/*}/budgets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBudgetsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteBudgetRequest, Empty> deleteBudgetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.billing.budgets.v1.BudgetService/DeleteBudget").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=billingAccounts/*/budgets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateBudgetRequest, Budget> createBudgetCallable;
    private final UnaryCallable<UpdateBudgetRequest, Budget> updateBudgetCallable;
    private final UnaryCallable<GetBudgetRequest, Budget> getBudgetCallable;
    private final UnaryCallable<ListBudgetsRequest, ListBudgetsResponse> listBudgetsCallable;
    private final UnaryCallable<ListBudgetsRequest, BudgetServiceClient.ListBudgetsPagedResponse> listBudgetsPagedCallable;
    private final UnaryCallable<DeleteBudgetRequest, Empty> deleteBudgetCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonBudgetServiceStub create(BudgetServiceStubSettings settings) throws IOException {
        return new HttpJsonBudgetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonBudgetServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonBudgetServiceStub(BudgetServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonBudgetServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonBudgetServiceStub(BudgetServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonBudgetServiceStub(BudgetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonBudgetServiceCallableFactory());
    }

    protected HttpJsonBudgetServiceStub(BudgetServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createBudgetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createBudgetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateBudgetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateBudgetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getBudgetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBudgetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listBudgetsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBudgetsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteBudgetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteBudgetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createBudgetCallable = callableFactory.createUnaryCallable(createBudgetTransportSettings, settings.createBudgetSettings(), clientContext);
        this.updateBudgetCallable = callableFactory.createUnaryCallable(updateBudgetTransportSettings, settings.updateBudgetSettings(), clientContext);
        this.getBudgetCallable = callableFactory.createUnaryCallable(getBudgetTransportSettings, settings.getBudgetSettings(), clientContext);
        this.listBudgetsCallable = callableFactory.createUnaryCallable(listBudgetsTransportSettings, settings.listBudgetsSettings(), clientContext);
        this.listBudgetsPagedCallable = callableFactory.createPagedCallable(listBudgetsTransportSettings, settings.listBudgetsSettings(), clientContext);
        this.deleteBudgetCallable = callableFactory.createUnaryCallable(deleteBudgetTransportSettings, settings.deleteBudgetSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createBudgetMethodDescriptor);
        methodDescriptors.add(updateBudgetMethodDescriptor);
        methodDescriptors.add(getBudgetMethodDescriptor);
        methodDescriptors.add(listBudgetsMethodDescriptor);
        methodDescriptors.add(deleteBudgetMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateBudgetRequest, Budget> createBudgetCallable() {
        return this.createBudgetCallable;
    }

    @Override
    public UnaryCallable<UpdateBudgetRequest, Budget> updateBudgetCallable() {
        return this.updateBudgetCallable;
    }

    @Override
    public UnaryCallable<GetBudgetRequest, Budget> getBudgetCallable() {
        return this.getBudgetCallable;
    }

    @Override
    public UnaryCallable<ListBudgetsRequest, ListBudgetsResponse> listBudgetsCallable() {
        return this.listBudgetsCallable;
    }

    @Override
    public UnaryCallable<ListBudgetsRequest, BudgetServiceClient.ListBudgetsPagedResponse> listBudgetsPagedCallable() {
        return this.listBudgetsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteBudgetRequest, Empty> deleteBudgetCallable() {
        return this.deleteBudgetCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

