/*
 * Decompiled with CFR 0.152.
 */
package com.google.protos.google.cloud.binaryauthorization.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protos.google.cloud.binaryauthorization.v1.PolicyName;
import com.google.protos.google.cloud.binaryauthorization.v1.Resources;
import com.google.protos.google.cloud.binaryauthorization.v1.Service;
import com.google.protos.google.cloud.binaryauthorization.v1.SystemPolicyV1Settings;
import com.google.protos.google.cloud.binaryauthorization.v1.stub.SystemPolicyV1Stub;
import com.google.protos.google.cloud.binaryauthorization.v1.stub.SystemPolicyV1StubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class SystemPolicyV1Client
implements BackgroundResource {
    private final SystemPolicyV1Settings settings;
    private final SystemPolicyV1Stub stub;

    public static final SystemPolicyV1Client create() throws IOException {
        return SystemPolicyV1Client.create(SystemPolicyV1Settings.newBuilder().build());
    }

    public static final SystemPolicyV1Client create(SystemPolicyV1Settings settings) throws IOException {
        return new SystemPolicyV1Client(settings);
    }

    public static final SystemPolicyV1Client create(SystemPolicyV1Stub stub) {
        return new SystemPolicyV1Client(stub);
    }

    protected SystemPolicyV1Client(SystemPolicyV1Settings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SystemPolicyV1StubSettings)settings.getStubSettings()).createStub();
    }

    protected SystemPolicyV1Client(SystemPolicyV1Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SystemPolicyV1Settings getSettings() {
        return this.settings;
    }

    public SystemPolicyV1Stub getStub() {
        return this.stub;
    }

    public final Resources.Policy getSystemPolicy(PolicyName name) {
        Service.GetSystemPolicyRequest request = Service.GetSystemPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSystemPolicy(request);
    }

    public final Resources.Policy getSystemPolicy(String name) {
        Service.GetSystemPolicyRequest request = Service.GetSystemPolicyRequest.newBuilder().setName(name).build();
        return this.getSystemPolicy(request);
    }

    public final Resources.Policy getSystemPolicy(Service.GetSystemPolicyRequest request) {
        return (Resources.Policy)this.getSystemPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<Service.GetSystemPolicyRequest, Resources.Policy> getSystemPolicyCallable() {
        return this.stub.getSystemPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

