/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.GuestAttributesEntry;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class GuestAttributesValue
implements ApiMessage {
    private final List<GuestAttributesEntry> items;
    private static final GuestAttributesValue DEFAULT_INSTANCE = new GuestAttributesValue();

    private GuestAttributesValue() {
        this.items = null;
    }

    private GuestAttributesValue(List<GuestAttributesEntry> items) {
        this.items = items;
    }

    public Object getFieldValue(String fieldName) {
        if ("items".equals(fieldName)) {
            return this.items;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<GuestAttributesEntry> getItemsList() {
        return this.items;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GuestAttributesValue prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static GuestAttributesValue getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "GuestAttributesValue{items=" + this.items + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GuestAttributesValue) {
            GuestAttributesValue that = (GuestAttributesValue)o;
            return Objects.equals(this.items, that.getItemsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.items);
    }

    public static class Builder {
        private List<GuestAttributesEntry> items;

        Builder() {
        }

        public Builder mergeFrom(GuestAttributesValue other) {
            if (other == GuestAttributesValue.getDefaultInstance()) {
                return this;
            }
            if (other.getItemsList() != null) {
                this.items = other.items;
            }
            return this;
        }

        Builder(GuestAttributesValue source) {
            this.items = source.items;
        }

        public List<GuestAttributesEntry> getItemsList() {
            return this.items;
        }

        public Builder addAllItems(List<GuestAttributesEntry> items) {
            if (this.items == null) {
                this.items = new LinkedList<GuestAttributesEntry>();
            }
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(GuestAttributesEntry items) {
            if (this.items == null) {
                this.items = new LinkedList<GuestAttributesEntry>();
            }
            this.items.add(items);
            return this;
        }

        public GuestAttributesValue build() {
            return new GuestAttributesValue(this.items);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllItems(this.items);
            return newBuilder;
        }
    }
}

