/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.compute.v1;

import static com.google.cloud.compute.v1.TargetInstanceClient.AggregatedListTargetInstancesPagedResponse;
import static com.google.cloud.compute.v1.TargetInstanceClient.ListTargetInstancesPagedResponse;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.compute.v1.stub.TargetInstanceStubSettings;
import java.io.IOException;
import java.util.List;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS
/**
 * Settings class to configure an instance of {@link TargetInstanceClient}.
 *
 * <p>The default instance has everything set to sensible defaults:
 *
 * <ul>
 *   <li>The default service address (https://compute.googleapis.com/compute/v1/projects/) and
 *       default port (443) are used.
 *   <li>Credentials are acquired automatically through Application Default Credentials.
 *   <li>Retries are configured for idempotent methods but not for non-idempotent methods.
 * </ul>
 *
 * <p>The builder of this class is recursive, so contained classes are themselves builders. When
 * build() is called, the tree of builders is called to create the complete settings object.
 *
 * <p>For example, to set the total timeout of deleteTargetInstance to 30 seconds:
 *
 * <pre>
 * <code>
 * TargetInstanceSettings.Builder targetInstanceSettingsBuilder =
 *     TargetInstanceSettings.newBuilder();
 * targetInstanceSettingsBuilder
 *     .deleteTargetInstanceSettings()
 *     .setRetrySettings(
 *         targetInstanceSettingsBuilder.deleteTargetInstanceSettings().getRetrySettings().toBuilder()
 *             .setTotalTimeout(Duration.ofSeconds(30))
 *             .build());
 * TargetInstanceSettings targetInstanceSettings = targetInstanceSettingsBuilder.build();
 * </code>
 * </pre>
 */
@Generated("by gapic-generator")
@BetaApi
public class TargetInstanceSettings extends ClientSettings<TargetInstanceSettings> {
  /** Returns the object with the settings used for calls to aggregatedListTargetInstances. */
  public PagedCallSettings<
          AggregatedListTargetInstancesHttpRequest,
          TargetInstanceAggregatedList,
          AggregatedListTargetInstancesPagedResponse>
      aggregatedListTargetInstancesSettings() {
    return ((TargetInstanceStubSettings) getStubSettings()).aggregatedListTargetInstancesSettings();
  }

  /** Returns the object with the settings used for calls to deleteTargetInstance. */
  public UnaryCallSettings<DeleteTargetInstanceHttpRequest, Operation>
      deleteTargetInstanceSettings() {
    return ((TargetInstanceStubSettings) getStubSettings()).deleteTargetInstanceSettings();
  }

  /** Returns the object with the settings used for calls to getTargetInstance. */
  public UnaryCallSettings<GetTargetInstanceHttpRequest, TargetInstance>
      getTargetInstanceSettings() {
    return ((TargetInstanceStubSettings) getStubSettings()).getTargetInstanceSettings();
  }

  /** Returns the object with the settings used for calls to insertTargetInstance. */
  public UnaryCallSettings<InsertTargetInstanceHttpRequest, Operation>
      insertTargetInstanceSettings() {
    return ((TargetInstanceStubSettings) getStubSettings()).insertTargetInstanceSettings();
  }

  /** Returns the object with the settings used for calls to listTargetInstances. */
  public PagedCallSettings<
          ListTargetInstancesHttpRequest, TargetInstanceList, ListTargetInstancesPagedResponse>
      listTargetInstancesSettings() {
    return ((TargetInstanceStubSettings) getStubSettings()).listTargetInstancesSettings();
  }

  public static final TargetInstanceSettings create(TargetInstanceStubSettings stub)
      throws IOException {
    return new TargetInstanceSettings.Builder(stub.toBuilder()).build();
  }

  /** Returns a builder for the default ExecutorProvider for this service. */
  public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
    return TargetInstanceStubSettings.defaultExecutorProviderBuilder();
  }

  /** Returns the default service endpoint. */
  public static String getDefaultEndpoint() {
    return TargetInstanceStubSettings.getDefaultEndpoint();
  }
  /** Returns the default service port. */
  public static int getDefaultServicePort() {
    return TargetInstanceStubSettings.getDefaultServicePort();
  }

  /** Returns the default service scopes. */
  public static List<String> getDefaultServiceScopes() {
    return TargetInstanceStubSettings.getDefaultServiceScopes();
  }

  /** Returns a builder for the default credentials for this service. */
  public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
    return TargetInstanceStubSettings.defaultCredentialsProviderBuilder();
  }

  /** Returns a builder for the default ChannelProvider for this service. */
  public static InstantiatingHttpJsonChannelProvider.Builder
      defaultHttpJsonTransportProviderBuilder() {
    return TargetInstanceStubSettings.defaultHttpJsonTransportProviderBuilder();
  }

  public static TransportChannelProvider defaultTransportChannelProvider() {
    return TargetInstanceStubSettings.defaultTransportChannelProvider();
  }

  @BetaApi("The surface for customizing headers is not stable yet and may change in the future.")
  public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
    return TargetInstanceStubSettings.defaultApiClientHeaderProviderBuilder();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder() {
    return Builder.createDefault();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder(ClientContext clientContext) {
    return new Builder(clientContext);
  }

  /** Returns a builder containing all the values of this settings class. */
  public Builder toBuilder() {
    return new Builder(this);
  }

  protected TargetInstanceSettings(Builder settingsBuilder) throws IOException {
    super(settingsBuilder);
  }

  /** Builder for TargetInstanceSettings. */
  public static class Builder extends ClientSettings.Builder<TargetInstanceSettings, Builder> {
    protected Builder() throws IOException {
      this((ClientContext) null);
    }

    protected Builder(ClientContext clientContext) {
      super(TargetInstanceStubSettings.newBuilder(clientContext));
    }

    private static Builder createDefault() {
      return new Builder(TargetInstanceStubSettings.newBuilder());
    }

    protected Builder(TargetInstanceSettings settings) {
      super(settings.getStubSettings().toBuilder());
    }

    protected Builder(TargetInstanceStubSettings.Builder stubSettings) {
      super(stubSettings);
    }

    public TargetInstanceStubSettings.Builder getStubSettingsBuilder() {
      return ((TargetInstanceStubSettings.Builder) getStubSettings());
    }

    // NEXT_MAJOR_VER: remove 'throws Exception'
    /**
     * Applies the given settings updater function to all of the unary API methods in this service.
     *
     * <p>Note: This method does not support applying settings to streaming methods.
     */
    public Builder applyToAllUnaryMethods(
        ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
      super.applyToAllUnaryMethods(
          getStubSettingsBuilder().unaryMethodSettingsBuilders(), settingsUpdater);
      return this;
    }

    /** Returns the builder for the settings used for calls to aggregatedListTargetInstances. */
    public PagedCallSettings.Builder<
            AggregatedListTargetInstancesHttpRequest,
            TargetInstanceAggregatedList,
            AggregatedListTargetInstancesPagedResponse>
        aggregatedListTargetInstancesSettings() {
      return getStubSettingsBuilder().aggregatedListTargetInstancesSettings();
    }

    /** Returns the builder for the settings used for calls to deleteTargetInstance. */
    public UnaryCallSettings.Builder<DeleteTargetInstanceHttpRequest, Operation>
        deleteTargetInstanceSettings() {
      return getStubSettingsBuilder().deleteTargetInstanceSettings();
    }

    /** Returns the builder for the settings used for calls to getTargetInstance. */
    public UnaryCallSettings.Builder<GetTargetInstanceHttpRequest, TargetInstance>
        getTargetInstanceSettings() {
      return getStubSettingsBuilder().getTargetInstanceSettings();
    }

    /** Returns the builder for the settings used for calls to insertTargetInstance. */
    public UnaryCallSettings.Builder<InsertTargetInstanceHttpRequest, Operation>
        insertTargetInstanceSettings() {
      return getStubSettingsBuilder().insertTargetInstanceSettings();
    }

    /** Returns the builder for the settings used for calls to listTargetInstances. */
    public PagedCallSettings.Builder<
            ListTargetInstancesHttpRequest, TargetInstanceList, ListTargetInstancesPagedResponse>
        listTargetInstancesSettings() {
      return getStubSettingsBuilder().listTargetInstancesSettings();
    }

    @Override
    public TargetInstanceSettings build() throws IOException {
      return new TargetInstanceSettings(this);
    }
  }
}
