/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.compute.v1.stub;

import static com.google.cloud.compute.v1.HttpsHealthCheckClient.ListHttpsHealthChecksPagedResponse;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HttpsHealthCheck2;
import com.google.cloud.compute.v1.HttpsHealthCheckList;
import com.google.cloud.compute.v1.InsertHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListHttpsHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.UpdateHttpsHealthCheckHttpRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.annotation.Generated;
import org.threeten.bp.Duration;

// AUTO-GENERATED DOCUMENTATION AND CLASS
/**
 * Settings class to configure an instance of {@link HttpsHealthCheckStub}.
 *
 * <p>The default instance has everything set to sensible defaults:
 *
 * <ul>
 *   <li>The default service address (https://compute.googleapis.com/compute/v1/projects/) and
 *       default port (443) are used.
 *   <li>Credentials are acquired automatically through Application Default Credentials.
 *   <li>Retries are configured for idempotent methods but not for non-idempotent methods.
 * </ul>
 *
 * <p>The builder of this class is recursive, so contained classes are themselves builders. When
 * build() is called, the tree of builders is called to create the complete settings object.
 *
 * <p>For example, to set the total timeout of deleteHttpsHealthCheck to 30 seconds:
 *
 * <pre>
 * <code>
 * HttpsHealthCheckStubSettings.Builder httpsHealthCheckSettingsBuilder =
 *     HttpsHealthCheckStubSettings.newBuilder();
 * httpsHealthCheckSettingsBuilder
 *     .deleteHttpsHealthCheckSettings()
 *     .setRetrySettings(
 *         httpsHealthCheckSettingsBuilder.deleteHttpsHealthCheckSettings().getRetrySettings().toBuilder()
 *             .setTotalTimeout(Duration.ofSeconds(30))
 *             .build());
 * HttpsHealthCheckStubSettings httpsHealthCheckSettings = httpsHealthCheckSettingsBuilder.build();
 * </code>
 * </pre>
 */
@Generated("by gapic-generator")
@BetaApi
public class HttpsHealthCheckStubSettings extends StubSettings<HttpsHealthCheckStubSettings> {
  /** The default scopes of the service. */
  private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES =
      ImmutableList.<String>builder()
          .add("https://www.googleapis.com/auth/cloud-platform")
          .add("https://www.googleapis.com/auth/compute")
          .add("https://www.googleapis.com/auth/compute.readonly")
          .add("https://www.googleapis.com/auth/devstorage.full_control")
          .add("https://www.googleapis.com/auth/devstorage.read_only")
          .add("https://www.googleapis.com/auth/devstorage.read_write")
          .build();

  private final UnaryCallSettings<DeleteHttpsHealthCheckHttpRequest, Operation>
      deleteHttpsHealthCheckSettings;
  private final UnaryCallSettings<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2>
      getHttpsHealthCheckSettings;
  private final UnaryCallSettings<InsertHttpsHealthCheckHttpRequest, Operation>
      insertHttpsHealthCheckSettings;
  private final PagedCallSettings<
          ListHttpsHealthChecksHttpRequest,
          HttpsHealthCheckList,
          ListHttpsHealthChecksPagedResponse>
      listHttpsHealthChecksSettings;
  private final UnaryCallSettings<PatchHttpsHealthCheckHttpRequest, Operation>
      patchHttpsHealthCheckSettings;
  private final UnaryCallSettings<UpdateHttpsHealthCheckHttpRequest, Operation>
      updateHttpsHealthCheckSettings;

  /** Returns the object with the settings used for calls to deleteHttpsHealthCheck. */
  public UnaryCallSettings<DeleteHttpsHealthCheckHttpRequest, Operation>
      deleteHttpsHealthCheckSettings() {
    return deleteHttpsHealthCheckSettings;
  }

  /** Returns the object with the settings used for calls to getHttpsHealthCheck. */
  public UnaryCallSettings<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2>
      getHttpsHealthCheckSettings() {
    return getHttpsHealthCheckSettings;
  }

  /** Returns the object with the settings used for calls to insertHttpsHealthCheck. */
  public UnaryCallSettings<InsertHttpsHealthCheckHttpRequest, Operation>
      insertHttpsHealthCheckSettings() {
    return insertHttpsHealthCheckSettings;
  }

  /** Returns the object with the settings used for calls to listHttpsHealthChecks. */
  public PagedCallSettings<
          ListHttpsHealthChecksHttpRequest,
          HttpsHealthCheckList,
          ListHttpsHealthChecksPagedResponse>
      listHttpsHealthChecksSettings() {
    return listHttpsHealthChecksSettings;
  }

  /** Returns the object with the settings used for calls to patchHttpsHealthCheck. */
  public UnaryCallSettings<PatchHttpsHealthCheckHttpRequest, Operation>
      patchHttpsHealthCheckSettings() {
    return patchHttpsHealthCheckSettings;
  }

  /** Returns the object with the settings used for calls to updateHttpsHealthCheck. */
  public UnaryCallSettings<UpdateHttpsHealthCheckHttpRequest, Operation>
      updateHttpsHealthCheckSettings() {
    return updateHttpsHealthCheckSettings;
  }

  @BetaApi("A restructuring of stub classes is planned, so this may break in the future")
  public HttpsHealthCheckStub createStub() throws IOException {
    if (getTransportChannelProvider()
        .getTransportName()
        .equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
      return HttpJsonHttpsHealthCheckStub.create(this);
    } else {
      throw new UnsupportedOperationException(
          "Transport not supported: " + getTransportChannelProvider().getTransportName());
    }
  }

  /** Returns a builder for the default ExecutorProvider for this service. */
  public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
    return InstantiatingExecutorProvider.newBuilder();
  }

  /** Returns the default service endpoint. */
  public static String getDefaultEndpoint() {
    return "https://compute.googleapis.com/compute/v1/projects/";
  }

  /** Returns the default service port. */
  public static int getDefaultServicePort() {
    return 443;
  }

  /** Returns the default service scopes. */
  public static List<String> getDefaultServiceScopes() {
    return DEFAULT_SERVICE_SCOPES;
  }

  /** Returns a builder for the default credentials for this service. */
  public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
    return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
  }

  /** Returns a builder for the default ChannelProvider for this service. */
  public static InstantiatingHttpJsonChannelProvider.Builder
      defaultHttpJsonTransportProviderBuilder() {
    return InstantiatingHttpJsonChannelProvider.newBuilder();
  }

  public static TransportChannelProvider defaultTransportChannelProvider() {
    return defaultHttpJsonTransportProviderBuilder().build();
  }

  @BetaApi("The surface for customizing headers is not stable yet and may change in the future.")
  public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
    return ApiClientHeaderProvider.newBuilder()
        .setGeneratedLibToken(
            "gapic", GaxProperties.getLibraryVersion(HttpsHealthCheckStubSettings.class))
        .setTransportToken(
            GaxHttpJsonProperties.getHttpJsonTokenName(),
            GaxHttpJsonProperties.getHttpJsonVersion());
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder() {
    return Builder.createDefault();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder(ClientContext clientContext) {
    return new Builder(clientContext);
  }

  /** Returns a builder containing all the values of this settings class. */
  public Builder toBuilder() {
    return new Builder(this);
  }

  protected HttpsHealthCheckStubSettings(Builder settingsBuilder) throws IOException {
    super(settingsBuilder);

    deleteHttpsHealthCheckSettings = settingsBuilder.deleteHttpsHealthCheckSettings().build();
    getHttpsHealthCheckSettings = settingsBuilder.getHttpsHealthCheckSettings().build();
    insertHttpsHealthCheckSettings = settingsBuilder.insertHttpsHealthCheckSettings().build();
    listHttpsHealthChecksSettings = settingsBuilder.listHttpsHealthChecksSettings().build();
    patchHttpsHealthCheckSettings = settingsBuilder.patchHttpsHealthCheckSettings().build();
    updateHttpsHealthCheckSettings = settingsBuilder.updateHttpsHealthCheckSettings().build();
  }

  private static final PagedListDescriptor<
          ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2>
      LIST_HTTPS_HEALTH_CHECKS_PAGE_STR_DESC =
          new PagedListDescriptor<
              ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2>() {
            @Override
            public String emptyToken() {
              return "";
            }

            @Override
            public ListHttpsHealthChecksHttpRequest injectToken(
                ListHttpsHealthChecksHttpRequest payload, String token) {
              return ListHttpsHealthChecksHttpRequest.newBuilder(payload)
                  .setPageToken(token)
                  .build();
            }

            @Override
            public ListHttpsHealthChecksHttpRequest injectPageSize(
                ListHttpsHealthChecksHttpRequest payload, int pageSize) {
              return ListHttpsHealthChecksHttpRequest.newBuilder(payload)
                  .setMaxResults(pageSize)
                  .build();
            }

            @Override
            public Integer extractPageSize(ListHttpsHealthChecksHttpRequest payload) {
              return payload.getMaxResults();
            }

            @Override
            public String extractNextToken(HttpsHealthCheckList payload) {
              return payload.getNextPageToken();
            }

            @Override
            public Iterable<HttpsHealthCheck2> extractResources(HttpsHealthCheckList payload) {
              return payload.getItemsList() != null
                  ? payload.getItemsList()
                  : ImmutableList.<HttpsHealthCheck2>of();
            }
          };

  private static final PagedListResponseFactory<
          ListHttpsHealthChecksHttpRequest,
          HttpsHealthCheckList,
          ListHttpsHealthChecksPagedResponse>
      LIST_HTTPS_HEALTH_CHECKS_PAGE_STR_FACT =
          new PagedListResponseFactory<
              ListHttpsHealthChecksHttpRequest,
              HttpsHealthCheckList,
              ListHttpsHealthChecksPagedResponse>() {
            @Override
            public ApiFuture<ListHttpsHealthChecksPagedResponse> getFuturePagedResponse(
                UnaryCallable<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList> callable,
                ListHttpsHealthChecksHttpRequest request,
                ApiCallContext context,
                ApiFuture<HttpsHealthCheckList> futureResponse) {
              PageContext<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2>
                  pageContext =
                      PageContext.create(
                          callable, LIST_HTTPS_HEALTH_CHECKS_PAGE_STR_DESC, request, context);
              return ListHttpsHealthChecksPagedResponse.createAsync(pageContext, futureResponse);
            }
          };

  /** Builder for HttpsHealthCheckStubSettings. */
  public static class Builder extends StubSettings.Builder<HttpsHealthCheckStubSettings, Builder> {
    private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;

    private final UnaryCallSettings.Builder<DeleteHttpsHealthCheckHttpRequest, Operation>
        deleteHttpsHealthCheckSettings;
    private final UnaryCallSettings.Builder<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2>
        getHttpsHealthCheckSettings;
    private final UnaryCallSettings.Builder<InsertHttpsHealthCheckHttpRequest, Operation>
        insertHttpsHealthCheckSettings;
    private final PagedCallSettings.Builder<
            ListHttpsHealthChecksHttpRequest,
            HttpsHealthCheckList,
            ListHttpsHealthChecksPagedResponse>
        listHttpsHealthChecksSettings;
    private final UnaryCallSettings.Builder<PatchHttpsHealthCheckHttpRequest, Operation>
        patchHttpsHealthCheckSettings;
    private final UnaryCallSettings.Builder<UpdateHttpsHealthCheckHttpRequest, Operation>
        updateHttpsHealthCheckSettings;

    private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>>
        RETRYABLE_CODE_DEFINITIONS;

    static {
      ImmutableMap.Builder<String, ImmutableSet<StatusCode.Code>> definitions =
          ImmutableMap.builder();
      definitions.put(
          "idempotent",
          ImmutableSet.copyOf(
              Lists.<StatusCode.Code>newArrayList(
                  StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE)));
      definitions.put("non_idempotent", ImmutableSet.copyOf(Lists.<StatusCode.Code>newArrayList()));
      RETRYABLE_CODE_DEFINITIONS = definitions.build();
    }

    private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

    static {
      ImmutableMap.Builder<String, RetrySettings> definitions = ImmutableMap.builder();
      RetrySettings settings = null;
      settings =
          RetrySettings.newBuilder()
              .setInitialRetryDelay(Duration.ofMillis(100L))
              .setRetryDelayMultiplier(1.3)
              .setMaxRetryDelay(Duration.ofMillis(60000L))
              .setInitialRpcTimeout(Duration.ofMillis(20000L))
              .setRpcTimeoutMultiplier(1.0)
              .setMaxRpcTimeout(Duration.ofMillis(20000L))
              .setTotalTimeout(Duration.ofMillis(600000L))
              .build();
      definitions.put("default", settings);
      RETRY_PARAM_DEFINITIONS = definitions.build();
    }

    protected Builder() {
      this((ClientContext) null);
    }

    protected Builder(ClientContext clientContext) {
      super(clientContext);

      deleteHttpsHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();

      getHttpsHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();

      insertHttpsHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();

      listHttpsHealthChecksSettings =
          PagedCallSettings.newBuilder(LIST_HTTPS_HEALTH_CHECKS_PAGE_STR_FACT);

      patchHttpsHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();

      updateHttpsHealthCheckSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();

      unaryMethodSettingsBuilders =
          ImmutableList.<UnaryCallSettings.Builder<?, ?>>of(
              deleteHttpsHealthCheckSettings,
              getHttpsHealthCheckSettings,
              insertHttpsHealthCheckSettings,
              listHttpsHealthChecksSettings,
              patchHttpsHealthCheckSettings,
              updateHttpsHealthCheckSettings);

      initDefaults(this);
    }

    private static Builder createDefault() {
      Builder builder = new Builder((ClientContext) null);
      builder.setTransportChannelProvider(defaultTransportChannelProvider());
      builder.setCredentialsProvider(defaultCredentialsProviderBuilder().build());
      builder.setInternalHeaderProvider(defaultApiClientHeaderProviderBuilder().build());
      builder.setEndpoint(getDefaultEndpoint());
      return initDefaults(builder);
    }

    private static Builder initDefaults(Builder builder) {

      builder
          .deleteHttpsHealthCheckSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("idempotent"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));

      builder
          .getHttpsHealthCheckSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("idempotent"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));

      builder
          .insertHttpsHealthCheckSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("non_idempotent"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));

      builder
          .listHttpsHealthChecksSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("idempotent"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));

      builder
          .patchHttpsHealthCheckSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("non_idempotent"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));

      builder
          .updateHttpsHealthCheckSettings()
          .setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("idempotent"))
          .setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));

      return builder;
    }

    protected Builder(HttpsHealthCheckStubSettings settings) {
      super(settings);

      deleteHttpsHealthCheckSettings = settings.deleteHttpsHealthCheckSettings.toBuilder();
      getHttpsHealthCheckSettings = settings.getHttpsHealthCheckSettings.toBuilder();
      insertHttpsHealthCheckSettings = settings.insertHttpsHealthCheckSettings.toBuilder();
      listHttpsHealthChecksSettings = settings.listHttpsHealthChecksSettings.toBuilder();
      patchHttpsHealthCheckSettings = settings.patchHttpsHealthCheckSettings.toBuilder();
      updateHttpsHealthCheckSettings = settings.updateHttpsHealthCheckSettings.toBuilder();

      unaryMethodSettingsBuilders =
          ImmutableList.<UnaryCallSettings.Builder<?, ?>>of(
              deleteHttpsHealthCheckSettings,
              getHttpsHealthCheckSettings,
              insertHttpsHealthCheckSettings,
              listHttpsHealthChecksSettings,
              patchHttpsHealthCheckSettings,
              updateHttpsHealthCheckSettings);
    }

    // NEXT_MAJOR_VER: remove 'throws Exception'
    /**
     * Applies the given settings updater function to all of the unary API methods in this service.
     *
     * <p>Note: This method does not support applying settings to streaming methods.
     */
    public Builder applyToAllUnaryMethods(
        ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
      super.applyToAllUnaryMethods(unaryMethodSettingsBuilders, settingsUpdater);
      return this;
    }

    public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
      return unaryMethodSettingsBuilders;
    }

    /** Returns the builder for the settings used for calls to deleteHttpsHealthCheck. */
    public UnaryCallSettings.Builder<DeleteHttpsHealthCheckHttpRequest, Operation>
        deleteHttpsHealthCheckSettings() {
      return deleteHttpsHealthCheckSettings;
    }

    /** Returns the builder for the settings used for calls to getHttpsHealthCheck. */
    public UnaryCallSettings.Builder<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2>
        getHttpsHealthCheckSettings() {
      return getHttpsHealthCheckSettings;
    }

    /** Returns the builder for the settings used for calls to insertHttpsHealthCheck. */
    public UnaryCallSettings.Builder<InsertHttpsHealthCheckHttpRequest, Operation>
        insertHttpsHealthCheckSettings() {
      return insertHttpsHealthCheckSettings;
    }

    /** Returns the builder for the settings used for calls to listHttpsHealthChecks. */
    public PagedCallSettings.Builder<
            ListHttpsHealthChecksHttpRequest,
            HttpsHealthCheckList,
            ListHttpsHealthChecksPagedResponse>
        listHttpsHealthChecksSettings() {
      return listHttpsHealthChecksSettings;
    }

    /** Returns the builder for the settings used for calls to patchHttpsHealthCheck. */
    public UnaryCallSettings.Builder<PatchHttpsHealthCheckHttpRequest, Operation>
        patchHttpsHealthCheckSettings() {
      return patchHttpsHealthCheckSettings;
    }

    /** Returns the builder for the settings used for calls to updateHttpsHealthCheck. */
    public UnaryCallSettings.Builder<UpdateHttpsHealthCheckHttpRequest, Operation>
        updateHttpsHealthCheckSettings() {
      return updateHttpsHealthCheckSettings;
    }

    @Override
    public HttpsHealthCheckStubSettings build() throws IOException {
      return new HttpsHealthCheckStubSettings(this);
    }
  }
}
