/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionSslCertificateName
implements ResourceName {
    private final String project;
    private final String region;
    private final String sslCertificate;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/sslCertificates/{sslCertificate}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionSslCertificateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.sslCertificate = (String)Preconditions.checkNotNull((Object)builder.getSslCertificate());
    }

    public static ProjectRegionSslCertificateName of(String project, String region, String sslCertificate) {
        return ProjectRegionSslCertificateName.newBuilder().setProject(project).setRegion(region).setSslCertificate(sslCertificate).build();
    }

    public static String format(String project, String region, String sslCertificate) {
        return ProjectRegionSslCertificateName.of(project, region, sslCertificate).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSslCertificate() {
        return this.sslCertificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionSslCertificateName projectRegionSslCertificateName = this;
            synchronized (projectRegionSslCertificateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"sslCertificate", (Object)this.sslCertificate);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionSslCertificateName> newFactory() {
        return new ResourceNameFactory<ProjectRegionSslCertificateName>(){

            public ProjectRegionSslCertificateName parse(String formattedString) {
                return ProjectRegionSslCertificateName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionSslCertificateName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionSslCertificateName.parse: formattedString not in valid format");
        return ProjectRegionSslCertificateName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("sslCertificate"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "sslCertificate", this.sslCertificate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionSslCertificateName) {
            ProjectRegionSslCertificateName that = (ProjectRegionSslCertificateName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.sslCertificate, that.getSslCertificate());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.sslCertificate);
    }

    public static class Builder {
        private String project;
        private String region;
        private String sslCertificate;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getSslCertificate() {
            return this.sslCertificate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setSslCertificate(String sslCertificate) {
            this.sslCertificate = sslCertificate;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionSslCertificateName projectRegionSslCertificateName) {
            this.project = projectRegionSslCertificateName.project;
            this.region = projectRegionSslCertificateName.region;
            this.sslCertificate = projectRegionSslCertificateName.sslCertificate;
        }

        public ProjectRegionSslCertificateName build() {
            return new ProjectRegionSslCertificateName(this);
        }
    }
}

