/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class RouterStatusNatStatus
implements ApiMessage {
    private final List<String> autoAllocatedNatIps;
    private final List<String> drainAutoAllocatedNatIps;
    private final List<String> drainUserAllocatedNatIps;
    private final Integer minExtraNatIpsNeeded;
    private final String name;
    private final Integer numVmEndpointsWithNatMappings;
    private final List<String> userAllocatedNatIpResources;
    private final List<String> userAllocatedNatIps;
    private static final RouterStatusNatStatus DEFAULT_INSTANCE = new RouterStatusNatStatus();

    private RouterStatusNatStatus() {
        this.autoAllocatedNatIps = null;
        this.drainAutoAllocatedNatIps = null;
        this.drainUserAllocatedNatIps = null;
        this.minExtraNatIpsNeeded = null;
        this.name = null;
        this.numVmEndpointsWithNatMappings = null;
        this.userAllocatedNatIpResources = null;
        this.userAllocatedNatIps = null;
    }

    private RouterStatusNatStatus(List<String> autoAllocatedNatIps, List<String> drainAutoAllocatedNatIps, List<String> drainUserAllocatedNatIps, Integer minExtraNatIpsNeeded, String name, Integer numVmEndpointsWithNatMappings, List<String> userAllocatedNatIpResources, List<String> userAllocatedNatIps) {
        this.autoAllocatedNatIps = autoAllocatedNatIps;
        this.drainAutoAllocatedNatIps = drainAutoAllocatedNatIps;
        this.drainUserAllocatedNatIps = drainUserAllocatedNatIps;
        this.minExtraNatIpsNeeded = minExtraNatIpsNeeded;
        this.name = name;
        this.numVmEndpointsWithNatMappings = numVmEndpointsWithNatMappings;
        this.userAllocatedNatIpResources = userAllocatedNatIpResources;
        this.userAllocatedNatIps = userAllocatedNatIps;
    }

    public Object getFieldValue(String fieldName) {
        if ("autoAllocatedNatIps".equals(fieldName)) {
            return this.autoAllocatedNatIps;
        }
        if ("drainAutoAllocatedNatIps".equals(fieldName)) {
            return this.drainAutoAllocatedNatIps;
        }
        if ("drainUserAllocatedNatIps".equals(fieldName)) {
            return this.drainUserAllocatedNatIps;
        }
        if ("minExtraNatIpsNeeded".equals(fieldName)) {
            return this.minExtraNatIpsNeeded;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("numVmEndpointsWithNatMappings".equals(fieldName)) {
            return this.numVmEndpointsWithNatMappings;
        }
        if ("userAllocatedNatIpResources".equals(fieldName)) {
            return this.userAllocatedNatIpResources;
        }
        if ("userAllocatedNatIps".equals(fieldName)) {
            return this.userAllocatedNatIps;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getAutoAllocatedNatIpsList() {
        return this.autoAllocatedNatIps;
    }

    public List<String> getDrainAutoAllocatedNatIpsList() {
        return this.drainAutoAllocatedNatIps;
    }

    public List<String> getDrainUserAllocatedNatIpsList() {
        return this.drainUserAllocatedNatIps;
    }

    public Integer getMinExtraNatIpsNeeded() {
        return this.minExtraNatIpsNeeded;
    }

    public String getName() {
        return this.name;
    }

    public Integer getNumVmEndpointsWithNatMappings() {
        return this.numVmEndpointsWithNatMappings;
    }

    public List<String> getUserAllocatedNatIpResourcesList() {
        return this.userAllocatedNatIpResources;
    }

    public List<String> getUserAllocatedNatIpsList() {
        return this.userAllocatedNatIps;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RouterStatusNatStatus prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static RouterStatusNatStatus getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "RouterStatusNatStatus{autoAllocatedNatIps=" + this.autoAllocatedNatIps + ", drainAutoAllocatedNatIps=" + this.drainAutoAllocatedNatIps + ", drainUserAllocatedNatIps=" + this.drainUserAllocatedNatIps + ", minExtraNatIpsNeeded=" + this.minExtraNatIpsNeeded + ", name=" + this.name + ", numVmEndpointsWithNatMappings=" + this.numVmEndpointsWithNatMappings + ", userAllocatedNatIpResources=" + this.userAllocatedNatIpResources + ", userAllocatedNatIps=" + this.userAllocatedNatIps + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RouterStatusNatStatus) {
            RouterStatusNatStatus that = (RouterStatusNatStatus)o;
            return Objects.equals(this.autoAllocatedNatIps, that.getAutoAllocatedNatIpsList()) && Objects.equals(this.drainAutoAllocatedNatIps, that.getDrainAutoAllocatedNatIpsList()) && Objects.equals(this.drainUserAllocatedNatIps, that.getDrainUserAllocatedNatIpsList()) && Objects.equals(this.minExtraNatIpsNeeded, that.getMinExtraNatIpsNeeded()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.numVmEndpointsWithNatMappings, that.getNumVmEndpointsWithNatMappings()) && Objects.equals(this.userAllocatedNatIpResources, that.getUserAllocatedNatIpResourcesList()) && Objects.equals(this.userAllocatedNatIps, that.getUserAllocatedNatIpsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.autoAllocatedNatIps, this.drainAutoAllocatedNatIps, this.drainUserAllocatedNatIps, this.minExtraNatIpsNeeded, this.name, this.numVmEndpointsWithNatMappings, this.userAllocatedNatIpResources, this.userAllocatedNatIps);
    }

    public static class Builder {
        private List<String> autoAllocatedNatIps;
        private List<String> drainAutoAllocatedNatIps;
        private List<String> drainUserAllocatedNatIps;
        private Integer minExtraNatIpsNeeded;
        private String name;
        private Integer numVmEndpointsWithNatMappings;
        private List<String> userAllocatedNatIpResources;
        private List<String> userAllocatedNatIps;

        Builder() {
        }

        public Builder mergeFrom(RouterStatusNatStatus other) {
            if (other == RouterStatusNatStatus.getDefaultInstance()) {
                return this;
            }
            if (other.getAutoAllocatedNatIpsList() != null) {
                this.autoAllocatedNatIps = other.autoAllocatedNatIps;
            }
            if (other.getDrainAutoAllocatedNatIpsList() != null) {
                this.drainAutoAllocatedNatIps = other.drainAutoAllocatedNatIps;
            }
            if (other.getDrainUserAllocatedNatIpsList() != null) {
                this.drainUserAllocatedNatIps = other.drainUserAllocatedNatIps;
            }
            if (other.getMinExtraNatIpsNeeded() != null) {
                this.minExtraNatIpsNeeded = other.minExtraNatIpsNeeded;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNumVmEndpointsWithNatMappings() != null) {
                this.numVmEndpointsWithNatMappings = other.numVmEndpointsWithNatMappings;
            }
            if (other.getUserAllocatedNatIpResourcesList() != null) {
                this.userAllocatedNatIpResources = other.userAllocatedNatIpResources;
            }
            if (other.getUserAllocatedNatIpsList() != null) {
                this.userAllocatedNatIps = other.userAllocatedNatIps;
            }
            return this;
        }

        Builder(RouterStatusNatStatus source) {
            this.autoAllocatedNatIps = source.autoAllocatedNatIps;
            this.drainAutoAllocatedNatIps = source.drainAutoAllocatedNatIps;
            this.drainUserAllocatedNatIps = source.drainUserAllocatedNatIps;
            this.minExtraNatIpsNeeded = source.minExtraNatIpsNeeded;
            this.name = source.name;
            this.numVmEndpointsWithNatMappings = source.numVmEndpointsWithNatMappings;
            this.userAllocatedNatIpResources = source.userAllocatedNatIpResources;
            this.userAllocatedNatIps = source.userAllocatedNatIps;
        }

        public List<String> getAutoAllocatedNatIpsList() {
            return this.autoAllocatedNatIps;
        }

        public Builder addAllAutoAllocatedNatIps(List<String> autoAllocatedNatIps) {
            if (this.autoAllocatedNatIps == null) {
                this.autoAllocatedNatIps = new LinkedList<String>();
            }
            this.autoAllocatedNatIps.addAll(autoAllocatedNatIps);
            return this;
        }

        public Builder addAutoAllocatedNatIps(String autoAllocatedNatIps) {
            if (this.autoAllocatedNatIps == null) {
                this.autoAllocatedNatIps = new LinkedList<String>();
            }
            this.autoAllocatedNatIps.add(autoAllocatedNatIps);
            return this;
        }

        public List<String> getDrainAutoAllocatedNatIpsList() {
            return this.drainAutoAllocatedNatIps;
        }

        public Builder addAllDrainAutoAllocatedNatIps(List<String> drainAutoAllocatedNatIps) {
            if (this.drainAutoAllocatedNatIps == null) {
                this.drainAutoAllocatedNatIps = new LinkedList<String>();
            }
            this.drainAutoAllocatedNatIps.addAll(drainAutoAllocatedNatIps);
            return this;
        }

        public Builder addDrainAutoAllocatedNatIps(String drainAutoAllocatedNatIps) {
            if (this.drainAutoAllocatedNatIps == null) {
                this.drainAutoAllocatedNatIps = new LinkedList<String>();
            }
            this.drainAutoAllocatedNatIps.add(drainAutoAllocatedNatIps);
            return this;
        }

        public List<String> getDrainUserAllocatedNatIpsList() {
            return this.drainUserAllocatedNatIps;
        }

        public Builder addAllDrainUserAllocatedNatIps(List<String> drainUserAllocatedNatIps) {
            if (this.drainUserAllocatedNatIps == null) {
                this.drainUserAllocatedNatIps = new LinkedList<String>();
            }
            this.drainUserAllocatedNatIps.addAll(drainUserAllocatedNatIps);
            return this;
        }

        public Builder addDrainUserAllocatedNatIps(String drainUserAllocatedNatIps) {
            if (this.drainUserAllocatedNatIps == null) {
                this.drainUserAllocatedNatIps = new LinkedList<String>();
            }
            this.drainUserAllocatedNatIps.add(drainUserAllocatedNatIps);
            return this;
        }

        public Integer getMinExtraNatIpsNeeded() {
            return this.minExtraNatIpsNeeded;
        }

        public Builder setMinExtraNatIpsNeeded(Integer minExtraNatIpsNeeded) {
            this.minExtraNatIpsNeeded = minExtraNatIpsNeeded;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Integer getNumVmEndpointsWithNatMappings() {
            return this.numVmEndpointsWithNatMappings;
        }

        public Builder setNumVmEndpointsWithNatMappings(Integer numVmEndpointsWithNatMappings) {
            this.numVmEndpointsWithNatMappings = numVmEndpointsWithNatMappings;
            return this;
        }

        public List<String> getUserAllocatedNatIpResourcesList() {
            return this.userAllocatedNatIpResources;
        }

        public Builder addAllUserAllocatedNatIpResources(List<String> userAllocatedNatIpResources) {
            if (this.userAllocatedNatIpResources == null) {
                this.userAllocatedNatIpResources = new LinkedList<String>();
            }
            this.userAllocatedNatIpResources.addAll(userAllocatedNatIpResources);
            return this;
        }

        public Builder addUserAllocatedNatIpResources(String userAllocatedNatIpResources) {
            if (this.userAllocatedNatIpResources == null) {
                this.userAllocatedNatIpResources = new LinkedList<String>();
            }
            this.userAllocatedNatIpResources.add(userAllocatedNatIpResources);
            return this;
        }

        public List<String> getUserAllocatedNatIpsList() {
            return this.userAllocatedNatIps;
        }

        public Builder addAllUserAllocatedNatIps(List<String> userAllocatedNatIps) {
            if (this.userAllocatedNatIps == null) {
                this.userAllocatedNatIps = new LinkedList<String>();
            }
            this.userAllocatedNatIps.addAll(userAllocatedNatIps);
            return this;
        }

        public Builder addUserAllocatedNatIps(String userAllocatedNatIps) {
            if (this.userAllocatedNatIps == null) {
                this.userAllocatedNatIps = new LinkedList<String>();
            }
            this.userAllocatedNatIps.add(userAllocatedNatIps);
            return this;
        }

        public RouterStatusNatStatus build() {
            return new RouterStatusNatStatus(this.autoAllocatedNatIps, this.drainAutoAllocatedNatIps, this.drainUserAllocatedNatIps, this.minExtraNatIpsNeeded, this.name, this.numVmEndpointsWithNatMappings, this.userAllocatedNatIpResources, this.userAllocatedNatIps);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAutoAllocatedNatIps(this.autoAllocatedNatIps);
            newBuilder.addAllDrainAutoAllocatedNatIps(this.drainAutoAllocatedNatIps);
            newBuilder.addAllDrainUserAllocatedNatIps(this.drainUserAllocatedNatIps);
            newBuilder.setMinExtraNatIpsNeeded(this.minExtraNatIpsNeeded);
            newBuilder.setName(this.name);
            newBuilder.setNumVmEndpointsWithNatMappings(this.numVmEndpointsWithNatMappings);
            newBuilder.addAllUserAllocatedNatIpResources(this.userAllocatedNatIpResources);
            newBuilder.addAllUserAllocatedNatIps(this.userAllocatedNatIps);
            return newBuilder;
        }
    }
}

