/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("by GAPIC")
@BetaApi
/**
 * Request object for method compute.instances.getSerialPortOutput. Returns the last 1 MB of serial
 * port output from the specified instance.
 */
public final class GetSerialPortOutputInstanceHttpRequest implements ApiMessage {
  private final String access_token;
  private final String callback;
  private final String fields;
  private final String instance;
  private final String key;
  private final Integer port;
  private final String prettyPrint;
  private final String quotaUser;
  private final String start;
  private final String userIp;

  private GetSerialPortOutputInstanceHttpRequest() {
    this.access_token = null;
    this.callback = null;
    this.fields = null;
    this.instance = null;
    this.key = null;
    this.port = null;
    this.prettyPrint = null;
    this.quotaUser = null;
    this.start = null;
    this.userIp = null;
  }

  private GetSerialPortOutputInstanceHttpRequest(
      String access_token,
      String callback,
      String fields,
      String instance,
      String key,
      Integer port,
      String prettyPrint,
      String quotaUser,
      String start,
      String userIp) {
    this.access_token = access_token;
    this.callback = callback;
    this.fields = fields;
    this.instance = instance;
    this.key = key;
    this.port = port;
    this.prettyPrint = prettyPrint;
    this.quotaUser = quotaUser;
    this.start = start;
    this.userIp = userIp;
  }

  @Override
  public Object getFieldValue(String fieldName) {
    if ("access_token".equals(fieldName)) {
      return access_token;
    }
    if ("callback".equals(fieldName)) {
      return callback;
    }
    if ("fields".equals(fieldName)) {
      return fields;
    }
    if ("instance".equals(fieldName)) {
      return instance;
    }
    if ("key".equals(fieldName)) {
      return key;
    }
    if ("port".equals(fieldName)) {
      return port;
    }
    if ("prettyPrint".equals(fieldName)) {
      return prettyPrint;
    }
    if ("quotaUser".equals(fieldName)) {
      return quotaUser;
    }
    if ("start".equals(fieldName)) {
      return start;
    }
    if ("userIp".equals(fieldName)) {
      return userIp;
    }
    return null;
  }

  @Nullable
  @Override
  public ApiMessage getApiMessageRequestBody() {
    return null;
  }

  @Nullable
  @Override
  /**
   * The fields that should be serialized (even if they have empty values). If the containing
   * message object has a non-null fieldmask, then all the fields in the field mask (and only those
   * fields in the field mask) will be serialized. If the containing object does not have a
   * fieldmask, then only non-empty fields will be serialized.
   */
  public List<String> getFieldMask() {
    return null;
  }

  /** OAuth 2.0 token for the current user. */
  public String getAccessToken() {
    return access_token;
  }

  /** Name of the JavaScript callback function that handles the response. */
  public String getCallback() {
    return callback;
  }

  /** Selector specifying a subset of fields to include in the response. */
  public String getFields() {
    return fields;
  }

  /**
   * Name of the instance for this request. It must have the format
   * `{project}/zones/{zone}/instances/{instance}/serialPort`. \`{instance}\` must start with a
   * letter, and contain only letters (\`[A-Za-z]\`), numbers (\`[0-9]\`), dashes (\`-\`), &#42;
   * underscores (\`_\`), periods (\`.\`), tildes (\`~\`), plus (\`+\`) or percent &#42; signs
   * (\`%\`). It must be between 3 and 255 characters in length, and it &#42; must not start with
   * \`"goog"\`.
   */
  public String getInstance() {
    return instance;
  }

  /** API key. Required unless you provide an OAuth 2.0 token. */
  public String getKey() {
    return key;
  }

  /** Specifies which COM or serial port to retrieve data from. */
  public Integer getPort() {
    return port;
  }

  /** Returns response with indentations and line breaks. */
  public String getPrettyPrint() {
    return prettyPrint;
  }

  /** Alternative to userIp. */
  public String getQuotaUser() {
    return quotaUser;
  }

  /**
   * Specifies the starting byte position of the output to return. To start with the first byte of
   * output to the specified port, omit this field or set it to `0`.
   *
   * <p>If the output for that byte position is available, this field matches the `start` parameter
   * sent with the request. If the amount of serial console output exceeds the size of the buffer (1
   * MB), the oldest output is discarded and is no longer available. If the requested start position
   * refers to discarded output, the start position is adjusted to the oldest output still
   * available, and the adjusted start position is returned as the `start` property value.
   *
   * <p>You can also provide a negative start position, which translates to the most recent number
   * of bytes written to the serial port. For example, -3 is interpreted as the most recent 3 bytes
   * written to the serial console.
   */
  public String getStart() {
    return start;
  }

  /** IP address of the end user for whom the API call is being made. */
  public String getUserIp() {
    return userIp;
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(GetSerialPortOutputInstanceHttpRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  public static GetSerialPortOutputInstanceHttpRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final GetSerialPortOutputInstanceHttpRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new GetSerialPortOutputInstanceHttpRequest();
  }

  public static class Builder {
    private String access_token;
    private String callback;
    private String fields;
    private String instance;
    private String key;
    private Integer port;
    private String prettyPrint;
    private String quotaUser;
    private String start;
    private String userIp;

    Builder() {}

    public Builder mergeFrom(GetSerialPortOutputInstanceHttpRequest other) {
      if (other == GetSerialPortOutputInstanceHttpRequest.getDefaultInstance()) return this;
      if (other.getAccessToken() != null) {
        this.access_token = other.access_token;
      }
      if (other.getCallback() != null) {
        this.callback = other.callback;
      }
      if (other.getFields() != null) {
        this.fields = other.fields;
      }
      if (other.getInstance() != null) {
        this.instance = other.instance;
      }
      if (other.getKey() != null) {
        this.key = other.key;
      }
      if (other.getPort() != null) {
        this.port = other.port;
      }
      if (other.getPrettyPrint() != null) {
        this.prettyPrint = other.prettyPrint;
      }
      if (other.getQuotaUser() != null) {
        this.quotaUser = other.quotaUser;
      }
      if (other.getStart() != null) {
        this.start = other.start;
      }
      if (other.getUserIp() != null) {
        this.userIp = other.userIp;
      }
      return this;
    }

    Builder(GetSerialPortOutputInstanceHttpRequest source) {
      this.access_token = source.access_token;
      this.callback = source.callback;
      this.fields = source.fields;
      this.instance = source.instance;
      this.key = source.key;
      this.port = source.port;
      this.prettyPrint = source.prettyPrint;
      this.quotaUser = source.quotaUser;
      this.start = source.start;
      this.userIp = source.userIp;
    }

    /** OAuth 2.0 token for the current user. */
    public String getAccessToken() {
      return access_token;
    }

    /** OAuth 2.0 token for the current user. */
    public Builder setAccessToken(String access_token) {
      this.access_token = access_token;
      return this;
    }

    /** Name of the JavaScript callback function that handles the response. */
    public String getCallback() {
      return callback;
    }

    /** Name of the JavaScript callback function that handles the response. */
    public Builder setCallback(String callback) {
      this.callback = callback;
      return this;
    }

    /** Selector specifying a subset of fields to include in the response. */
    public String getFields() {
      return fields;
    }

    /** Selector specifying a subset of fields to include in the response. */
    public Builder setFields(String fields) {
      this.fields = fields;
      return this;
    }

    /**
     * Name of the instance for this request. It must have the format
     * `{project}/zones/{zone}/instances/{instance}/serialPort`. \`{instance}\` must start with a
     * letter, and contain only letters (\`[A-Za-z]\`), numbers (\`[0-9]\`), dashes (\`-\`), &#42;
     * underscores (\`_\`), periods (\`.\`), tildes (\`~\`), plus (\`+\`) or percent &#42; signs
     * (\`%\`). It must be between 3 and 255 characters in length, and it &#42; must not start with
     * \`"goog"\`.
     */
    public String getInstance() {
      return instance;
    }

    /**
     * Name of the instance for this request. It must have the format
     * `{project}/zones/{zone}/instances/{instance}/serialPort`. \`{instance}\` must start with a
     * letter, and contain only letters (\`[A-Za-z]\`), numbers (\`[0-9]\`), dashes (\`-\`), &#42;
     * underscores (\`_\`), periods (\`.\`), tildes (\`~\`), plus (\`+\`) or percent &#42; signs
     * (\`%\`). It must be between 3 and 255 characters in length, and it &#42; must not start with
     * \`"goog"\`.
     */
    public Builder setInstance(String instance) {
      this.instance = instance;
      return this;
    }

    /** API key. Required unless you provide an OAuth 2.0 token. */
    public String getKey() {
      return key;
    }

    /** API key. Required unless you provide an OAuth 2.0 token. */
    public Builder setKey(String key) {
      this.key = key;
      return this;
    }

    /** Specifies which COM or serial port to retrieve data from. */
    public Integer getPort() {
      return port;
    }

    /** Specifies which COM or serial port to retrieve data from. */
    public Builder setPort(Integer port) {
      this.port = port;
      return this;
    }

    /** Returns response with indentations and line breaks. */
    public String getPrettyPrint() {
      return prettyPrint;
    }

    /** Returns response with indentations and line breaks. */
    public Builder setPrettyPrint(String prettyPrint) {
      this.prettyPrint = prettyPrint;
      return this;
    }

    /** Alternative to userIp. */
    public String getQuotaUser() {
      return quotaUser;
    }

    /** Alternative to userIp. */
    public Builder setQuotaUser(String quotaUser) {
      this.quotaUser = quotaUser;
      return this;
    }

    /**
     * Specifies the starting byte position of the output to return. To start with the first byte of
     * output to the specified port, omit this field or set it to `0`.
     *
     * <p>If the output for that byte position is available, this field matches the `start`
     * parameter sent with the request. If the amount of serial console output exceeds the size of
     * the buffer (1 MB), the oldest output is discarded and is no longer available. If the
     * requested start position refers to discarded output, the start position is adjusted to the
     * oldest output still available, and the adjusted start position is returned as the `start`
     * property value.
     *
     * <p>You can also provide a negative start position, which translates to the most recent number
     * of bytes written to the serial port. For example, -3 is interpreted as the most recent 3
     * bytes written to the serial console.
     */
    public String getStart() {
      return start;
    }

    /**
     * Specifies the starting byte position of the output to return. To start with the first byte of
     * output to the specified port, omit this field or set it to `0`.
     *
     * <p>If the output for that byte position is available, this field matches the `start`
     * parameter sent with the request. If the amount of serial console output exceeds the size of
     * the buffer (1 MB), the oldest output is discarded and is no longer available. If the
     * requested start position refers to discarded output, the start position is adjusted to the
     * oldest output still available, and the adjusted start position is returned as the `start`
     * property value.
     *
     * <p>You can also provide a negative start position, which translates to the most recent number
     * of bytes written to the serial port. For example, -3 is interpreted as the most recent 3
     * bytes written to the serial console.
     */
    public Builder setStart(String start) {
      this.start = start;
      return this;
    }

    /** IP address of the end user for whom the API call is being made. */
    public String getUserIp() {
      return userIp;
    }

    /** IP address of the end user for whom the API call is being made. */
    public Builder setUserIp(String userIp) {
      this.userIp = userIp;
      return this;
    }

    public GetSerialPortOutputInstanceHttpRequest build() {
      String missing = "";

      if (instance == null) {
        missing += " instance";
      }

      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new GetSerialPortOutputInstanceHttpRequest(
          access_token,
          callback,
          fields,
          instance,
          key,
          port,
          prettyPrint,
          quotaUser,
          start,
          userIp);
    }

    public Builder clone() {
      Builder newBuilder = new Builder();
      newBuilder.setAccessToken(this.access_token);
      newBuilder.setCallback(this.callback);
      newBuilder.setFields(this.fields);
      newBuilder.setInstance(this.instance);
      newBuilder.setKey(this.key);
      newBuilder.setPort(this.port);
      newBuilder.setPrettyPrint(this.prettyPrint);
      newBuilder.setQuotaUser(this.quotaUser);
      newBuilder.setStart(this.start);
      newBuilder.setUserIp(this.userIp);
      return newBuilder;
    }
  }

  @Override
  public String toString() {
    return "GetSerialPortOutputInstanceHttpRequest{"
        + "access_token="
        + access_token
        + ", "
        + "callback="
        + callback
        + ", "
        + "fields="
        + fields
        + ", "
        + "instance="
        + instance
        + ", "
        + "key="
        + key
        + ", "
        + "port="
        + port
        + ", "
        + "prettyPrint="
        + prettyPrint
        + ", "
        + "quotaUser="
        + quotaUser
        + ", "
        + "start="
        + start
        + ", "
        + "userIp="
        + userIp
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GetSerialPortOutputInstanceHttpRequest) {
      GetSerialPortOutputInstanceHttpRequest that = (GetSerialPortOutputInstanceHttpRequest) o;
      return Objects.equals(this.access_token, that.getAccessToken())
          && Objects.equals(this.callback, that.getCallback())
          && Objects.equals(this.fields, that.getFields())
          && Objects.equals(this.instance, that.getInstance())
          && Objects.equals(this.key, that.getKey())
          && Objects.equals(this.port, that.getPort())
          && Objects.equals(this.prettyPrint, that.getPrettyPrint())
          && Objects.equals(this.quotaUser, that.getQuotaUser())
          && Objects.equals(this.start, that.getStart())
          && Objects.equals(this.userIp, that.getUserIp());
    }
    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        access_token, callback, fields, instance, key, port, prettyPrint, quotaUser, start, userIp);
  }
}
