/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("by GAPIC")
@BetaApi
public final class GlobalSetLabelsRequest implements ApiMessage {
  private final String labelFingerprint;
  private final Map<String, String> labels;

  private GlobalSetLabelsRequest() {
    this.labelFingerprint = null;
    this.labels = null;
  }

  private GlobalSetLabelsRequest(String labelFingerprint, Map<String, String> labels) {
    this.labelFingerprint = labelFingerprint;
    this.labels = labels;
  }

  @Override
  public Object getFieldValue(String fieldName) {
    if ("labelFingerprint".equals(fieldName)) {
      return labelFingerprint;
    }
    if ("labels".equals(fieldName)) {
      return labels;
    }
    return null;
  }

  @Nullable
  @Override
  public ApiMessage getApiMessageRequestBody() {
    return null;
  }

  @Nullable
  @Override
  /**
   * The fields that should be serialized (even if they have empty values). If the containing
   * message object has a non-null fieldmask, then all the fields in the field mask (and only those
   * fields in the field mask) will be serialized. If the containing object does not have a
   * fieldmask, then only non-empty fields will be serialized.
   */
  public List<String> getFieldMask() {
    return null;
  }

  /**
   * The fingerprint of the previous set of labels for this resource, used to detect conflicts. The
   * fingerprint is initially generated by Compute Engine and changes after every request to modify
   * or update labels. You must always provide an up-to-date fingerprint hash when updating or
   * changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a get()
   * request to the resource to get the latest fingerprint.
   */
  public String getLabelFingerprint() {
    return labelFingerprint;
  }

  /**
   * A list of labels to apply for this resource. Each label key &amp; value must comply with
   * RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression
   * `[a-z]([-a-z0-9]&#42;[a-z0-9])?` which means the first character must be a lowercase letter,
   * and all following characters must be a dash, lowercase letter, or digit, except the last
   * character, which cannot be a dash. For example, "webserver-frontend": "images". A label value
   * can also be empty (e.g. "my-label": "").
   */
  public Map<String, String> getLabelsMap() {
    return labels;
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(GlobalSetLabelsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  public static GlobalSetLabelsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final GlobalSetLabelsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new GlobalSetLabelsRequest();
  }

  public static class Builder {
    private String labelFingerprint;
    private Map<String, String> labels;

    Builder() {}

    public Builder mergeFrom(GlobalSetLabelsRequest other) {
      if (other == GlobalSetLabelsRequest.getDefaultInstance()) return this;
      if (other.getLabelFingerprint() != null) {
        this.labelFingerprint = other.labelFingerprint;
      }
      if (other.getLabelsMap() != null) {
        this.labels = other.labels;
      }
      return this;
    }

    Builder(GlobalSetLabelsRequest source) {
      this.labelFingerprint = source.labelFingerprint;
      this.labels = source.labels;
    }

    /**
     * The fingerprint of the previous set of labels for this resource, used to detect conflicts.
     * The fingerprint is initially generated by Compute Engine and changes after every request to
     * modify or update labels. You must always provide an up-to-date fingerprint hash when updating
     * or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a
     * get() request to the resource to get the latest fingerprint.
     */
    public String getLabelFingerprint() {
      return labelFingerprint;
    }

    /**
     * The fingerprint of the previous set of labels for this resource, used to detect conflicts.
     * The fingerprint is initially generated by Compute Engine and changes after every request to
     * modify or update labels. You must always provide an up-to-date fingerprint hash when updating
     * or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a
     * get() request to the resource to get the latest fingerprint.
     */
    public Builder setLabelFingerprint(String labelFingerprint) {
      this.labelFingerprint = labelFingerprint;
      return this;
    }

    /**
     * A list of labels to apply for this resource. Each label key &amp; value must comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression
     * `[a-z]([-a-z0-9]&#42;[a-z0-9])?` which means the first character must be a lowercase letter,
     * and all following characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash. For example, "webserver-frontend": "images". A label value
     * can also be empty (e.g. "my-label": "").
     */
    public Map<String, String> getLabelsMap() {
      return labels;
    }

    /**
     * A list of labels to apply for this resource. Each label key &amp; value must comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression
     * `[a-z]([-a-z0-9]&#42;[a-z0-9])?` which means the first character must be a lowercase letter,
     * and all following characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash. For example, "webserver-frontend": "images". A label value
     * can also be empty (e.g. "my-label": "").
     */
    public Builder putAllLabels(Map<String, String> labels) {
      this.labels = labels;
      return this;
    }

    public GlobalSetLabelsRequest build() {

      return new GlobalSetLabelsRequest(labelFingerprint, labels);
    }

    public Builder clone() {
      Builder newBuilder = new Builder();
      newBuilder.setLabelFingerprint(this.labelFingerprint);
      newBuilder.putAllLabels(this.labels);
      return newBuilder;
    }
  }

  @Override
  public String toString() {
    return "GlobalSetLabelsRequest{"
        + "labelFingerprint="
        + labelFingerprint
        + ", "
        + "labels="
        + labels
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GlobalSetLabelsRequest) {
      GlobalSetLabelsRequest that = (GlobalSetLabelsRequest) o;
      return Objects.equals(this.labelFingerprint, that.getLabelFingerprint())
          && Objects.equals(this.labels, that.getLabelsMap());
    }
    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(labelFingerprint, labels);
  }
}
