/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("by GAPIC")
@BetaApi
/**
 * Represent a sole-tenant Node Group resource.
 *
 * <p>A sole-tenant node is a physical server that is dedicated to hosting VM instances only for
 * your specific project. Use sole-tenant nodes to keep your instances physically separated from
 * instances in other projects, or to group your instances together on the same host hardware. For
 * more information, read Sole-tenant nodes. (== resource_for {$api_version}.nodeGroups ==)
 */
public final class NodeGroup implements ApiMessage {
  private final NodeGroupAutoscalingPolicy autoscalingPolicy;
  private final String creationTimestamp;
  private final String description;
  private final String fingerprint;
  private final String id;
  private final String kind;
  private final String maintenancePolicy;
  private final String name;
  private final String nodeTemplate;
  private final String selfLink;
  private final Integer size;
  private final String status;
  private final String zone;

  private NodeGroup() {
    this.autoscalingPolicy = null;
    this.creationTimestamp = null;
    this.description = null;
    this.fingerprint = null;
    this.id = null;
    this.kind = null;
    this.maintenancePolicy = null;
    this.name = null;
    this.nodeTemplate = null;
    this.selfLink = null;
    this.size = null;
    this.status = null;
    this.zone = null;
  }

  private NodeGroup(
      NodeGroupAutoscalingPolicy autoscalingPolicy,
      String creationTimestamp,
      String description,
      String fingerprint,
      String id,
      String kind,
      String maintenancePolicy,
      String name,
      String nodeTemplate,
      String selfLink,
      Integer size,
      String status,
      String zone) {
    this.autoscalingPolicy = autoscalingPolicy;
    this.creationTimestamp = creationTimestamp;
    this.description = description;
    this.fingerprint = fingerprint;
    this.id = id;
    this.kind = kind;
    this.maintenancePolicy = maintenancePolicy;
    this.name = name;
    this.nodeTemplate = nodeTemplate;
    this.selfLink = selfLink;
    this.size = size;
    this.status = status;
    this.zone = zone;
  }

  @Override
  public Object getFieldValue(String fieldName) {
    if ("autoscalingPolicy".equals(fieldName)) {
      return autoscalingPolicy;
    }
    if ("creationTimestamp".equals(fieldName)) {
      return creationTimestamp;
    }
    if ("description".equals(fieldName)) {
      return description;
    }
    if ("fingerprint".equals(fieldName)) {
      return fingerprint;
    }
    if ("id".equals(fieldName)) {
      return id;
    }
    if ("kind".equals(fieldName)) {
      return kind;
    }
    if ("maintenancePolicy".equals(fieldName)) {
      return maintenancePolicy;
    }
    if ("name".equals(fieldName)) {
      return name;
    }
    if ("nodeTemplate".equals(fieldName)) {
      return nodeTemplate;
    }
    if ("selfLink".equals(fieldName)) {
      return selfLink;
    }
    if ("size".equals(fieldName)) {
      return size;
    }
    if ("status".equals(fieldName)) {
      return status;
    }
    if ("zone".equals(fieldName)) {
      return zone;
    }
    return null;
  }

  @Nullable
  @Override
  public ApiMessage getApiMessageRequestBody() {
    return null;
  }

  @Nullable
  @Override
  /**
   * The fields that should be serialized (even if they have empty values). If the containing
   * message object has a non-null fieldmask, then all the fields in the field mask (and only those
   * fields in the field mask) will be serialized. If the containing object does not have a
   * fieldmask, then only non-empty fields will be serialized.
   */
  public List<String> getFieldMask() {
    return null;
  }

  /** Specifies how autoscaling should behave. */
  public NodeGroupAutoscalingPolicy getAutoscalingPolicy() {
    return autoscalingPolicy;
  }

  /** [Output Only] Creation timestamp in RFC3339 text format. */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   */
  public String getDescription() {
    return description;
  }

  public String getFingerprint() {
    return fingerprint;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   */
  public String getId() {
    return id;
  }

  /** [Output Only] The type of the resource. Always compute#nodeGroup for node group. */
  public String getKind() {
    return kind;
  }

  /** Specifies how to handle instances when a node in the group undergoes maintenance. */
  public String getMaintenancePolicy() {
    return maintenancePolicy;
  }

  /**
   * The name of the resource, provided by the client when initially creating the resource. The
   * resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name
   * must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]&#42;[a-z0-9])?`
   * which means the first character must be a lowercase letter, and all following characters must
   * be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   */
  public String getName() {
    return name;
  }

  /** URL of the node template to create the node group from. */
  public String getNodeTemplate() {
    return nodeTemplate;
  }

  /** [Output Only] Server-defined URL for the resource. */
  public String getSelfLink() {
    return selfLink;
  }

  /** [Output Only] The total number of nodes in the node group. */
  public Integer getSize() {
    return size;
  }

  public String getStatus() {
    return status;
  }

  /** [Output Only] The name of the zone where the node group resides, such as us-central1-a. */
  public String getZone() {
    return zone;
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(NodeGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  public static NodeGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final NodeGroup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new NodeGroup();
  }

  public static class Builder {
    private NodeGroupAutoscalingPolicy autoscalingPolicy;
    private String creationTimestamp;
    private String description;
    private String fingerprint;
    private String id;
    private String kind;
    private String maintenancePolicy;
    private String name;
    private String nodeTemplate;
    private String selfLink;
    private Integer size;
    private String status;
    private String zone;

    Builder() {}

    public Builder mergeFrom(NodeGroup other) {
      if (other == NodeGroup.getDefaultInstance()) return this;
      if (other.getAutoscalingPolicy() != null) {
        this.autoscalingPolicy = other.autoscalingPolicy;
      }
      if (other.getCreationTimestamp() != null) {
        this.creationTimestamp = other.creationTimestamp;
      }
      if (other.getDescription() != null) {
        this.description = other.description;
      }
      if (other.getFingerprint() != null) {
        this.fingerprint = other.fingerprint;
      }
      if (other.getId() != null) {
        this.id = other.id;
      }
      if (other.getKind() != null) {
        this.kind = other.kind;
      }
      if (other.getMaintenancePolicy() != null) {
        this.maintenancePolicy = other.maintenancePolicy;
      }
      if (other.getName() != null) {
        this.name = other.name;
      }
      if (other.getNodeTemplate() != null) {
        this.nodeTemplate = other.nodeTemplate;
      }
      if (other.getSelfLink() != null) {
        this.selfLink = other.selfLink;
      }
      if (other.getSize() != null) {
        this.size = other.size;
      }
      if (other.getStatus() != null) {
        this.status = other.status;
      }
      if (other.getZone() != null) {
        this.zone = other.zone;
      }
      return this;
    }

    Builder(NodeGroup source) {
      this.autoscalingPolicy = source.autoscalingPolicy;
      this.creationTimestamp = source.creationTimestamp;
      this.description = source.description;
      this.fingerprint = source.fingerprint;
      this.id = source.id;
      this.kind = source.kind;
      this.maintenancePolicy = source.maintenancePolicy;
      this.name = source.name;
      this.nodeTemplate = source.nodeTemplate;
      this.selfLink = source.selfLink;
      this.size = source.size;
      this.status = source.status;
      this.zone = source.zone;
    }

    /** Specifies how autoscaling should behave. */
    public NodeGroupAutoscalingPolicy getAutoscalingPolicy() {
      return autoscalingPolicy;
    }

    /** Specifies how autoscaling should behave. */
    public Builder setAutoscalingPolicy(NodeGroupAutoscalingPolicy autoscalingPolicy) {
      this.autoscalingPolicy = autoscalingPolicy;
      return this;
    }

    /** [Output Only] Creation timestamp in RFC3339 text format. */
    public String getCreationTimestamp() {
      return creationTimestamp;
    }

    /** [Output Only] Creation timestamp in RFC3339 text format. */
    public Builder setCreationTimestamp(String creationTimestamp) {
      this.creationTimestamp = creationTimestamp;
      return this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     */
    public String getDescription() {
      return description;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     */
    public Builder setDescription(String description) {
      this.description = description;
      return this;
    }

    public String getFingerprint() {
      return fingerprint;
    }

    public Builder setFingerprint(String fingerprint) {
      this.fingerprint = fingerprint;
      return this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the
     * server.
     */
    public String getId() {
      return id;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the
     * server.
     */
    public Builder setId(String id) {
      this.id = id;
      return this;
    }

    /** [Output Only] The type of the resource. Always compute#nodeGroup for node group. */
    public String getKind() {
      return kind;
    }

    /** [Output Only] The type of the resource. Always compute#nodeGroup for node group. */
    public Builder setKind(String kind) {
      this.kind = kind;
      return this;
    }

    /** Specifies how to handle instances when a node in the group undergoes maintenance. */
    public String getMaintenancePolicy() {
      return maintenancePolicy;
    }

    /** Specifies how to handle instances when a node in the group undergoes maintenance. */
    public Builder setMaintenancePolicy(String maintenancePolicy) {
      this.maintenancePolicy = maintenancePolicy;
      return this;
    }

    /**
     * The name of the resource, provided by the client when initially creating the resource. The
     * resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name
     * must be 1-63 characters long and match the regular expression
     * `[a-z]([-a-z0-9]&#42;[a-z0-9])?` which means the first character must be a lowercase letter,
     * and all following characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     */
    public String getName() {
      return name;
    }

    /**
     * The name of the resource, provided by the client when initially creating the resource. The
     * resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name
     * must be 1-63 characters long and match the regular expression
     * `[a-z]([-a-z0-9]&#42;[a-z0-9])?` which means the first character must be a lowercase letter,
     * and all following characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     */
    public Builder setName(String name) {
      this.name = name;
      return this;
    }

    /** URL of the node template to create the node group from. */
    public String getNodeTemplate() {
      return nodeTemplate;
    }

    /** URL of the node template to create the node group from. */
    public Builder setNodeTemplate(String nodeTemplate) {
      this.nodeTemplate = nodeTemplate;
      return this;
    }

    /** [Output Only] Server-defined URL for the resource. */
    public String getSelfLink() {
      return selfLink;
    }

    /** [Output Only] Server-defined URL for the resource. */
    public Builder setSelfLink(String selfLink) {
      this.selfLink = selfLink;
      return this;
    }

    /** [Output Only] The total number of nodes in the node group. */
    public Integer getSize() {
      return size;
    }

    /** [Output Only] The total number of nodes in the node group. */
    public Builder setSize(Integer size) {
      this.size = size;
      return this;
    }

    public String getStatus() {
      return status;
    }

    public Builder setStatus(String status) {
      this.status = status;
      return this;
    }

    /** [Output Only] The name of the zone where the node group resides, such as us-central1-a. */
    public String getZone() {
      return zone;
    }

    /** [Output Only] The name of the zone where the node group resides, such as us-central1-a. */
    public Builder setZone(String zone) {
      this.zone = zone;
      return this;
    }

    public NodeGroup build() {

      return new NodeGroup(
          autoscalingPolicy,
          creationTimestamp,
          description,
          fingerprint,
          id,
          kind,
          maintenancePolicy,
          name,
          nodeTemplate,
          selfLink,
          size,
          status,
          zone);
    }

    public Builder clone() {
      Builder newBuilder = new Builder();
      newBuilder.setAutoscalingPolicy(this.autoscalingPolicy);
      newBuilder.setCreationTimestamp(this.creationTimestamp);
      newBuilder.setDescription(this.description);
      newBuilder.setFingerprint(this.fingerprint);
      newBuilder.setId(this.id);
      newBuilder.setKind(this.kind);
      newBuilder.setMaintenancePolicy(this.maintenancePolicy);
      newBuilder.setName(this.name);
      newBuilder.setNodeTemplate(this.nodeTemplate);
      newBuilder.setSelfLink(this.selfLink);
      newBuilder.setSize(this.size);
      newBuilder.setStatus(this.status);
      newBuilder.setZone(this.zone);
      return newBuilder;
    }
  }

  @Override
  public String toString() {
    return "NodeGroup{"
        + "autoscalingPolicy="
        + autoscalingPolicy
        + ", "
        + "creationTimestamp="
        + creationTimestamp
        + ", "
        + "description="
        + description
        + ", "
        + "fingerprint="
        + fingerprint
        + ", "
        + "id="
        + id
        + ", "
        + "kind="
        + kind
        + ", "
        + "maintenancePolicy="
        + maintenancePolicy
        + ", "
        + "name="
        + name
        + ", "
        + "nodeTemplate="
        + nodeTemplate
        + ", "
        + "selfLink="
        + selfLink
        + ", "
        + "size="
        + size
        + ", "
        + "status="
        + status
        + ", "
        + "zone="
        + zone
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NodeGroup) {
      NodeGroup that = (NodeGroup) o;
      return Objects.equals(this.autoscalingPolicy, that.getAutoscalingPolicy())
          && Objects.equals(this.creationTimestamp, that.getCreationTimestamp())
          && Objects.equals(this.description, that.getDescription())
          && Objects.equals(this.fingerprint, that.getFingerprint())
          && Objects.equals(this.id, that.getId())
          && Objects.equals(this.kind, that.getKind())
          && Objects.equals(this.maintenancePolicy, that.getMaintenancePolicy())
          && Objects.equals(this.name, that.getName())
          && Objects.equals(this.nodeTemplate, that.getNodeTemplate())
          && Objects.equals(this.selfLink, that.getSelfLink())
          && Objects.equals(this.size, that.getSize())
          && Objects.equals(this.status, that.getStatus())
          && Objects.equals(this.zone, that.getZone());
    }
    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        autoscalingPolicy,
        creationTimestamp,
        description,
        fingerprint,
        id,
        kind,
        maintenancePolicy,
        name,
        nodeTemplate,
        selfLink,
        size,
        status,
        zone);
  }
}
