/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.compute.v1;

import static com.google.cloud.compute.v1.RegionSslCertificateClient.ListRegionSslCertificatesPagedResponse;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.compute.v1.stub.RegionSslCertificateStubSettings;
import java.io.IOException;
import java.util.List;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS
/**
 * Settings class to configure an instance of {@link RegionSslCertificateClient}.
 *
 * <p>The default instance has everything set to sensible defaults:
 *
 * <ul>
 *   <li>The default service address (https://compute.googleapis.com/compute/v1/projects/) and
 *       default port (443) are used.
 *   <li>Credentials are acquired automatically through Application Default Credentials.
 *   <li>Retries are configured for idempotent methods but not for non-idempotent methods.
 * </ul>
 *
 * <p>The builder of this class is recursive, so contained classes are themselves builders. When
 * build() is called, the tree of builders is called to create the complete settings object.
 *
 * <p>For example, to set the total timeout of deleteRegionSslCertificate to 30 seconds:
 *
 * <pre>
 * <code>
 * RegionSslCertificateSettings.Builder regionSslCertificateSettingsBuilder =
 *     RegionSslCertificateSettings.newBuilder();
 * regionSslCertificateSettingsBuilder
 *     .deleteRegionSslCertificateSettings()
 *     .setRetrySettings(
 *         regionSslCertificateSettingsBuilder.deleteRegionSslCertificateSettings().getRetrySettings().toBuilder()
 *             .setTotalTimeout(Duration.ofSeconds(30))
 *             .build());
 * RegionSslCertificateSettings regionSslCertificateSettings = regionSslCertificateSettingsBuilder.build();
 * </code>
 * </pre>
 */
@Generated("by gapic-generator")
@BetaApi
public class RegionSslCertificateSettings extends ClientSettings<RegionSslCertificateSettings> {
  /** Returns the object with the settings used for calls to deleteRegionSslCertificate. */
  public UnaryCallSettings<DeleteRegionSslCertificateHttpRequest, Operation>
      deleteRegionSslCertificateSettings() {
    return ((RegionSslCertificateStubSettings) getStubSettings())
        .deleteRegionSslCertificateSettings();
  }

  /** Returns the object with the settings used for calls to getRegionSslCertificate. */
  public UnaryCallSettings<GetRegionSslCertificateHttpRequest, SslCertificate>
      getRegionSslCertificateSettings() {
    return ((RegionSslCertificateStubSettings) getStubSettings()).getRegionSslCertificateSettings();
  }

  /** Returns the object with the settings used for calls to insertRegionSslCertificate. */
  public UnaryCallSettings<InsertRegionSslCertificateHttpRequest, Operation>
      insertRegionSslCertificateSettings() {
    return ((RegionSslCertificateStubSettings) getStubSettings())
        .insertRegionSslCertificateSettings();
  }

  /** Returns the object with the settings used for calls to listRegionSslCertificates. */
  public PagedCallSettings<
          ListRegionSslCertificatesHttpRequest,
          SslCertificateList,
          ListRegionSslCertificatesPagedResponse>
      listRegionSslCertificatesSettings() {
    return ((RegionSslCertificateStubSettings) getStubSettings())
        .listRegionSslCertificatesSettings();
  }

  public static final RegionSslCertificateSettings create(RegionSslCertificateStubSettings stub)
      throws IOException {
    return new RegionSslCertificateSettings.Builder(stub.toBuilder()).build();
  }

  /** Returns a builder for the default ExecutorProvider for this service. */
  public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
    return RegionSslCertificateStubSettings.defaultExecutorProviderBuilder();
  }

  /** Returns the default service endpoint. */
  public static String getDefaultEndpoint() {
    return RegionSslCertificateStubSettings.getDefaultEndpoint();
  }
  /** Returns the default service port. */
  public static int getDefaultServicePort() {
    return RegionSslCertificateStubSettings.getDefaultServicePort();
  }

  /** Returns the default service scopes. */
  public static List<String> getDefaultServiceScopes() {
    return RegionSslCertificateStubSettings.getDefaultServiceScopes();
  }

  /** Returns a builder for the default credentials for this service. */
  public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
    return RegionSslCertificateStubSettings.defaultCredentialsProviderBuilder();
  }

  /** Returns a builder for the default ChannelProvider for this service. */
  public static InstantiatingHttpJsonChannelProvider.Builder
      defaultHttpJsonTransportProviderBuilder() {
    return RegionSslCertificateStubSettings.defaultHttpJsonTransportProviderBuilder();
  }

  public static TransportChannelProvider defaultTransportChannelProvider() {
    return RegionSslCertificateStubSettings.defaultTransportChannelProvider();
  }

  @BetaApi("The surface for customizing headers is not stable yet and may change in the future.")
  public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
    return RegionSslCertificateStubSettings.defaultApiClientHeaderProviderBuilder();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder() {
    return Builder.createDefault();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder(ClientContext clientContext) {
    return new Builder(clientContext);
  }

  /** Returns a builder containing all the values of this settings class. */
  public Builder toBuilder() {
    return new Builder(this);
  }

  protected RegionSslCertificateSettings(Builder settingsBuilder) throws IOException {
    super(settingsBuilder);
  }

  /** Builder for RegionSslCertificateSettings. */
  public static class Builder
      extends ClientSettings.Builder<RegionSslCertificateSettings, Builder> {
    protected Builder() throws IOException {
      this((ClientContext) null);
    }

    protected Builder(ClientContext clientContext) {
      super(RegionSslCertificateStubSettings.newBuilder(clientContext));
    }

    private static Builder createDefault() {
      return new Builder(RegionSslCertificateStubSettings.newBuilder());
    }

    protected Builder(RegionSslCertificateSettings settings) {
      super(settings.getStubSettings().toBuilder());
    }

    protected Builder(RegionSslCertificateStubSettings.Builder stubSettings) {
      super(stubSettings);
    }

    public RegionSslCertificateStubSettings.Builder getStubSettingsBuilder() {
      return ((RegionSslCertificateStubSettings.Builder) getStubSettings());
    }

    // NEXT_MAJOR_VER: remove 'throws Exception'
    /**
     * Applies the given settings updater function to all of the unary API methods in this service.
     *
     * <p>Note: This method does not support applying settings to streaming methods.
     */
    public Builder applyToAllUnaryMethods(
        ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
      super.applyToAllUnaryMethods(
          getStubSettingsBuilder().unaryMethodSettingsBuilders(), settingsUpdater);
      return this;
    }

    /** Returns the builder for the settings used for calls to deleteRegionSslCertificate. */
    public UnaryCallSettings.Builder<DeleteRegionSslCertificateHttpRequest, Operation>
        deleteRegionSslCertificateSettings() {
      return getStubSettingsBuilder().deleteRegionSslCertificateSettings();
    }

    /** Returns the builder for the settings used for calls to getRegionSslCertificate. */
    public UnaryCallSettings.Builder<GetRegionSslCertificateHttpRequest, SslCertificate>
        getRegionSslCertificateSettings() {
      return getStubSettingsBuilder().getRegionSslCertificateSettings();
    }

    /** Returns the builder for the settings used for calls to insertRegionSslCertificate. */
    public UnaryCallSettings.Builder<InsertRegionSslCertificateHttpRequest, Operation>
        insertRegionSslCertificateSettings() {
      return getStubSettingsBuilder().insertRegionSslCertificateSettings();
    }

    /** Returns the builder for the settings used for calls to listRegionSslCertificates. */
    public PagedCallSettings.Builder<
            ListRegionSslCertificatesHttpRequest,
            SslCertificateList,
            ListRegionSslCertificatesPagedResponse>
        listRegionSslCertificatesSettings() {
      return getStubSettingsBuilder().listRegionSslCertificatesSettings();
    }

    @Override
    public RegionSslCertificateSettings build() throws IOException {
      return new RegionSslCertificateSettings(this);
    }
  }
}
