/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.compute.v1;

import static com.google.cloud.compute.v1.SnapshotClient.ListSnapshotsPagedResponse;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.compute.v1.stub.SnapshotStubSettings;
import java.io.IOException;
import java.util.List;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS
/**
 * Settings class to configure an instance of {@link SnapshotClient}.
 *
 * <p>The default instance has everything set to sensible defaults:
 *
 * <ul>
 *   <li>The default service address (https://compute.googleapis.com/compute/v1/projects/) and
 *       default port (443) are used.
 *   <li>Credentials are acquired automatically through Application Default Credentials.
 *   <li>Retries are configured for idempotent methods but not for non-idempotent methods.
 * </ul>
 *
 * <p>The builder of this class is recursive, so contained classes are themselves builders. When
 * build() is called, the tree of builders is called to create the complete settings object.
 *
 * <p>For example, to set the total timeout of deleteSnapshot to 30 seconds:
 *
 * <pre>
 * <code>
 * SnapshotSettings.Builder snapshotSettingsBuilder =
 *     SnapshotSettings.newBuilder();
 * snapshotSettingsBuilder
 *     .deleteSnapshotSettings()
 *     .setRetrySettings(
 *         snapshotSettingsBuilder.deleteSnapshotSettings().getRetrySettings().toBuilder()
 *             .setTotalTimeout(Duration.ofSeconds(30))
 *             .build());
 * SnapshotSettings snapshotSettings = snapshotSettingsBuilder.build();
 * </code>
 * </pre>
 */
@Generated("by gapic-generator")
@BetaApi
public class SnapshotSettings extends ClientSettings<SnapshotSettings> {
  /** Returns the object with the settings used for calls to deleteSnapshot. */
  public UnaryCallSettings<DeleteSnapshotHttpRequest, Operation> deleteSnapshotSettings() {
    return ((SnapshotStubSettings) getStubSettings()).deleteSnapshotSettings();
  }

  /** Returns the object with the settings used for calls to getSnapshot. */
  public UnaryCallSettings<GetSnapshotHttpRequest, Snapshot> getSnapshotSettings() {
    return ((SnapshotStubSettings) getStubSettings()).getSnapshotSettings();
  }

  /** Returns the object with the settings used for calls to getIamPolicySnapshot. */
  public UnaryCallSettings<GetIamPolicySnapshotHttpRequest, Policy> getIamPolicySnapshotSettings() {
    return ((SnapshotStubSettings) getStubSettings()).getIamPolicySnapshotSettings();
  }

  /** Returns the object with the settings used for calls to listSnapshots. */
  public PagedCallSettings<ListSnapshotsHttpRequest, SnapshotList, ListSnapshotsPagedResponse>
      listSnapshotsSettings() {
    return ((SnapshotStubSettings) getStubSettings()).listSnapshotsSettings();
  }

  /** Returns the object with the settings used for calls to setIamPolicySnapshot. */
  public UnaryCallSettings<SetIamPolicySnapshotHttpRequest, Policy> setIamPolicySnapshotSettings() {
    return ((SnapshotStubSettings) getStubSettings()).setIamPolicySnapshotSettings();
  }

  /** Returns the object with the settings used for calls to setLabelsSnapshot. */
  public UnaryCallSettings<SetLabelsSnapshotHttpRequest, Operation> setLabelsSnapshotSettings() {
    return ((SnapshotStubSettings) getStubSettings()).setLabelsSnapshotSettings();
  }

  /** Returns the object with the settings used for calls to testIamPermissionsSnapshot. */
  public UnaryCallSettings<TestIamPermissionsSnapshotHttpRequest, TestPermissionsResponse>
      testIamPermissionsSnapshotSettings() {
    return ((SnapshotStubSettings) getStubSettings()).testIamPermissionsSnapshotSettings();
  }

  public static final SnapshotSettings create(SnapshotStubSettings stub) throws IOException {
    return new SnapshotSettings.Builder(stub.toBuilder()).build();
  }

  /** Returns a builder for the default ExecutorProvider for this service. */
  public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
    return SnapshotStubSettings.defaultExecutorProviderBuilder();
  }

  /** Returns the default service endpoint. */
  public static String getDefaultEndpoint() {
    return SnapshotStubSettings.getDefaultEndpoint();
  }
  /** Returns the default service port. */
  public static int getDefaultServicePort() {
    return SnapshotStubSettings.getDefaultServicePort();
  }

  /** Returns the default service scopes. */
  public static List<String> getDefaultServiceScopes() {
    return SnapshotStubSettings.getDefaultServiceScopes();
  }

  /** Returns a builder for the default credentials for this service. */
  public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
    return SnapshotStubSettings.defaultCredentialsProviderBuilder();
  }

  /** Returns a builder for the default ChannelProvider for this service. */
  public static InstantiatingHttpJsonChannelProvider.Builder
      defaultHttpJsonTransportProviderBuilder() {
    return SnapshotStubSettings.defaultHttpJsonTransportProviderBuilder();
  }

  public static TransportChannelProvider defaultTransportChannelProvider() {
    return SnapshotStubSettings.defaultTransportChannelProvider();
  }

  @BetaApi("The surface for customizing headers is not stable yet and may change in the future.")
  public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
    return SnapshotStubSettings.defaultApiClientHeaderProviderBuilder();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder() {
    return Builder.createDefault();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder(ClientContext clientContext) {
    return new Builder(clientContext);
  }

  /** Returns a builder containing all the values of this settings class. */
  public Builder toBuilder() {
    return new Builder(this);
  }

  protected SnapshotSettings(Builder settingsBuilder) throws IOException {
    super(settingsBuilder);
  }

  /** Builder for SnapshotSettings. */
  public static class Builder extends ClientSettings.Builder<SnapshotSettings, Builder> {
    protected Builder() throws IOException {
      this((ClientContext) null);
    }

    protected Builder(ClientContext clientContext) {
      super(SnapshotStubSettings.newBuilder(clientContext));
    }

    private static Builder createDefault() {
      return new Builder(SnapshotStubSettings.newBuilder());
    }

    protected Builder(SnapshotSettings settings) {
      super(settings.getStubSettings().toBuilder());
    }

    protected Builder(SnapshotStubSettings.Builder stubSettings) {
      super(stubSettings);
    }

    public SnapshotStubSettings.Builder getStubSettingsBuilder() {
      return ((SnapshotStubSettings.Builder) getStubSettings());
    }

    // NEXT_MAJOR_VER: remove 'throws Exception'
    /**
     * Applies the given settings updater function to all of the unary API methods in this service.
     *
     * <p>Note: This method does not support applying settings to streaming methods.
     */
    public Builder applyToAllUnaryMethods(
        ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
      super.applyToAllUnaryMethods(
          getStubSettingsBuilder().unaryMethodSettingsBuilders(), settingsUpdater);
      return this;
    }

    /** Returns the builder for the settings used for calls to deleteSnapshot. */
    public UnaryCallSettings.Builder<DeleteSnapshotHttpRequest, Operation>
        deleteSnapshotSettings() {
      return getStubSettingsBuilder().deleteSnapshotSettings();
    }

    /** Returns the builder for the settings used for calls to getSnapshot. */
    public UnaryCallSettings.Builder<GetSnapshotHttpRequest, Snapshot> getSnapshotSettings() {
      return getStubSettingsBuilder().getSnapshotSettings();
    }

    /** Returns the builder for the settings used for calls to getIamPolicySnapshot. */
    public UnaryCallSettings.Builder<GetIamPolicySnapshotHttpRequest, Policy>
        getIamPolicySnapshotSettings() {
      return getStubSettingsBuilder().getIamPolicySnapshotSettings();
    }

    /** Returns the builder for the settings used for calls to listSnapshots. */
    public PagedCallSettings.Builder<
            ListSnapshotsHttpRequest, SnapshotList, ListSnapshotsPagedResponse>
        listSnapshotsSettings() {
      return getStubSettingsBuilder().listSnapshotsSettings();
    }

    /** Returns the builder for the settings used for calls to setIamPolicySnapshot. */
    public UnaryCallSettings.Builder<SetIamPolicySnapshotHttpRequest, Policy>
        setIamPolicySnapshotSettings() {
      return getStubSettingsBuilder().setIamPolicySnapshotSettings();
    }

    /** Returns the builder for the settings used for calls to setLabelsSnapshot. */
    public UnaryCallSettings.Builder<SetLabelsSnapshotHttpRequest, Operation>
        setLabelsSnapshotSettings() {
      return getStubSettingsBuilder().setLabelsSnapshotSettings();
    }

    /** Returns the builder for the settings used for calls to testIamPermissionsSnapshot. */
    public UnaryCallSettings.Builder<TestIamPermissionsSnapshotHttpRequest, TestPermissionsResponse>
        testIamPermissionsSnapshotSettings() {
      return getStubSettingsBuilder().testIamPermissionsSnapshotSettings();
    }

    @Override
    public SnapshotSettings build() throws IOException {
      return new SnapshotSettings(this);
    }
  }
}
