/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("by GAPIC")
@BetaApi
/**
 * Represents a HA VPN gateway.
 *
 * <p>HA VPN is a high-availability (HA) Cloud VPN solution that lets you securely connect your
 * on-premises network to your Google Cloud Virtual Private Cloud network through an IPsec VPN
 * connection in a single region. For more information about Cloud HA VPN solutions, see Cloud VPN
 * topologies . (== resource_for {$api_version}.vpnGateways ==)
 */
public final class VpnGateway implements ApiMessage {
  private final String creationTimestamp;
  private final String description;
  private final String id;
  private final String kind;
  private final String labelFingerprint;
  private final Map<String, String> labels;
  private final String name;
  private final String network;
  private final String region;
  private final String selfLink;
  private final List<VpnGatewayVpnGatewayInterface> vpnInterfaces;

  private VpnGateway() {
    this.creationTimestamp = null;
    this.description = null;
    this.id = null;
    this.kind = null;
    this.labelFingerprint = null;
    this.labels = null;
    this.name = null;
    this.network = null;
    this.region = null;
    this.selfLink = null;
    this.vpnInterfaces = null;
  }

  private VpnGateway(
      String creationTimestamp,
      String description,
      String id,
      String kind,
      String labelFingerprint,
      Map<String, String> labels,
      String name,
      String network,
      String region,
      String selfLink,
      List<VpnGatewayVpnGatewayInterface> vpnInterfaces) {
    this.creationTimestamp = creationTimestamp;
    this.description = description;
    this.id = id;
    this.kind = kind;
    this.labelFingerprint = labelFingerprint;
    this.labels = labels;
    this.name = name;
    this.network = network;
    this.region = region;
    this.selfLink = selfLink;
    this.vpnInterfaces = vpnInterfaces;
  }

  @Override
  public Object getFieldValue(String fieldName) {
    if ("creationTimestamp".equals(fieldName)) {
      return creationTimestamp;
    }
    if ("description".equals(fieldName)) {
      return description;
    }
    if ("id".equals(fieldName)) {
      return id;
    }
    if ("kind".equals(fieldName)) {
      return kind;
    }
    if ("labelFingerprint".equals(fieldName)) {
      return labelFingerprint;
    }
    if ("labels".equals(fieldName)) {
      return labels;
    }
    if ("name".equals(fieldName)) {
      return name;
    }
    if ("network".equals(fieldName)) {
      return network;
    }
    if ("region".equals(fieldName)) {
      return region;
    }
    if ("selfLink".equals(fieldName)) {
      return selfLink;
    }
    if ("vpnInterfaces".equals(fieldName)) {
      return vpnInterfaces;
    }
    return null;
  }

  @Nullable
  @Override
  public ApiMessage getApiMessageRequestBody() {
    return null;
  }

  @Nullable
  @Override
  /**
   * The fields that should be serialized (even if they have empty values). If the containing
   * message object has a non-null fieldmask, then all the fields in the field mask (and only those
   * fields in the field mask) will be serialized. If the containing object does not have a
   * fieldmask, then only non-empty fields will be serialized.
   */
  public List<String> getFieldMask() {
    return null;
  }

  /** [Output Only] Creation timestamp in RFC3339 text format. */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   */
  public String getDescription() {
    return description;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   */
  public String getId() {
    return id;
  }

  /** [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways. */
  public String getKind() {
    return kind;
  }

  /**
   * A fingerprint for the labels being applied to this VpnGateway, which is essentially a hash of
   * the labels set used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update labels. You must always provide an
   * up-to-date fingerprint hash in order to update or change labels, otherwise the request will
   * fail with error 412 conditionNotMet.
   *
   * <p>To see the latest fingerprint, make a get() request to retrieve an VpnGateway.
   */
  public String getLabelFingerprint() {
    return labelFingerprint;
  }

  /**
   * Labels for this resource. These can only be added or modified by the setLabels method. Each
   * label key/value pair must comply with RFC1035. Label values may be empty.
   */
  public Map<String, String> getLabelsMap() {
    return labels;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]&#42;[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   */
  public String getName() {
    return name;
  }

  /**
   * URL of the network to which this VPN gateway is attached. Provided by the client when the VPN
   * gateway is created.
   */
  public String getNetwork() {
    return network;
  }

  /** [Output Only] URL of the region where the VPN gateway resides. */
  public String getRegion() {
    return region;
  }

  /** [Output Only] Server-defined URL for the resource. */
  public String getSelfLink() {
    return selfLink;
  }

  /** A list of interfaces on this VPN gateway. */
  public List<VpnGatewayVpnGatewayInterface> getVpnInterfacesList() {
    return vpnInterfaces;
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(VpnGateway prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  public static VpnGateway getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final VpnGateway DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new VpnGateway();
  }

  public static class Builder {
    private String creationTimestamp;
    private String description;
    private String id;
    private String kind;
    private String labelFingerprint;
    private Map<String, String> labels;
    private String name;
    private String network;
    private String region;
    private String selfLink;
    private List<VpnGatewayVpnGatewayInterface> vpnInterfaces;

    Builder() {}

    public Builder mergeFrom(VpnGateway other) {
      if (other == VpnGateway.getDefaultInstance()) return this;
      if (other.getCreationTimestamp() != null) {
        this.creationTimestamp = other.creationTimestamp;
      }
      if (other.getDescription() != null) {
        this.description = other.description;
      }
      if (other.getId() != null) {
        this.id = other.id;
      }
      if (other.getKind() != null) {
        this.kind = other.kind;
      }
      if (other.getLabelFingerprint() != null) {
        this.labelFingerprint = other.labelFingerprint;
      }
      if (other.getLabelsMap() != null) {
        this.labels = other.labels;
      }
      if (other.getName() != null) {
        this.name = other.name;
      }
      if (other.getNetwork() != null) {
        this.network = other.network;
      }
      if (other.getRegion() != null) {
        this.region = other.region;
      }
      if (other.getSelfLink() != null) {
        this.selfLink = other.selfLink;
      }
      if (other.getVpnInterfacesList() != null) {
        this.vpnInterfaces = other.vpnInterfaces;
      }
      return this;
    }

    Builder(VpnGateway source) {
      this.creationTimestamp = source.creationTimestamp;
      this.description = source.description;
      this.id = source.id;
      this.kind = source.kind;
      this.labelFingerprint = source.labelFingerprint;
      this.labels = source.labels;
      this.name = source.name;
      this.network = source.network;
      this.region = source.region;
      this.selfLink = source.selfLink;
      this.vpnInterfaces = source.vpnInterfaces;
    }

    /** [Output Only] Creation timestamp in RFC3339 text format. */
    public String getCreationTimestamp() {
      return creationTimestamp;
    }

    /** [Output Only] Creation timestamp in RFC3339 text format. */
    public Builder setCreationTimestamp(String creationTimestamp) {
      this.creationTimestamp = creationTimestamp;
      return this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     */
    public String getDescription() {
      return description;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     */
    public Builder setDescription(String description) {
      this.description = description;
      return this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the
     * server.
     */
    public String getId() {
      return id;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the
     * server.
     */
    public Builder setId(String id) {
      this.id = id;
      return this;
    }

    /** [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways. */
    public String getKind() {
      return kind;
    }

    /** [Output Only] Type of resource. Always compute#vpnGateway for VPN gateways. */
    public Builder setKind(String kind) {
      this.kind = kind;
      return this;
    }

    /**
     * A fingerprint for the labels being applied to this VpnGateway, which is essentially a hash of
     * the labels set used for optimistic locking. The fingerprint is initially generated by Compute
     * Engine and changes after every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels, otherwise the request will
     * fail with error 412 conditionNotMet.
     *
     * <p>To see the latest fingerprint, make a get() request to retrieve an VpnGateway.
     */
    public String getLabelFingerprint() {
      return labelFingerprint;
    }

    /**
     * A fingerprint for the labels being applied to this VpnGateway, which is essentially a hash of
     * the labels set used for optimistic locking. The fingerprint is initially generated by Compute
     * Engine and changes after every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels, otherwise the request will
     * fail with error 412 conditionNotMet.
     *
     * <p>To see the latest fingerprint, make a get() request to retrieve an VpnGateway.
     */
    public Builder setLabelFingerprint(String labelFingerprint) {
      this.labelFingerprint = labelFingerprint;
      return this;
    }

    /**
     * Labels for this resource. These can only be added or modified by the setLabels method. Each
     * label key/value pair must comply with RFC1035. Label values may be empty.
     */
    public Map<String, String> getLabelsMap() {
      return labels;
    }

    /**
     * Labels for this resource. These can only be added or modified by the setLabels method. Each
     * label key/value pair must comply with RFC1035. Label values may be empty.
     */
    public Builder putAllLabels(Map<String, String> labels) {
      this.labels = labels;
      return this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be
     * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression `[a-z]([-a-z0-9]&#42;[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must be a dash, lowercase
     * letter, or digit, except the last character, which cannot be a dash.
     */
    public String getName() {
      return name;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be
     * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression `[a-z]([-a-z0-9]&#42;[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must be a dash, lowercase
     * letter, or digit, except the last character, which cannot be a dash.
     */
    public Builder setName(String name) {
      this.name = name;
      return this;
    }

    /**
     * URL of the network to which this VPN gateway is attached. Provided by the client when the VPN
     * gateway is created.
     */
    public String getNetwork() {
      return network;
    }

    /**
     * URL of the network to which this VPN gateway is attached. Provided by the client when the VPN
     * gateway is created.
     */
    public Builder setNetwork(String network) {
      this.network = network;
      return this;
    }

    /** [Output Only] URL of the region where the VPN gateway resides. */
    public String getRegion() {
      return region;
    }

    /** [Output Only] URL of the region where the VPN gateway resides. */
    public Builder setRegion(String region) {
      this.region = region;
      return this;
    }

    /** [Output Only] Server-defined URL for the resource. */
    public String getSelfLink() {
      return selfLink;
    }

    /** [Output Only] Server-defined URL for the resource. */
    public Builder setSelfLink(String selfLink) {
      this.selfLink = selfLink;
      return this;
    }

    /** A list of interfaces on this VPN gateway. */
    public List<VpnGatewayVpnGatewayInterface> getVpnInterfacesList() {
      return vpnInterfaces;
    }

    /** A list of interfaces on this VPN gateway. */
    public Builder addAllVpnInterfaces(List<VpnGatewayVpnGatewayInterface> vpnInterfaces) {
      if (this.vpnInterfaces == null) {
        this.vpnInterfaces = new LinkedList<>();
      }
      this.vpnInterfaces.addAll(vpnInterfaces);
      return this;
    }

    /** A list of interfaces on this VPN gateway. */
    public Builder addVpnInterfaces(VpnGatewayVpnGatewayInterface vpnInterfaces) {
      if (this.vpnInterfaces == null) {
        this.vpnInterfaces = new LinkedList<>();
      }
      this.vpnInterfaces.add(vpnInterfaces);
      return this;
    }

    public VpnGateway build() {

      return new VpnGateway(
          creationTimestamp,
          description,
          id,
          kind,
          labelFingerprint,
          labels,
          name,
          network,
          region,
          selfLink,
          vpnInterfaces);
    }

    public Builder clone() {
      Builder newBuilder = new Builder();
      newBuilder.setCreationTimestamp(this.creationTimestamp);
      newBuilder.setDescription(this.description);
      newBuilder.setId(this.id);
      newBuilder.setKind(this.kind);
      newBuilder.setLabelFingerprint(this.labelFingerprint);
      newBuilder.putAllLabels(this.labels);
      newBuilder.setName(this.name);
      newBuilder.setNetwork(this.network);
      newBuilder.setRegion(this.region);
      newBuilder.setSelfLink(this.selfLink);
      newBuilder.addAllVpnInterfaces(this.vpnInterfaces);
      return newBuilder;
    }
  }

  @Override
  public String toString() {
    return "VpnGateway{"
        + "creationTimestamp="
        + creationTimestamp
        + ", "
        + "description="
        + description
        + ", "
        + "id="
        + id
        + ", "
        + "kind="
        + kind
        + ", "
        + "labelFingerprint="
        + labelFingerprint
        + ", "
        + "labels="
        + labels
        + ", "
        + "name="
        + name
        + ", "
        + "network="
        + network
        + ", "
        + "region="
        + region
        + ", "
        + "selfLink="
        + selfLink
        + ", "
        + "vpnInterfaces="
        + vpnInterfaces
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof VpnGateway) {
      VpnGateway that = (VpnGateway) o;
      return Objects.equals(this.creationTimestamp, that.getCreationTimestamp())
          && Objects.equals(this.description, that.getDescription())
          && Objects.equals(this.id, that.getId())
          && Objects.equals(this.kind, that.getKind())
          && Objects.equals(this.labelFingerprint, that.getLabelFingerprint())
          && Objects.equals(this.labels, that.getLabelsMap())
          && Objects.equals(this.name, that.getName())
          && Objects.equals(this.network, that.getNetwork())
          && Objects.equals(this.region, that.getRegion())
          && Objects.equals(this.selfLink, that.getSelfLink())
          && Objects.equals(this.vpnInterfaces, that.getVpnInterfacesList());
    }
    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        creationTimestamp,
        description,
        id,
        kind,
        labelFingerprint,
        labels,
        name,
        network,
        region,
        selfLink,
        vpnInterfaces);
  }
}
