/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.cloud.compute.v1.stub;

import static com.google.cloud.compute.v1.ZoneOperationClient.ListZoneOperationsPagedResponse;

import com.google.api.client.http.HttpMethods;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteZoneOperationHttpRequest;
import com.google.cloud.compute.v1.GetZoneOperationHttpRequest;
import com.google.cloud.compute.v1.ListZoneOperationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.ProjectZoneOperationName;
import com.google.cloud.compute.v1.WaitZoneOperationHttpRequest;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS
/**
 * HTTP stub implementation for compute.
 *
 * <p>This class is for advanced usage and reflects the underlying API directly.
 */
@Generated("by gapic-generator")
@BetaApi("A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonZoneOperationStub extends ZoneOperationStub {
  @InternalApi
  public static final ApiMethodDescriptor<DeleteZoneOperationHttpRequest, Void>
      deleteZoneOperationMethodDescriptor =
          ApiMethodDescriptor.<DeleteZoneOperationHttpRequest, Void>newBuilder()
              .setFullMethodName("compute.zoneOperations.delete")
              .setHttpMethod(HttpMethods.DELETE)
              .setRequestFormatter(
                  ApiMessageHttpRequestFormatter.<DeleteZoneOperationHttpRequest>newBuilder()
                      .setPathTemplate(
                          PathTemplate.create("{project}/zones/{zone}/operations/{operation}"))
                      .setQueryParams(Sets.<String>newHashSet())
                      .setResourceNameFactory(ProjectZoneOperationName.newFactory())
                      .setResourceNameField("operation")
                      .build())
              .build();

  @InternalApi
  public static final ApiMethodDescriptor<GetZoneOperationHttpRequest, Operation>
      getZoneOperationMethodDescriptor =
          ApiMethodDescriptor.<GetZoneOperationHttpRequest, Operation>newBuilder()
              .setFullMethodName("compute.zoneOperations.get")
              .setHttpMethod(HttpMethods.GET)
              .setRequestFormatter(
                  ApiMessageHttpRequestFormatter.<GetZoneOperationHttpRequest>newBuilder()
                      .setPathTemplate(
                          PathTemplate.create("{project}/zones/{zone}/operations/{operation}"))
                      .setQueryParams(Sets.<String>newHashSet())
                      .setResourceNameFactory(ProjectZoneOperationName.newFactory())
                      .setResourceNameField("operation")
                      .build())
              .setResponseParser(
                  ApiMessageHttpResponseParser.<Operation>newBuilder()
                      .setResponseInstance(Operation.getDefaultInstance())
                      .build())
              .build();

  @InternalApi
  public static final ApiMethodDescriptor<ListZoneOperationsHttpRequest, OperationList>
      listZoneOperationsMethodDescriptor =
          ApiMethodDescriptor.<ListZoneOperationsHttpRequest, OperationList>newBuilder()
              .setFullMethodName("compute.zoneOperations.list")
              .setHttpMethod(HttpMethods.GET)
              .setRequestFormatter(
                  ApiMessageHttpRequestFormatter.<ListZoneOperationsHttpRequest>newBuilder()
                      .setPathTemplate(PathTemplate.create("{project}/zones/{zone}/operations"))
                      .setQueryParams(
                          Sets.<String>newHashSet("filter", "maxResults", "orderBy", "pageToken"))
                      .setResourceNameFactory(ProjectZoneName.newFactory())
                      .setResourceNameField("zone")
                      .build())
              .setResponseParser(
                  ApiMessageHttpResponseParser.<OperationList>newBuilder()
                      .setResponseInstance(OperationList.getDefaultInstance())
                      .build())
              .build();

  @InternalApi
  public static final ApiMethodDescriptor<WaitZoneOperationHttpRequest, Operation>
      waitZoneOperationMethodDescriptor =
          ApiMethodDescriptor.<WaitZoneOperationHttpRequest, Operation>newBuilder()
              .setFullMethodName("compute.zoneOperations.wait")
              .setHttpMethod(HttpMethods.POST)
              .setRequestFormatter(
                  ApiMessageHttpRequestFormatter.<WaitZoneOperationHttpRequest>newBuilder()
                      .setPathTemplate(
                          PathTemplate.create("{project}/zones/{zone}/operations/{operation}/wait"))
                      .setQueryParams(Sets.<String>newHashSet())
                      .setResourceNameFactory(ProjectZoneOperationName.newFactory())
                      .setResourceNameField("operation")
                      .build())
              .setResponseParser(
                  ApiMessageHttpResponseParser.<Operation>newBuilder()
                      .setResponseInstance(Operation.getDefaultInstance())
                      .build())
              .build();

  private final BackgroundResource backgroundResources;

  private final UnaryCallable<DeleteZoneOperationHttpRequest, Void> deleteZoneOperationCallable;
  private final UnaryCallable<GetZoneOperationHttpRequest, Operation> getZoneOperationCallable;
  private final UnaryCallable<ListZoneOperationsHttpRequest, OperationList>
      listZoneOperationsCallable;
  private final UnaryCallable<ListZoneOperationsHttpRequest, ListZoneOperationsPagedResponse>
      listZoneOperationsPagedCallable;
  private final UnaryCallable<WaitZoneOperationHttpRequest, Operation> waitZoneOperationCallable;

  private final HttpJsonStubCallableFactory callableFactory;

  public static final HttpJsonZoneOperationStub create(ZoneOperationStubSettings settings)
      throws IOException {
    return new HttpJsonZoneOperationStub(settings, ClientContext.create(settings));
  }

  public static final HttpJsonZoneOperationStub create(ClientContext clientContext)
      throws IOException {
    return new HttpJsonZoneOperationStub(
        ZoneOperationStubSettings.newBuilder().build(), clientContext);
  }

  public static final HttpJsonZoneOperationStub create(
      ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
    return new HttpJsonZoneOperationStub(
        ZoneOperationStubSettings.newBuilder().build(), clientContext, callableFactory);
  }

  /**
   * Constructs an instance of HttpJsonZoneOperationStub, using the given settings. This is
   * protected so that it is easy to make a subclass, but otherwise, the static factory methods
   * should be preferred.
   */
  protected HttpJsonZoneOperationStub(
      ZoneOperationStubSettings settings, ClientContext clientContext) throws IOException {
    this(settings, clientContext, new HttpJsonZoneOperationCallableFactory());
  }

  /**
   * Constructs an instance of HttpJsonZoneOperationStub, using the given settings. This is
   * protected so that it is easy to make a subclass, but otherwise, the static factory methods
   * should be preferred.
   */
  protected HttpJsonZoneOperationStub(
      ZoneOperationStubSettings settings,
      ClientContext clientContext,
      HttpJsonStubCallableFactory callableFactory)
      throws IOException {
    this.callableFactory = callableFactory;

    HttpJsonCallSettings<DeleteZoneOperationHttpRequest, Void>
        deleteZoneOperationTransportSettings =
            HttpJsonCallSettings.<DeleteZoneOperationHttpRequest, Void>newBuilder()
                .setMethodDescriptor(deleteZoneOperationMethodDescriptor)
                .build();
    HttpJsonCallSettings<GetZoneOperationHttpRequest, Operation> getZoneOperationTransportSettings =
        HttpJsonCallSettings.<GetZoneOperationHttpRequest, Operation>newBuilder()
            .setMethodDescriptor(getZoneOperationMethodDescriptor)
            .build();
    HttpJsonCallSettings<ListZoneOperationsHttpRequest, OperationList>
        listZoneOperationsTransportSettings =
            HttpJsonCallSettings.<ListZoneOperationsHttpRequest, OperationList>newBuilder()
                .setMethodDescriptor(listZoneOperationsMethodDescriptor)
                .build();
    HttpJsonCallSettings<WaitZoneOperationHttpRequest, Operation>
        waitZoneOperationTransportSettings =
            HttpJsonCallSettings.<WaitZoneOperationHttpRequest, Operation>newBuilder()
                .setMethodDescriptor(waitZoneOperationMethodDescriptor)
                .build();

    this.deleteZoneOperationCallable =
        callableFactory.createUnaryCallable(
            deleteZoneOperationTransportSettings,
            settings.deleteZoneOperationSettings(),
            clientContext);
    this.getZoneOperationCallable =
        callableFactory.createUnaryCallable(
            getZoneOperationTransportSettings, settings.getZoneOperationSettings(), clientContext);
    this.listZoneOperationsCallable =
        callableFactory.createUnaryCallable(
            listZoneOperationsTransportSettings,
            settings.listZoneOperationsSettings(),
            clientContext);
    this.listZoneOperationsPagedCallable =
        callableFactory.createPagedCallable(
            listZoneOperationsTransportSettings,
            settings.listZoneOperationsSettings(),
            clientContext);
    this.waitZoneOperationCallable =
        callableFactory.createUnaryCallable(
            waitZoneOperationTransportSettings,
            settings.waitZoneOperationSettings(),
            clientContext);

    backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
  }

  @BetaApi
  public UnaryCallable<DeleteZoneOperationHttpRequest, Void> deleteZoneOperationCallable() {
    return deleteZoneOperationCallable;
  }

  @BetaApi
  public UnaryCallable<GetZoneOperationHttpRequest, Operation> getZoneOperationCallable() {
    return getZoneOperationCallable;
  }

  @BetaApi
  public UnaryCallable<ListZoneOperationsHttpRequest, ListZoneOperationsPagedResponse>
      listZoneOperationsPagedCallable() {
    return listZoneOperationsPagedCallable;
  }

  @BetaApi
  public UnaryCallable<ListZoneOperationsHttpRequest, OperationList> listZoneOperationsCallable() {
    return listZoneOperationsCallable;
  }

  @BetaApi
  public UnaryCallable<WaitZoneOperationHttpRequest, Operation> waitZoneOperationCallable() {
    return waitZoneOperationCallable;
  }

  @Override
  public final void close() {
    shutdown();
  }

  @Override
  public void shutdown() {
    backgroundResources.shutdown();
  }

  @Override
  public boolean isShutdown() {
    return backgroundResources.isShutdown();
  }

  @Override
  public boolean isTerminated() {
    return backgroundResources.isTerminated();
  }

  @Override
  public void shutdownNow() {
    backgroundResources.shutdownNow();
  }

  @Override
  public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
    return backgroundResources.awaitTermination(duration, unit);
  }
}
