/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HealthCheckService
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String fingerprint;
    private final List<String> healthChecks;
    private final String healthStatusAggregationPolicy;
    private final String id;
    private final String kind;
    private final String name;
    private final List<String> networkEndpointGroups;
    private final List<String> notificationEndpoints;
    private final String region;
    private final String selfLink;
    private static final HealthCheckService DEFAULT_INSTANCE = new HealthCheckService();

    private HealthCheckService() {
        this.creationTimestamp = null;
        this.description = null;
        this.fingerprint = null;
        this.healthChecks = null;
        this.healthStatusAggregationPolicy = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.networkEndpointGroups = null;
        this.notificationEndpoints = null;
        this.region = null;
        this.selfLink = null;
    }

    private HealthCheckService(String creationTimestamp, String description, String fingerprint, List<String> healthChecks, String healthStatusAggregationPolicy, String id, String kind, String name, List<String> networkEndpointGroups, List<String> notificationEndpoints, String region, String selfLink) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.fingerprint = fingerprint;
        this.healthChecks = healthChecks;
        this.healthStatusAggregationPolicy = healthStatusAggregationPolicy;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.networkEndpointGroups = networkEndpointGroups;
        this.notificationEndpoints = notificationEndpoints;
        this.region = region;
        this.selfLink = selfLink;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("fingerprint".equals(fieldName)) {
            return this.fingerprint;
        }
        if ("healthChecks".equals(fieldName)) {
            return this.healthChecks;
        }
        if ("healthStatusAggregationPolicy".equals(fieldName)) {
            return this.healthStatusAggregationPolicy;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("networkEndpointGroups".equals(fieldName)) {
            return this.networkEndpointGroups;
        }
        if ("notificationEndpoints".equals(fieldName)) {
            return this.notificationEndpoints;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public List<String> getHealthChecksList() {
        return this.healthChecks;
    }

    public String getHealthStatusAggregationPolicy() {
        return this.healthStatusAggregationPolicy;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getNetworkEndpointGroupsList() {
        return this.networkEndpointGroups;
    }

    public List<String> getNotificationEndpointsList() {
        return this.notificationEndpoints;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HealthCheckService prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HealthCheckService getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HealthCheckService{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", fingerprint=" + this.fingerprint + ", healthChecks=" + this.healthChecks + ", healthStatusAggregationPolicy=" + this.healthStatusAggregationPolicy + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", networkEndpointGroups=" + this.networkEndpointGroups + ", notificationEndpoints=" + this.notificationEndpoints + ", region=" + this.region + ", selfLink=" + this.selfLink + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HealthCheckService) {
            HealthCheckService that = (HealthCheckService)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.healthChecks, that.getHealthChecksList()) && Objects.equals(this.healthStatusAggregationPolicy, that.getHealthStatusAggregationPolicy()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.networkEndpointGroups, that.getNetworkEndpointGroupsList()) && Objects.equals(this.notificationEndpoints, that.getNotificationEndpointsList()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.fingerprint, this.healthChecks, this.healthStatusAggregationPolicy, this.id, this.kind, this.name, this.networkEndpointGroups, this.notificationEndpoints, this.region, this.selfLink);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String fingerprint;
        private List<String> healthChecks;
        private String healthStatusAggregationPolicy;
        private String id;
        private String kind;
        private String name;
        private List<String> networkEndpointGroups;
        private List<String> notificationEndpoints;
        private String region;
        private String selfLink;

        Builder() {
        }

        public Builder mergeFrom(HealthCheckService other) {
            if (other == HealthCheckService.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getHealthChecksList() != null) {
                this.healthChecks = other.healthChecks;
            }
            if (other.getHealthStatusAggregationPolicy() != null) {
                this.healthStatusAggregationPolicy = other.healthStatusAggregationPolicy;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetworkEndpointGroupsList() != null) {
                this.networkEndpointGroups = other.networkEndpointGroups;
            }
            if (other.getNotificationEndpointsList() != null) {
                this.notificationEndpoints = other.notificationEndpoints;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            return this;
        }

        Builder(HealthCheckService source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.fingerprint = source.fingerprint;
            this.healthChecks = source.healthChecks;
            this.healthStatusAggregationPolicy = source.healthStatusAggregationPolicy;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.networkEndpointGroups = source.networkEndpointGroups;
            this.notificationEndpoints = source.notificationEndpoints;
            this.region = source.region;
            this.selfLink = source.selfLink;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public List<String> getHealthChecksList() {
            return this.healthChecks;
        }

        public Builder addAllHealthChecks(List<String> healthChecks) {
            if (this.healthChecks == null) {
                this.healthChecks = new LinkedList<String>();
            }
            this.healthChecks.addAll(healthChecks);
            return this;
        }

        public Builder addHealthChecks(String healthChecks) {
            if (this.healthChecks == null) {
                this.healthChecks = new LinkedList<String>();
            }
            this.healthChecks.add(healthChecks);
            return this;
        }

        public String getHealthStatusAggregationPolicy() {
            return this.healthStatusAggregationPolicy;
        }

        public Builder setHealthStatusAggregationPolicy(String healthStatusAggregationPolicy) {
            this.healthStatusAggregationPolicy = healthStatusAggregationPolicy;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public List<String> getNetworkEndpointGroupsList() {
            return this.networkEndpointGroups;
        }

        public Builder addAllNetworkEndpointGroups(List<String> networkEndpointGroups) {
            if (this.networkEndpointGroups == null) {
                this.networkEndpointGroups = new LinkedList<String>();
            }
            this.networkEndpointGroups.addAll(networkEndpointGroups);
            return this;
        }

        public Builder addNetworkEndpointGroups(String networkEndpointGroups) {
            if (this.networkEndpointGroups == null) {
                this.networkEndpointGroups = new LinkedList<String>();
            }
            this.networkEndpointGroups.add(networkEndpointGroups);
            return this;
        }

        public List<String> getNotificationEndpointsList() {
            return this.notificationEndpoints;
        }

        public Builder addAllNotificationEndpoints(List<String> notificationEndpoints) {
            if (this.notificationEndpoints == null) {
                this.notificationEndpoints = new LinkedList<String>();
            }
            this.notificationEndpoints.addAll(notificationEndpoints);
            return this;
        }

        public Builder addNotificationEndpoints(String notificationEndpoints) {
            if (this.notificationEndpoints == null) {
                this.notificationEndpoints = new LinkedList<String>();
            }
            this.notificationEndpoints.add(notificationEndpoints);
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public HealthCheckService build() {
            return new HealthCheckService(this.creationTimestamp, this.description, this.fingerprint, this.healthChecks, this.healthStatusAggregationPolicy, this.id, this.kind, this.name, this.networkEndpointGroups, this.notificationEndpoints, this.region, this.selfLink);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.addAllHealthChecks(this.healthChecks);
            newBuilder.setHealthStatusAggregationPolicy(this.healthStatusAggregationPolicy);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.addAllNetworkEndpointGroups(this.networkEndpointGroups);
            newBuilder.addAllNotificationEndpoints(this.notificationEndpoints);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            return newBuilder;
        }
    }
}

