/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalInterconnectName
implements ResourceName {
    private final String interconnect;
    private final String project;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/interconnects/{interconnect}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalInterconnectName(Builder builder) {
        this.interconnect = (String)Preconditions.checkNotNull((Object)builder.getInterconnect());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectGlobalInterconnectName of(String interconnect, String project) {
        return ProjectGlobalInterconnectName.newBuilder().setInterconnect(interconnect).setProject(project).build();
    }

    public static String format(String interconnect, String project) {
        return ProjectGlobalInterconnectName.of(interconnect, project).toString();
    }

    public String getInterconnect() {
        return this.interconnect;
    }

    public String getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalInterconnectName projectGlobalInterconnectName = this;
            synchronized (projectGlobalInterconnectName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"interconnect", (Object)this.interconnect);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalInterconnectName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalInterconnectName>(){

            public ProjectGlobalInterconnectName parse(String formattedString) {
                return ProjectGlobalInterconnectName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalInterconnectName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalInterconnectName.parse: formattedString not in valid format");
        return ProjectGlobalInterconnectName.of((String)matchMap.get("interconnect"), (String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"interconnect", this.interconnect, "project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalInterconnectName) {
            ProjectGlobalInterconnectName that = (ProjectGlobalInterconnectName)o;
            return Objects.equals(this.interconnect, that.getInterconnect()) && Objects.equals(this.project, that.getProject());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.interconnect, this.project);
    }

    public static class Builder {
        private String interconnect;
        private String project;

        public String getInterconnect() {
            return this.interconnect;
        }

        public String getProject() {
            return this.project;
        }

        public Builder setInterconnect(String interconnect) {
            this.interconnect = interconnect;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalInterconnectName projectGlobalInterconnectName) {
            this.interconnect = projectGlobalInterconnectName.interconnect;
            this.project = projectGlobalInterconnectName.project;
        }

        public ProjectGlobalInterconnectName build() {
            return new ProjectGlobalInterconnectName(this);
        }
    }
}

