/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionHealthCheckServiceName
implements ResourceName {
    private final String healthCheckService;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/healthCheckServices/{healthCheckService}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionHealthCheckServiceName(Builder builder) {
        this.healthCheckService = (String)Preconditions.checkNotNull((Object)builder.getHealthCheckService());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionHealthCheckServiceName of(String healthCheckService, String project, String region) {
        return ProjectRegionHealthCheckServiceName.newBuilder().setHealthCheckService(healthCheckService).setProject(project).setRegion(region).build();
    }

    public static String format(String healthCheckService, String project, String region) {
        return ProjectRegionHealthCheckServiceName.of(healthCheckService, project, region).toString();
    }

    public String getHealthCheckService() {
        return this.healthCheckService;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionHealthCheckServiceName projectRegionHealthCheckServiceName = this;
            synchronized (projectRegionHealthCheckServiceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"healthCheckService", (Object)this.healthCheckService);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionHealthCheckServiceName> newFactory() {
        return new ResourceNameFactory<ProjectRegionHealthCheckServiceName>(){

            public ProjectRegionHealthCheckServiceName parse(String formattedString) {
                return ProjectRegionHealthCheckServiceName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionHealthCheckServiceName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionHealthCheckServiceName.parse: formattedString not in valid format");
        return ProjectRegionHealthCheckServiceName.of((String)matchMap.get("healthCheckService"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"healthCheckService", this.healthCheckService, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionHealthCheckServiceName) {
            ProjectRegionHealthCheckServiceName that = (ProjectRegionHealthCheckServiceName)o;
            return Objects.equals(this.healthCheckService, that.getHealthCheckService()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.healthCheckService, this.project, this.region);
    }

    public static class Builder {
        private String healthCheckService;
        private String project;
        private String region;

        public String getHealthCheckService() {
            return this.healthCheckService;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setHealthCheckService(String healthCheckService) {
            this.healthCheckService = healthCheckService;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionHealthCheckServiceName projectRegionHealthCheckServiceName) {
            this.healthCheckService = projectRegionHealthCheckServiceName.healthCheckService;
            this.project = projectRegionHealthCheckServiceName.project;
            this.region = projectRegionHealthCheckServiceName.region;
        }

        public ProjectRegionHealthCheckServiceName build() {
            return new ProjectRegionHealthCheckServiceName(this);
        }
    }
}

