/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListResourcePoliciesHttpRequest;
import com.google.cloud.compute.v1.DeleteResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.GetResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.InsertResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.ListResourcePoliciesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionResourcePolicyName;
import com.google.cloud.compute.v1.ProjectRegionResourcePolicyResourceName;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.ResourcePoliciesScopedList;
import com.google.cloud.compute.v1.ResourcePolicy;
import com.google.cloud.compute.v1.ResourcePolicyAggregatedList;
import com.google.cloud.compute.v1.ResourcePolicyList;
import com.google.cloud.compute.v1.ResourcePolicySettings;
import com.google.cloud.compute.v1.SetIamPolicyResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsResourcePolicyHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.ResourcePolicyStub;
import com.google.cloud.compute.v1.stub.ResourcePolicyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ResourcePolicyClient
implements BackgroundResource {
    private final ResourcePolicySettings settings;
    private final ResourcePolicyStub stub;

    public static final ResourcePolicyClient create() throws IOException {
        return ResourcePolicyClient.create(ResourcePolicySettings.newBuilder().build());
    }

    public static final ResourcePolicyClient create(ResourcePolicySettings settings) throws IOException {
        return new ResourcePolicyClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ResourcePolicyClient create(ResourcePolicyStub stub) {
        return new ResourcePolicyClient(stub);
    }

    protected ResourcePolicyClient(ResourcePolicySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ResourcePolicyStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ResourcePolicyClient(ResourcePolicyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ResourcePolicySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ResourcePolicyStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final AggregatedListResourcePoliciesPagedResponse aggregatedListResourcePolicies(Boolean includeAllScopes, ProjectName project) {
        AggregatedListResourcePoliciesHttpRequest request = AggregatedListResourcePoliciesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project == null ? null : project.toString()).build();
        return this.aggregatedListResourcePolicies(request);
    }

    @BetaApi
    public final AggregatedListResourcePoliciesPagedResponse aggregatedListResourcePolicies(Boolean includeAllScopes, String project) {
        AggregatedListResourcePoliciesHttpRequest request = AggregatedListResourcePoliciesHttpRequest.newBuilder().setIncludeAllScopes(includeAllScopes).setProject(project).build();
        return this.aggregatedListResourcePolicies(request);
    }

    @BetaApi
    public final AggregatedListResourcePoliciesPagedResponse aggregatedListResourcePolicies(AggregatedListResourcePoliciesHttpRequest request) {
        return (AggregatedListResourcePoliciesPagedResponse)((Object)this.aggregatedListResourcePoliciesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<AggregatedListResourcePoliciesHttpRequest, AggregatedListResourcePoliciesPagedResponse> aggregatedListResourcePoliciesPagedCallable() {
        return this.stub.aggregatedListResourcePoliciesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList> aggregatedListResourcePoliciesCallable() {
        return this.stub.aggregatedListResourcePoliciesCallable();
    }

    @BetaApi
    public final Operation deleteResourcePolicy(ProjectRegionResourcePolicyName resourcePolicy) {
        DeleteResourcePolicyHttpRequest request = DeleteResourcePolicyHttpRequest.newBuilder().setResourcePolicy(resourcePolicy == null ? null : resourcePolicy.toString()).build();
        return this.deleteResourcePolicy(request);
    }

    @BetaApi
    public final Operation deleteResourcePolicy(String resourcePolicy) {
        DeleteResourcePolicyHttpRequest request = DeleteResourcePolicyHttpRequest.newBuilder().setResourcePolicy(resourcePolicy).build();
        return this.deleteResourcePolicy(request);
    }

    @BetaApi
    public final Operation deleteResourcePolicy(DeleteResourcePolicyHttpRequest request) {
        return (Operation)this.deleteResourcePolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteResourcePolicyHttpRequest, Operation> deleteResourcePolicyCallable() {
        return this.stub.deleteResourcePolicyCallable();
    }

    @BetaApi
    public final ResourcePolicy getResourcePolicy(ProjectRegionResourcePolicyName resourcePolicy) {
        GetResourcePolicyHttpRequest request = GetResourcePolicyHttpRequest.newBuilder().setResourcePolicy(resourcePolicy == null ? null : resourcePolicy.toString()).build();
        return this.getResourcePolicy(request);
    }

    @BetaApi
    public final ResourcePolicy getResourcePolicy(String resourcePolicy) {
        GetResourcePolicyHttpRequest request = GetResourcePolicyHttpRequest.newBuilder().setResourcePolicy(resourcePolicy).build();
        return this.getResourcePolicy(request);
    }

    @BetaApi
    public final ResourcePolicy getResourcePolicy(GetResourcePolicyHttpRequest request) {
        return (ResourcePolicy)this.getResourcePolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetResourcePolicyHttpRequest, ResourcePolicy> getResourcePolicyCallable() {
        return this.stub.getResourcePolicyCallable();
    }

    @BetaApi
    public final Policy getIamPolicyResourcePolicy(Integer optionsRequestedPolicyVersion, ProjectRegionResourcePolicyResourceName resource) {
        GetIamPolicyResourcePolicyHttpRequest request = GetIamPolicyResourcePolicyHttpRequest.newBuilder().setOptionsRequestedPolicyVersion(optionsRequestedPolicyVersion).setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicyResourcePolicy(request);
    }

    @BetaApi
    public final Policy getIamPolicyResourcePolicy(Integer optionsRequestedPolicyVersion, String resource) {
        GetIamPolicyResourcePolicyHttpRequest request = GetIamPolicyResourcePolicyHttpRequest.newBuilder().setOptionsRequestedPolicyVersion(optionsRequestedPolicyVersion).setResource(resource).build();
        return this.getIamPolicyResourcePolicy(request);
    }

    @BetaApi
    public final Policy getIamPolicyResourcePolicy(GetIamPolicyResourcePolicyHttpRequest request) {
        return (Policy)this.getIamPolicyResourcePolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetIamPolicyResourcePolicyHttpRequest, Policy> getIamPolicyResourcePolicyCallable() {
        return this.stub.getIamPolicyResourcePolicyCallable();
    }

    @BetaApi
    public final Operation insertResourcePolicy(ProjectRegionName region, ResourcePolicy resourcePolicyResource) {
        InsertResourcePolicyHttpRequest request = InsertResourcePolicyHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setResourcePolicyResource(resourcePolicyResource).build();
        return this.insertResourcePolicy(request);
    }

    @BetaApi
    public final Operation insertResourcePolicy(String region, ResourcePolicy resourcePolicyResource) {
        InsertResourcePolicyHttpRequest request = InsertResourcePolicyHttpRequest.newBuilder().setRegion(region).setResourcePolicyResource(resourcePolicyResource).build();
        return this.insertResourcePolicy(request);
    }

    @BetaApi
    public final Operation insertResourcePolicy(InsertResourcePolicyHttpRequest request) {
        return (Operation)this.insertResourcePolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertResourcePolicyHttpRequest, Operation> insertResourcePolicyCallable() {
        return this.stub.insertResourcePolicyCallable();
    }

    @BetaApi
    public final ListResourcePoliciesPagedResponse listResourcePolicies(ProjectRegionName region) {
        ListResourcePoliciesHttpRequest request = ListResourcePoliciesHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listResourcePolicies(request);
    }

    @BetaApi
    public final ListResourcePoliciesPagedResponse listResourcePolicies(String region) {
        ListResourcePoliciesHttpRequest request = ListResourcePoliciesHttpRequest.newBuilder().setRegion(region).build();
        return this.listResourcePolicies(request);
    }

    @BetaApi
    public final ListResourcePoliciesPagedResponse listResourcePolicies(ListResourcePoliciesHttpRequest request) {
        return (ListResourcePoliciesPagedResponse)((Object)this.listResourcePoliciesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListResourcePoliciesHttpRequest, ListResourcePoliciesPagedResponse> listResourcePoliciesPagedCallable() {
        return this.stub.listResourcePoliciesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListResourcePoliciesHttpRequest, ResourcePolicyList> listResourcePoliciesCallable() {
        return this.stub.listResourcePoliciesCallable();
    }

    @BetaApi
    public final Policy setIamPolicyResourcePolicy(ProjectRegionResourcePolicyResourceName resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyResourcePolicyHttpRequest request = SetIamPolicyResourcePolicyHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicyResourcePolicy(request);
    }

    @BetaApi
    public final Policy setIamPolicyResourcePolicy(String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyResourcePolicyHttpRequest request = SetIamPolicyResourcePolicyHttpRequest.newBuilder().setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicyResourcePolicy(request);
    }

    @BetaApi
    public final Policy setIamPolicyResourcePolicy(SetIamPolicyResourcePolicyHttpRequest request) {
        return (Policy)this.setIamPolicyResourcePolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetIamPolicyResourcePolicyHttpRequest, Policy> setIamPolicyResourcePolicyCallable() {
        return this.stub.setIamPolicyResourcePolicyCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsResourcePolicy(ProjectRegionResourcePolicyResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsResourcePolicyHttpRequest request = TestIamPermissionsResourcePolicyHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsResourcePolicy(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsResourcePolicy(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsResourcePolicyHttpRequest request = TestIamPermissionsResourcePolicyHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsResourcePolicy(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsResourcePolicy(TestIamPermissionsResourcePolicyHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsResourcePolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsResourcePolicyHttpRequest, TestPermissionsResponse> testIamPermissionsResourcePolicyCallable() {
        return this.stub.testIamPermissionsResourcePolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListResourcePoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicy, ListResourcePoliciesPage, ListResourcePoliciesFixedSizeCollection> {
        private ListResourcePoliciesFixedSizeCollection(List<ListResourcePoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListResourcePoliciesFixedSizeCollection createEmptyCollection() {
            return new ListResourcePoliciesFixedSizeCollection(null, 0);
        }

        protected ListResourcePoliciesFixedSizeCollection createCollection(List<ListResourcePoliciesPage> pages, int collectionSize) {
            return new ListResourcePoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListResourcePoliciesPage
    extends AbstractPage<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicy, ListResourcePoliciesPage> {
        private ListResourcePoliciesPage(PageContext<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicy> context, ResourcePolicyList response) {
            super(context, (Object)response);
        }

        private static ListResourcePoliciesPage createEmptyPage() {
            return new ListResourcePoliciesPage(null, null);
        }

        protected ListResourcePoliciesPage createPage(PageContext<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicy> context, ResourcePolicyList response) {
            return new ListResourcePoliciesPage(context, response);
        }

        public ApiFuture<ListResourcePoliciesPage> createPageAsync(PageContext<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicy> context, ApiFuture<ResourcePolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListResourcePoliciesPagedResponse
    extends AbstractPagedListResponse<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicy, ListResourcePoliciesPage, ListResourcePoliciesFixedSizeCollection> {
        public static ApiFuture<ListResourcePoliciesPagedResponse> createAsync(PageContext<ListResourcePoliciesHttpRequest, ResourcePolicyList, ResourcePolicy> context, ApiFuture<ResourcePolicyList> futureResponse) {
            ApiFuture<ListResourcePoliciesPage> futurePage = ListResourcePoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListResourcePoliciesPage, ListResourcePoliciesPagedResponse>(){

                public ListResourcePoliciesPagedResponse apply(ListResourcePoliciesPage input) {
                    return new ListResourcePoliciesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListResourcePoliciesPagedResponse(ListResourcePoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListResourcePoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListResourcePoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePoliciesScopedList, AggregatedListResourcePoliciesPage, AggregatedListResourcePoliciesFixedSizeCollection> {
        private AggregatedListResourcePoliciesFixedSizeCollection(List<AggregatedListResourcePoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListResourcePoliciesFixedSizeCollection createEmptyCollection() {
            return new AggregatedListResourcePoliciesFixedSizeCollection(null, 0);
        }

        protected AggregatedListResourcePoliciesFixedSizeCollection createCollection(List<AggregatedListResourcePoliciesPage> pages, int collectionSize) {
            return new AggregatedListResourcePoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListResourcePoliciesPage
    extends AbstractPage<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePoliciesScopedList, AggregatedListResourcePoliciesPage> {
        private AggregatedListResourcePoliciesPage(PageContext<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePoliciesScopedList> context, ResourcePolicyAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListResourcePoliciesPage createEmptyPage() {
            return new AggregatedListResourcePoliciesPage(null, null);
        }

        protected AggregatedListResourcePoliciesPage createPage(PageContext<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePoliciesScopedList> context, ResourcePolicyAggregatedList response) {
            return new AggregatedListResourcePoliciesPage(context, response);
        }

        public ApiFuture<AggregatedListResourcePoliciesPage> createPageAsync(PageContext<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePoliciesScopedList> context, ApiFuture<ResourcePolicyAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListResourcePoliciesPagedResponse
    extends AbstractPagedListResponse<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePoliciesScopedList, AggregatedListResourcePoliciesPage, AggregatedListResourcePoliciesFixedSizeCollection> {
        public static ApiFuture<AggregatedListResourcePoliciesPagedResponse> createAsync(PageContext<AggregatedListResourcePoliciesHttpRequest, ResourcePolicyAggregatedList, ResourcePoliciesScopedList> context, ApiFuture<ResourcePolicyAggregatedList> futureResponse) {
            ApiFuture<AggregatedListResourcePoliciesPage> futurePage = AggregatedListResourcePoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListResourcePoliciesPage, AggregatedListResourcePoliciesPagedResponse>(){

                public AggregatedListResourcePoliciesPagedResponse apply(AggregatedListResourcePoliciesPage input) {
                    return new AggregatedListResourcePoliciesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListResourcePoliciesPagedResponse(AggregatedListResourcePoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListResourcePoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

