/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeletePublicAdvertisedPrefixeRequest;
import com.google.cloud.compute.v1.GetPublicAdvertisedPrefixeRequest;
import com.google.cloud.compute.v1.InsertPublicAdvertisedPrefixeRequest;
import com.google.cloud.compute.v1.ListPublicAdvertisedPrefixesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchPublicAdvertisedPrefixeRequest;
import com.google.cloud.compute.v1.PublicAdvertisedPrefix;
import com.google.cloud.compute.v1.PublicAdvertisedPrefixList;
import com.google.cloud.compute.v1.PublicAdvertisedPrefixesSettings;
import com.google.cloud.compute.v1.stub.PublicAdvertisedPrefixesStub;
import com.google.cloud.compute.v1.stub.PublicAdvertisedPrefixesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PublicAdvertisedPrefixesClient
implements BackgroundResource {
    private final PublicAdvertisedPrefixesSettings settings;
    private final PublicAdvertisedPrefixesStub stub;

    public static final PublicAdvertisedPrefixesClient create() throws IOException {
        return PublicAdvertisedPrefixesClient.create(PublicAdvertisedPrefixesSettings.newBuilder().build());
    }

    public static final PublicAdvertisedPrefixesClient create(PublicAdvertisedPrefixesSettings settings) throws IOException {
        return new PublicAdvertisedPrefixesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final PublicAdvertisedPrefixesClient create(PublicAdvertisedPrefixesStub stub) {
        return new PublicAdvertisedPrefixesClient(stub);
    }

    protected PublicAdvertisedPrefixesClient(PublicAdvertisedPrefixesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PublicAdvertisedPrefixesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected PublicAdvertisedPrefixesClient(PublicAdvertisedPrefixesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PublicAdvertisedPrefixesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PublicAdvertisedPrefixesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String publicAdvertisedPrefix) {
        DeletePublicAdvertisedPrefixeRequest request = DeletePublicAdvertisedPrefixeRequest.newBuilder().setProject(project).setPublicAdvertisedPrefix(publicAdvertisedPrefix).build();
        return this.delete(request);
    }

    public final Operation delete(DeletePublicAdvertisedPrefixeRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePublicAdvertisedPrefixeRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final PublicAdvertisedPrefix get(String project, String publicAdvertisedPrefix) {
        GetPublicAdvertisedPrefixeRequest request = GetPublicAdvertisedPrefixeRequest.newBuilder().setProject(project).setPublicAdvertisedPrefix(publicAdvertisedPrefix).build();
        return this.get(request);
    }

    public final PublicAdvertisedPrefix get(GetPublicAdvertisedPrefixeRequest request) {
        return (PublicAdvertisedPrefix)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetPublicAdvertisedPrefixeRequest, PublicAdvertisedPrefix> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, PublicAdvertisedPrefix publicAdvertisedPrefixResource) {
        InsertPublicAdvertisedPrefixeRequest request = InsertPublicAdvertisedPrefixeRequest.newBuilder().setProject(project).setPublicAdvertisedPrefixResource(publicAdvertisedPrefixResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertPublicAdvertisedPrefixeRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertPublicAdvertisedPrefixeRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListPublicAdvertisedPrefixesRequest request = ListPublicAdvertisedPrefixesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListPublicAdvertisedPrefixesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPublicAdvertisedPrefixesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListPublicAdvertisedPrefixesRequest, PublicAdvertisedPrefixList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String publicAdvertisedPrefix, PublicAdvertisedPrefix publicAdvertisedPrefixResource) {
        PatchPublicAdvertisedPrefixeRequest request = PatchPublicAdvertisedPrefixeRequest.newBuilder().setProject(project).setPublicAdvertisedPrefix(publicAdvertisedPrefix).setPublicAdvertisedPrefixResource(publicAdvertisedPrefixResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchPublicAdvertisedPrefixeRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchPublicAdvertisedPrefixeRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPublicAdvertisedPrefixesRequest, PublicAdvertisedPrefixList, PublicAdvertisedPrefix, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListPublicAdvertisedPrefixesRequest, PublicAdvertisedPrefixList, PublicAdvertisedPrefix, ListPage> {
        private ListPage(PageContext<ListPublicAdvertisedPrefixesRequest, PublicAdvertisedPrefixList, PublicAdvertisedPrefix> context, PublicAdvertisedPrefixList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListPublicAdvertisedPrefixesRequest, PublicAdvertisedPrefixList, PublicAdvertisedPrefix> context, PublicAdvertisedPrefixList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListPublicAdvertisedPrefixesRequest, PublicAdvertisedPrefixList, PublicAdvertisedPrefix> context, ApiFuture<PublicAdvertisedPrefixList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListPublicAdvertisedPrefixesRequest, PublicAdvertisedPrefixList, PublicAdvertisedPrefix, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListPublicAdvertisedPrefixesRequest, PublicAdvertisedPrefixList, PublicAdvertisedPrefix> context, ApiFuture<PublicAdvertisedPrefixList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

