/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionOperationRequest;
import com.google.cloud.compute.v1.DeleteRegionOperationResponse;
import com.google.cloud.compute.v1.GetRegionOperationRequest;
import com.google.cloud.compute.v1.ListRegionOperationsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.RegionOperationsSettings;
import com.google.cloud.compute.v1.WaitRegionOperationRequest;
import com.google.cloud.compute.v1.stub.RegionOperationsStub;
import com.google.cloud.compute.v1.stub.RegionOperationsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionOperationsClient
implements BackgroundResource {
    private final RegionOperationsSettings settings;
    private final RegionOperationsStub stub;

    public static final RegionOperationsClient create() throws IOException {
        return RegionOperationsClient.create(RegionOperationsSettings.newBuilder().build());
    }

    public static final RegionOperationsClient create(RegionOperationsSettings settings) throws IOException {
        return new RegionOperationsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionOperationsClient create(RegionOperationsStub stub) {
        return new RegionOperationsClient(stub);
    }

    protected RegionOperationsClient(RegionOperationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionOperationsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionOperationsClient(RegionOperationsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionOperationsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionOperationsStub getStub() {
        return this.stub;
    }

    public final DeleteRegionOperationResponse delete(String project, String region, String operation) {
        DeleteRegionOperationRequest request = DeleteRegionOperationRequest.newBuilder().setProject(project).setRegion(region).setOperation(operation).build();
        return this.delete(request);
    }

    public final DeleteRegionOperationResponse delete(DeleteRegionOperationRequest request) {
        return (DeleteRegionOperationResponse)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRegionOperationRequest, DeleteRegionOperationResponse> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Operation get(String project, String region, String operation) {
        GetRegionOperationRequest request = GetRegionOperationRequest.newBuilder().setProject(project).setRegion(region).setOperation(operation).build();
        return this.get(request);
    }

    public final Operation get(GetRegionOperationRequest request) {
        return (Operation)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionOperationRequest, Operation> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionOperationsRequest request = ListRegionOperationsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionOperationsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionOperationsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionOperationsRequest, OperationList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation wait(String project, String region, String operation) {
        WaitRegionOperationRequest request = WaitRegionOperationRequest.newBuilder().setProject(project).setRegion(region).setOperation(operation).build();
        return this.wait(request);
    }

    public final Operation wait(WaitRegionOperationRequest request) {
        return (Operation)this.waitCallable().call((Object)request);
    }

    public final UnaryCallable<WaitRegionOperationRequest, Operation> waitCallable() {
        return this.stub.waitCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionOperationsRequest, OperationList, Operation, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionOperationsRequest, OperationList, Operation, ListPage> {
        private ListPage(PageContext<ListRegionOperationsRequest, OperationList, Operation> context, OperationList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionOperationsRequest, OperationList, Operation> context, OperationList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionOperationsRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionOperationsRequest, OperationList, Operation, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionOperationsRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

