/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetInstancesRequest;
import com.google.cloud.compute.v1.DeleteTargetInstanceRequest;
import com.google.cloud.compute.v1.GetTargetInstanceRequest;
import com.google.cloud.compute.v1.InsertTargetInstanceRequest;
import com.google.cloud.compute.v1.ListTargetInstancesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SecurityPolicyReference;
import com.google.cloud.compute.v1.SetSecurityPolicyTargetInstanceRequest;
import com.google.cloud.compute.v1.TargetInstance;
import com.google.cloud.compute.v1.TargetInstanceAggregatedList;
import com.google.cloud.compute.v1.TargetInstanceList;
import com.google.cloud.compute.v1.TargetInstancesScopedList;
import com.google.cloud.compute.v1.TargetInstancesSettings;
import com.google.cloud.compute.v1.stub.TargetInstancesStub;
import com.google.cloud.compute.v1.stub.TargetInstancesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TargetInstancesClient
implements BackgroundResource {
    private final TargetInstancesSettings settings;
    private final TargetInstancesStub stub;

    public static final TargetInstancesClient create() throws IOException {
        return TargetInstancesClient.create(TargetInstancesSettings.newBuilder().build());
    }

    public static final TargetInstancesClient create(TargetInstancesSettings settings) throws IOException {
        return new TargetInstancesClient(settings);
    }

    public static final TargetInstancesClient create(TargetInstancesStub stub) {
        return new TargetInstancesClient(stub);
    }

    protected TargetInstancesClient(TargetInstancesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetInstancesStubSettings)settings.getStubSettings()).createStub();
    }

    protected TargetInstancesClient(TargetInstancesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetInstancesSettings getSettings() {
        return this.settings;
    }

    public TargetInstancesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListTargetInstancesRequest request = AggregatedListTargetInstancesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListTargetInstancesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListTargetInstancesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String zone, String targetInstance) {
        DeleteTargetInstanceRequest request = DeleteTargetInstanceRequest.newBuilder().setProject(project).setZone(zone).setTargetInstance(targetInstance).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteTargetInstanceRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTargetInstanceRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteTargetInstanceRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetInstance get(String project, String zone, String targetInstance) {
        GetTargetInstanceRequest request = GetTargetInstanceRequest.newBuilder().setProject(project).setZone(zone).setTargetInstance(targetInstance).build();
        return this.get(request);
    }

    public final TargetInstance get(GetTargetInstanceRequest request) {
        return (TargetInstance)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetInstanceRequest, TargetInstance> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String zone, TargetInstance targetInstanceResource) {
        InsertTargetInstanceRequest request = InsertTargetInstanceRequest.newBuilder().setProject(project).setZone(zone).setTargetInstanceResource(targetInstanceResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertTargetInstanceRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertTargetInstanceRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertTargetInstanceRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListTargetInstancesRequest request = ListTargetInstancesRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListTargetInstancesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetInstancesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListTargetInstancesRequest, TargetInstanceList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> setSecurityPolicyAsync(String project, String zone, String targetInstance, SecurityPolicyReference securityPolicyReferenceResource) {
        SetSecurityPolicyTargetInstanceRequest request = SetSecurityPolicyTargetInstanceRequest.newBuilder().setProject(project).setZone(zone).setTargetInstance(targetInstance).setSecurityPolicyReferenceResource(securityPolicyReferenceResource).build();
        return this.setSecurityPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setSecurityPolicyAsync(SetSecurityPolicyTargetInstanceRequest request) {
        return this.setSecurityPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetSecurityPolicyTargetInstanceRequest, Operation, Operation> setSecurityPolicyOperationCallable() {
        return this.stub.setSecurityPolicyOperationCallable();
    }

    public final UnaryCallable<SetSecurityPolicyTargetInstanceRequest, Operation> setSecurityPolicyCallable() {
        return this.stub.setSecurityPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetInstancesRequest, TargetInstanceList, TargetInstance, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListTargetInstancesRequest, TargetInstanceList, TargetInstance, ListPage> {
        private ListPage(PageContext<ListTargetInstancesRequest, TargetInstanceList, TargetInstance> context, TargetInstanceList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListTargetInstancesRequest, TargetInstanceList, TargetInstance> context, TargetInstanceList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListTargetInstancesRequest, TargetInstanceList, TargetInstance> context, ApiFuture<TargetInstanceList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListTargetInstancesRequest, TargetInstanceList, TargetInstance, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListTargetInstancesRequest, TargetInstanceList, TargetInstance> context, ApiFuture<TargetInstanceList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, Map.Entry<String, TargetInstancesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, Map.Entry<String, TargetInstancesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, Map.Entry<String, TargetInstancesScopedList>> context, TargetInstanceAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, Map.Entry<String, TargetInstancesScopedList>> context, TargetInstanceAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, Map.Entry<String, TargetInstancesScopedList>> context, ApiFuture<TargetInstanceAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, Map.Entry<String, TargetInstancesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListTargetInstancesRequest, TargetInstanceAggregatedList, Map.Entry<String, TargetInstancesScopedList>> context, ApiFuture<TargetInstanceAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

