/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetInterconnectRemoteLocationRequest;
import com.google.cloud.compute.v1.InterconnectRemoteLocation;
import com.google.cloud.compute.v1.InterconnectRemoteLocationList;
import com.google.cloud.compute.v1.InterconnectRemoteLocationsClient;
import com.google.cloud.compute.v1.ListInterconnectRemoteLocationsRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInterconnectRemoteLocationsStub;
import com.google.cloud.compute.v1.stub.InterconnectRemoteLocationsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class InterconnectRemoteLocationsStubSettings
extends StubSettings<InterconnectRemoteLocationsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetInterconnectRemoteLocationRequest, InterconnectRemoteLocation> getSettings;
    private final PagedCallSettings<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocationsClient.ListPagedResponse> listSettings;
    private static final PagedListDescriptor<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocation> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocation>(){

        public String emptyToken() {
            return "";
        }

        public ListInterconnectRemoteLocationsRequest injectToken(ListInterconnectRemoteLocationsRequest payload, String token) {
            return ListInterconnectRemoteLocationsRequest.newBuilder((ListInterconnectRemoteLocationsRequest)payload).setPageToken(token).build();
        }

        public ListInterconnectRemoteLocationsRequest injectPageSize(ListInterconnectRemoteLocationsRequest payload, int pageSize) {
            return ListInterconnectRemoteLocationsRequest.newBuilder((ListInterconnectRemoteLocationsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInterconnectRemoteLocationsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InterconnectRemoteLocationList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InterconnectRemoteLocation> extractResources(InterconnectRemoteLocationList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocationsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocationsClient.ListPagedResponse>(){

        public ApiFuture<InterconnectRemoteLocationsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList> callable, ListInterconnectRemoteLocationsRequest request, ApiCallContext context, ApiFuture<InterconnectRemoteLocationList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InterconnectRemoteLocationsClient.ListPagedResponse.createAsync((PageContext<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocation>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetInterconnectRemoteLocationRequest, InterconnectRemoteLocation> getSettings() {
        return this.getSettings;
    }

    public PagedCallSettings<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocationsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public InterconnectRemoteLocationsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInterconnectRemoteLocationsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return InterconnectRemoteLocationsStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InterconnectRemoteLocationsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InterconnectRemoteLocationsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InterconnectRemoteLocationsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSettings = settingsBuilder.getSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InterconnectRemoteLocationsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetInterconnectRemoteLocationRequest, InterconnectRemoteLocation> getSettings;
        private final PagedCallSettings.Builder<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocationsClient.ListPagedResponse> listSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSettings, this.listSettings);
            Builder.initDefaults(this);
        }

        protected Builder(InterconnectRemoteLocationsStubSettings settings) {
            super((StubSettings)settings);
            this.getSettings = settings.getSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSettings, this.listSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InterconnectRemoteLocationsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InterconnectRemoteLocationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InterconnectRemoteLocationsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(InterconnectRemoteLocationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetInterconnectRemoteLocationRequest, InterconnectRemoteLocation> getSettings() {
            return this.getSettings;
        }

        public PagedCallSettings.Builder<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocationsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return InterconnectRemoteLocationsStubSettings.getDefaultEndpoint();
        }

        public InterconnectRemoteLocationsStubSettings build() throws IOException {
            return new InterconnectRemoteLocationsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

