/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetRegionRequest;
import com.google.cloud.compute.v1.ListRegionsRequest;
import com.google.cloud.compute.v1.Region;
import com.google.cloud.compute.v1.RegionList;
import com.google.cloud.compute.v1.RegionsSettings;
import com.google.cloud.compute.v1.stub.RegionsStub;
import com.google.cloud.compute.v1.stub.RegionsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionsClient
implements BackgroundResource {
    private final RegionsSettings settings;
    private final RegionsStub stub;

    public static final RegionsClient create() throws IOException {
        return RegionsClient.create(RegionsSettings.newBuilder().build());
    }

    public static final RegionsClient create(RegionsSettings settings) throws IOException {
        return new RegionsClient(settings);
    }

    public static final RegionsClient create(RegionsStub stub) {
        return new RegionsClient(stub);
    }

    protected RegionsClient(RegionsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionsStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionsClient(RegionsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionsSettings getSettings() {
        return this.settings;
    }

    public RegionsStub getStub() {
        return this.stub;
    }

    public final Region get(String project, String region) {
        GetRegionRequest request = GetRegionRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.get(request);
    }

    public final Region get(GetRegionRequest request) {
        return (Region)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionRequest, Region> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project) {
        ListRegionsRequest request = ListRegionsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionsRequest, RegionList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionsRequest, RegionList, Region, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionsRequest, RegionList, Region, ListPage> {
        private ListPage(PageContext<ListRegionsRequest, RegionList, Region> context, RegionList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionsRequest, RegionList, Region> context, RegionList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionsRequest, RegionList, Region> context, ApiFuture<RegionList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionsRequest, RegionList, Region, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionsRequest, RegionList, Region> context, ApiFuture<RegionList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

