/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListSubnetworksRequest;
import com.google.cloud.compute.v1.DeleteSubnetworkRequest;
import com.google.cloud.compute.v1.ExpandIpCidrRangeSubnetworkRequest;
import com.google.cloud.compute.v1.GetIamPolicySubnetworkRequest;
import com.google.cloud.compute.v1.GetSubnetworkRequest;
import com.google.cloud.compute.v1.InsertSubnetworkRequest;
import com.google.cloud.compute.v1.ListSubnetworksRequest;
import com.google.cloud.compute.v1.ListUsableSubnetworksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchSubnetworkRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicySubnetworkRequest;
import com.google.cloud.compute.v1.SetPrivateIpGoogleAccessSubnetworkRequest;
import com.google.cloud.compute.v1.Subnetwork;
import com.google.cloud.compute.v1.SubnetworkAggregatedList;
import com.google.cloud.compute.v1.SubnetworkList;
import com.google.cloud.compute.v1.SubnetworksClient;
import com.google.cloud.compute.v1.SubnetworksScopedList;
import com.google.cloud.compute.v1.TestIamPermissionsSubnetworkRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UsableSubnetwork;
import com.google.cloud.compute.v1.UsableSubnetworksAggregatedList;
import com.google.cloud.compute.v1.stub.HttpJsonSubnetworksStub;
import com.google.cloud.compute.v1.stub.SubnetworksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class SubnetworksStubSettings
extends StubSettings<SubnetworksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, SubnetworksClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteSubnetworkRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteSubnetworkRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<ExpandIpCidrRangeSubnetworkRequest, Operation> expandIpCidrRangeSettings;
    private final OperationCallSettings<ExpandIpCidrRangeSubnetworkRequest, Operation, Operation> expandIpCidrRangeOperationSettings;
    private final UnaryCallSettings<GetSubnetworkRequest, Subnetwork> getSettings;
    private final UnaryCallSettings<GetIamPolicySubnetworkRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertSubnetworkRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertSubnetworkRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListSubnetworksRequest, SubnetworkList, SubnetworksClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, SubnetworksClient.ListUsablePagedResponse> listUsableSettings;
    private final UnaryCallSettings<PatchSubnetworkRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchSubnetworkRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<SetIamPolicySubnetworkRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<SetPrivateIpGoogleAccessSubnetworkRequest, Operation> setPrivateIpGoogleAccessSettings;
    private final OperationCallSettings<SetPrivateIpGoogleAccessSubnetworkRequest, Operation, Operation> setPrivateIpGoogleAccessOperationSettings;
    private final UnaryCallSettings<TestIamPermissionsSubnetworkRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, Map.Entry<String, SubnetworksScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, Map.Entry<String, SubnetworksScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListSubnetworksRequest injectToken(AggregatedListSubnetworksRequest payload, String token) {
            return AggregatedListSubnetworksRequest.newBuilder((AggregatedListSubnetworksRequest)payload).setPageToken(token).build();
        }

        public AggregatedListSubnetworksRequest injectPageSize(AggregatedListSubnetworksRequest payload, int pageSize) {
            return AggregatedListSubnetworksRequest.newBuilder((AggregatedListSubnetworksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListSubnetworksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SubnetworkAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, SubnetworksScopedList>> extractResources(SubnetworkAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListSubnetworksRequest, SubnetworkList, Subnetwork> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListSubnetworksRequest, SubnetworkList, Subnetwork>(){

        public String emptyToken() {
            return "";
        }

        public ListSubnetworksRequest injectToken(ListSubnetworksRequest payload, String token) {
            return ListSubnetworksRequest.newBuilder((ListSubnetworksRequest)payload).setPageToken(token).build();
        }

        public ListSubnetworksRequest injectPageSize(ListSubnetworksRequest payload, int pageSize) {
            return ListSubnetworksRequest.newBuilder((ListSubnetworksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListSubnetworksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SubnetworkList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Subnetwork> extractResources(SubnetworkList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, UsableSubnetwork> LIST_USABLE_PAGE_STR_DESC = new PagedListDescriptor<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, UsableSubnetwork>(){

        public String emptyToken() {
            return "";
        }

        public ListUsableSubnetworksRequest injectToken(ListUsableSubnetworksRequest payload, String token) {
            return ListUsableSubnetworksRequest.newBuilder((ListUsableSubnetworksRequest)payload).setPageToken(token).build();
        }

        public ListUsableSubnetworksRequest injectPageSize(ListUsableSubnetworksRequest payload, int pageSize) {
            return ListUsableSubnetworksRequest.newBuilder((ListUsableSubnetworksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListUsableSubnetworksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(UsableSubnetworksAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UsableSubnetwork> extractResources(UsableSubnetworksAggregatedList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, SubnetworksClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, SubnetworksClient.AggregatedListPagedResponse>(){

        public ApiFuture<SubnetworksClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListSubnetworksRequest, SubnetworkAggregatedList> callable, AggregatedListSubnetworksRequest request, ApiCallContext context, ApiFuture<SubnetworkAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SubnetworksClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, Map.Entry<String, SubnetworksScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSubnetworksRequest, SubnetworkList, SubnetworksClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListSubnetworksRequest, SubnetworkList, SubnetworksClient.ListPagedResponse>(){

        public ApiFuture<SubnetworksClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListSubnetworksRequest, SubnetworkList> callable, ListSubnetworksRequest request, ApiCallContext context, ApiFuture<SubnetworkList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SubnetworksClient.ListPagedResponse.createAsync((PageContext<ListSubnetworksRequest, SubnetworkList, Subnetwork>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, SubnetworksClient.ListUsablePagedResponse> LIST_USABLE_PAGE_STR_FACT = new PagedListResponseFactory<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, SubnetworksClient.ListUsablePagedResponse>(){

        public ApiFuture<SubnetworksClient.ListUsablePagedResponse> getFuturePagedResponse(UnaryCallable<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList> callable, ListUsableSubnetworksRequest request, ApiCallContext context, ApiFuture<UsableSubnetworksAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USABLE_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SubnetworksClient.ListUsablePagedResponse.createAsync((PageContext<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, UsableSubnetwork>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, SubnetworksClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteSubnetworkRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteSubnetworkRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<ExpandIpCidrRangeSubnetworkRequest, Operation> expandIpCidrRangeSettings() {
        return this.expandIpCidrRangeSettings;
    }

    public OperationCallSettings<ExpandIpCidrRangeSubnetworkRequest, Operation, Operation> expandIpCidrRangeOperationSettings() {
        return this.expandIpCidrRangeOperationSettings;
    }

    public UnaryCallSettings<GetSubnetworkRequest, Subnetwork> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicySubnetworkRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertSubnetworkRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertSubnetworkRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListSubnetworksRequest, SubnetworkList, SubnetworksClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, SubnetworksClient.ListUsablePagedResponse> listUsableSettings() {
        return this.listUsableSettings;
    }

    public UnaryCallSettings<PatchSubnetworkRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchSubnetworkRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicySubnetworkRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<SetPrivateIpGoogleAccessSubnetworkRequest, Operation> setPrivateIpGoogleAccessSettings() {
        return this.setPrivateIpGoogleAccessSettings;
    }

    public OperationCallSettings<SetPrivateIpGoogleAccessSubnetworkRequest, Operation, Operation> setPrivateIpGoogleAccessOperationSettings() {
        return this.setPrivateIpGoogleAccessOperationSettings;
    }

    public UnaryCallSettings<TestIamPermissionsSubnetworkRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public SubnetworksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSubnetworksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return SubnetworksStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SubnetworksStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SubnetworksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SubnetworksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.expandIpCidrRangeSettings = settingsBuilder.expandIpCidrRangeSettings().build();
        this.expandIpCidrRangeOperationSettings = settingsBuilder.expandIpCidrRangeOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listUsableSettings = settingsBuilder.listUsableSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.setPrivateIpGoogleAccessSettings = settingsBuilder.setPrivateIpGoogleAccessSettings().build();
        this.setPrivateIpGoogleAccessOperationSettings = settingsBuilder.setPrivateIpGoogleAccessOperationSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SubnetworksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, SubnetworksClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteSubnetworkRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteSubnetworkRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<ExpandIpCidrRangeSubnetworkRequest, Operation> expandIpCidrRangeSettings;
        private final OperationCallSettings.Builder<ExpandIpCidrRangeSubnetworkRequest, Operation, Operation> expandIpCidrRangeOperationSettings;
        private final UnaryCallSettings.Builder<GetSubnetworkRequest, Subnetwork> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicySubnetworkRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertSubnetworkRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertSubnetworkRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListSubnetworksRequest, SubnetworkList, SubnetworksClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, SubnetworksClient.ListUsablePagedResponse> listUsableSettings;
        private final UnaryCallSettings.Builder<PatchSubnetworkRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchSubnetworkRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicySubnetworkRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<SetPrivateIpGoogleAccessSubnetworkRequest, Operation> setPrivateIpGoogleAccessSettings;
        private final OperationCallSettings.Builder<SetPrivateIpGoogleAccessSubnetworkRequest, Operation, Operation> setPrivateIpGoogleAccessOperationSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsSubnetworkRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.expandIpCidrRangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.expandIpCidrRangeOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listUsableSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USABLE_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setPrivateIpGoogleAccessSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setPrivateIpGoogleAccessOperationSettings = OperationCallSettings.newBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.expandIpCidrRangeSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.listUsableSettings, this.patchSettings, this.setIamPolicySettings, this.setPrivateIpGoogleAccessSettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(SubnetworksStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.expandIpCidrRangeSettings = settings.expandIpCidrRangeSettings.toBuilder();
            this.expandIpCidrRangeOperationSettings = settings.expandIpCidrRangeOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listUsableSettings = settings.listUsableSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.setPrivateIpGoogleAccessSettings = settings.setPrivateIpGoogleAccessSettings.toBuilder();
            this.setPrivateIpGoogleAccessOperationSettings = settings.setPrivateIpGoogleAccessOperationSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.expandIpCidrRangeSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.listUsableSettings, this.patchSettings, this.setIamPolicySettings, this.setPrivateIpGoogleAccessSettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SubnetworksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SubnetworksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SubnetworksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SubnetworksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.expandIpCidrRangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listUsableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setPrivateIpGoogleAccessSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.expandIpCidrRangeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setPrivateIpGoogleAccessOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListSubnetworksRequest, SubnetworkAggregatedList, SubnetworksClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteSubnetworkRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteSubnetworkRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<ExpandIpCidrRangeSubnetworkRequest, Operation> expandIpCidrRangeSettings() {
            return this.expandIpCidrRangeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExpandIpCidrRangeSubnetworkRequest, Operation, Operation> expandIpCidrRangeOperationSettings() {
            return this.expandIpCidrRangeOperationSettings;
        }

        public UnaryCallSettings.Builder<GetSubnetworkRequest, Subnetwork> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicySubnetworkRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertSubnetworkRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InsertSubnetworkRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListSubnetworksRequest, SubnetworkList, SubnetworksClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListUsableSubnetworksRequest, UsableSubnetworksAggregatedList, SubnetworksClient.ListUsablePagedResponse> listUsableSettings() {
            return this.listUsableSettings;
        }

        public UnaryCallSettings.Builder<PatchSubnetworkRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<PatchSubnetworkRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicySubnetworkRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetPrivateIpGoogleAccessSubnetworkRequest, Operation> setPrivateIpGoogleAccessSettings() {
            return this.setPrivateIpGoogleAccessSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetPrivateIpGoogleAccessSubnetworkRequest, Operation, Operation> setPrivateIpGoogleAccessOperationSettings() {
            return this.setPrivateIpGoogleAccessOperationSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsSubnetworkRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return SubnetworksStubSettings.getDefaultEndpoint();
        }

        public SubnetworksStubSettings build() throws IOException {
            return new SubnetworksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

