/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddSignedUrlKeyBackendServiceRequest;
import com.google.cloud.compute.v1.AggregatedListBackendServicesRequest;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.BackendServiceAggregatedList;
import com.google.cloud.compute.v1.BackendServiceGroupHealth;
import com.google.cloud.compute.v1.BackendServiceList;
import com.google.cloud.compute.v1.BackendServiceListUsable;
import com.google.cloud.compute.v1.BackendServicesClient;
import com.google.cloud.compute.v1.BackendServicesScopedList;
import com.google.cloud.compute.v1.DeleteBackendServiceRequest;
import com.google.cloud.compute.v1.DeleteSignedUrlKeyBackendServiceRequest;
import com.google.cloud.compute.v1.GetBackendServiceRequest;
import com.google.cloud.compute.v1.GetHealthBackendServiceRequest;
import com.google.cloud.compute.v1.GetIamPolicyBackendServiceRequest;
import com.google.cloud.compute.v1.InsertBackendServiceRequest;
import com.google.cloud.compute.v1.ListBackendServicesRequest;
import com.google.cloud.compute.v1.ListUsableBackendServicesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchBackendServiceRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetEdgeSecurityPolicyBackendServiceRequest;
import com.google.cloud.compute.v1.SetIamPolicyBackendServiceRequest;
import com.google.cloud.compute.v1.SetSecurityPolicyBackendServiceRequest;
import com.google.cloud.compute.v1.TestIamPermissionsBackendServiceRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateBackendServiceRequest;
import com.google.cloud.compute.v1.stub.BackendServicesStub;
import com.google.cloud.compute.v1.stub.HttpJsonBackendServicesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class BackendServicesStubSettings
extends StubSettings<BackendServicesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddSignedUrlKeyBackendServiceRequest, Operation> addSignedUrlKeySettings;
    private final OperationCallSettings<AddSignedUrlKeyBackendServiceRequest, Operation, Operation> addSignedUrlKeyOperationSettings;
    private final PagedCallSettings<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, BackendServicesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteBackendServiceRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteBackendServiceRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<DeleteSignedUrlKeyBackendServiceRequest, Operation> deleteSignedUrlKeySettings;
    private final OperationCallSettings<DeleteSignedUrlKeyBackendServiceRequest, Operation, Operation> deleteSignedUrlKeyOperationSettings;
    private final UnaryCallSettings<GetBackendServiceRequest, BackendService> getSettings;
    private final UnaryCallSettings<GetHealthBackendServiceRequest, BackendServiceGroupHealth> getHealthSettings;
    private final UnaryCallSettings<GetIamPolicyBackendServiceRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertBackendServiceRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertBackendServiceRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListBackendServicesRequest, BackendServiceList, BackendServicesClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendServicesClient.ListUsablePagedResponse> listUsableSettings;
    private final UnaryCallSettings<PatchBackendServiceRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchBackendServiceRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<SetEdgeSecurityPolicyBackendServiceRequest, Operation> setEdgeSecurityPolicySettings;
    private final OperationCallSettings<SetEdgeSecurityPolicyBackendServiceRequest, Operation, Operation> setEdgeSecurityPolicyOperationSettings;
    private final UnaryCallSettings<SetIamPolicyBackendServiceRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<SetSecurityPolicyBackendServiceRequest, Operation> setSecurityPolicySettings;
    private final OperationCallSettings<SetSecurityPolicyBackendServiceRequest, Operation, Operation> setSecurityPolicyOperationSettings;
    private final UnaryCallSettings<TestIamPermissionsBackendServiceRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<UpdateBackendServiceRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateBackendServiceRequest, Operation, Operation> updateOperationSettings;
    private static final PagedListDescriptor<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListBackendServicesRequest injectToken(AggregatedListBackendServicesRequest payload, String token) {
            return AggregatedListBackendServicesRequest.newBuilder((AggregatedListBackendServicesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListBackendServicesRequest injectPageSize(AggregatedListBackendServicesRequest payload, int pageSize) {
            return AggregatedListBackendServicesRequest.newBuilder((AggregatedListBackendServicesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListBackendServicesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(BackendServiceAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, BackendServicesScopedList>> extractResources(BackendServiceAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListBackendServicesRequest, BackendServiceList, BackendService> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListBackendServicesRequest, BackendServiceList, BackendService>(){

        public String emptyToken() {
            return "";
        }

        public ListBackendServicesRequest injectToken(ListBackendServicesRequest payload, String token) {
            return ListBackendServicesRequest.newBuilder((ListBackendServicesRequest)payload).setPageToken(token).build();
        }

        public ListBackendServicesRequest injectPageSize(ListBackendServicesRequest payload, int pageSize) {
            return ListBackendServicesRequest.newBuilder((ListBackendServicesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListBackendServicesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(BackendServiceList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackendService> extractResources(BackendServiceList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendService> LIST_USABLE_PAGE_STR_DESC = new PagedListDescriptor<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendService>(){

        public String emptyToken() {
            return "";
        }

        public ListUsableBackendServicesRequest injectToken(ListUsableBackendServicesRequest payload, String token) {
            return ListUsableBackendServicesRequest.newBuilder((ListUsableBackendServicesRequest)payload).setPageToken(token).build();
        }

        public ListUsableBackendServicesRequest injectPageSize(ListUsableBackendServicesRequest payload, int pageSize) {
            return ListUsableBackendServicesRequest.newBuilder((ListUsableBackendServicesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListUsableBackendServicesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(BackendServiceListUsable payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackendService> extractResources(BackendServiceListUsable payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, BackendServicesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, BackendServicesClient.AggregatedListPagedResponse>(){

        public ApiFuture<BackendServicesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListBackendServicesRequest, BackendServiceAggregatedList> callable, AggregatedListBackendServicesRequest request, ApiCallContext context, ApiFuture<BackendServiceAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackendServicesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackendServicesRequest, BackendServiceList, BackendServicesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListBackendServicesRequest, BackendServiceList, BackendServicesClient.ListPagedResponse>(){

        public ApiFuture<BackendServicesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackendServicesRequest, BackendServiceList> callable, ListBackendServicesRequest request, ApiCallContext context, ApiFuture<BackendServiceList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackendServicesClient.ListPagedResponse.createAsync((PageContext<ListBackendServicesRequest, BackendServiceList, BackendService>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendServicesClient.ListUsablePagedResponse> LIST_USABLE_PAGE_STR_FACT = new PagedListResponseFactory<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendServicesClient.ListUsablePagedResponse>(){

        public ApiFuture<BackendServicesClient.ListUsablePagedResponse> getFuturePagedResponse(UnaryCallable<ListUsableBackendServicesRequest, BackendServiceListUsable> callable, ListUsableBackendServicesRequest request, ApiCallContext context, ApiFuture<BackendServiceListUsable> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USABLE_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackendServicesClient.ListUsablePagedResponse.createAsync((PageContext<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendService>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddSignedUrlKeyBackendServiceRequest, Operation> addSignedUrlKeySettings() {
        return this.addSignedUrlKeySettings;
    }

    public OperationCallSettings<AddSignedUrlKeyBackendServiceRequest, Operation, Operation> addSignedUrlKeyOperationSettings() {
        return this.addSignedUrlKeyOperationSettings;
    }

    public PagedCallSettings<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, BackendServicesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteBackendServiceRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteBackendServiceRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<DeleteSignedUrlKeyBackendServiceRequest, Operation> deleteSignedUrlKeySettings() {
        return this.deleteSignedUrlKeySettings;
    }

    public OperationCallSettings<DeleteSignedUrlKeyBackendServiceRequest, Operation, Operation> deleteSignedUrlKeyOperationSettings() {
        return this.deleteSignedUrlKeyOperationSettings;
    }

    public UnaryCallSettings<GetBackendServiceRequest, BackendService> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetHealthBackendServiceRequest, BackendServiceGroupHealth> getHealthSettings() {
        return this.getHealthSettings;
    }

    public UnaryCallSettings<GetIamPolicyBackendServiceRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertBackendServiceRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertBackendServiceRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListBackendServicesRequest, BackendServiceList, BackendServicesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendServicesClient.ListUsablePagedResponse> listUsableSettings() {
        return this.listUsableSettings;
    }

    public UnaryCallSettings<PatchBackendServiceRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchBackendServiceRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<SetEdgeSecurityPolicyBackendServiceRequest, Operation> setEdgeSecurityPolicySettings() {
        return this.setEdgeSecurityPolicySettings;
    }

    public OperationCallSettings<SetEdgeSecurityPolicyBackendServiceRequest, Operation, Operation> setEdgeSecurityPolicyOperationSettings() {
        return this.setEdgeSecurityPolicyOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyBackendServiceRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<SetSecurityPolicyBackendServiceRequest, Operation> setSecurityPolicySettings() {
        return this.setSecurityPolicySettings;
    }

    public OperationCallSettings<SetSecurityPolicyBackendServiceRequest, Operation, Operation> setSecurityPolicyOperationSettings() {
        return this.setSecurityPolicyOperationSettings;
    }

    public UnaryCallSettings<TestIamPermissionsBackendServiceRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<UpdateBackendServiceRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateBackendServiceRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public BackendServicesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBackendServicesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BackendServicesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BackendServicesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BackendServicesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addSignedUrlKeySettings = settingsBuilder.addSignedUrlKeySettings().build();
        this.addSignedUrlKeyOperationSettings = settingsBuilder.addSignedUrlKeyOperationSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.deleteSignedUrlKeySettings = settingsBuilder.deleteSignedUrlKeySettings().build();
        this.deleteSignedUrlKeyOperationSettings = settingsBuilder.deleteSignedUrlKeyOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getHealthSettings = settingsBuilder.getHealthSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listUsableSettings = settingsBuilder.listUsableSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.setEdgeSecurityPolicySettings = settingsBuilder.setEdgeSecurityPolicySettings().build();
        this.setEdgeSecurityPolicyOperationSettings = settingsBuilder.setEdgeSecurityPolicyOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.setSecurityPolicySettings = settingsBuilder.setSecurityPolicySettings().build();
        this.setSecurityPolicyOperationSettings = settingsBuilder.setSecurityPolicyOperationSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BackendServicesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddSignedUrlKeyBackendServiceRequest, Operation> addSignedUrlKeySettings;
        private final OperationCallSettings.Builder<AddSignedUrlKeyBackendServiceRequest, Operation, Operation> addSignedUrlKeyOperationSettings;
        private final PagedCallSettings.Builder<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, BackendServicesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteBackendServiceRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteBackendServiceRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSignedUrlKeyBackendServiceRequest, Operation> deleteSignedUrlKeySettings;
        private final OperationCallSettings.Builder<DeleteSignedUrlKeyBackendServiceRequest, Operation, Operation> deleteSignedUrlKeyOperationSettings;
        private final UnaryCallSettings.Builder<GetBackendServiceRequest, BackendService> getSettings;
        private final UnaryCallSettings.Builder<GetHealthBackendServiceRequest, BackendServiceGroupHealth> getHealthSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyBackendServiceRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertBackendServiceRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertBackendServiceRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListBackendServicesRequest, BackendServiceList, BackendServicesClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendServicesClient.ListUsablePagedResponse> listUsableSettings;
        private final UnaryCallSettings.Builder<PatchBackendServiceRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchBackendServiceRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<SetEdgeSecurityPolicyBackendServiceRequest, Operation> setEdgeSecurityPolicySettings;
        private final OperationCallSettings.Builder<SetEdgeSecurityPolicyBackendServiceRequest, Operation, Operation> setEdgeSecurityPolicyOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyBackendServiceRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<SetSecurityPolicyBackendServiceRequest, Operation> setSecurityPolicySettings;
        private final OperationCallSettings.Builder<SetSecurityPolicyBackendServiceRequest, Operation, Operation> setSecurityPolicyOperationSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsBackendServiceRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<UpdateBackendServiceRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateBackendServiceRequest, Operation, Operation> updateOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addSignedUrlKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addSignedUrlKeyOperationSettings = OperationCallSettings.newBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSignedUrlKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSignedUrlKeyOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHealthSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listUsableSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USABLE_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.setEdgeSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setEdgeSecurityPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSecurityPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addSignedUrlKeySettings, this.aggregatedListSettings, this.deleteSettings, this.deleteSignedUrlKeySettings, this.getSettings, this.getHealthSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.listUsableSettings, this.patchSettings, this.setEdgeSecurityPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.setSecurityPolicySettings, this.testIamPermissionsSettings, this.updateSettings});
            Builder.initDefaults(this);
        }

        protected Builder(BackendServicesStubSettings settings) {
            super((StubSettings)settings);
            this.addSignedUrlKeySettings = settings.addSignedUrlKeySettings.toBuilder();
            this.addSignedUrlKeyOperationSettings = settings.addSignedUrlKeyOperationSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.deleteSignedUrlKeySettings = settings.deleteSignedUrlKeySettings.toBuilder();
            this.deleteSignedUrlKeyOperationSettings = settings.deleteSignedUrlKeyOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getHealthSettings = settings.getHealthSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listUsableSettings = settings.listUsableSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.setEdgeSecurityPolicySettings = settings.setEdgeSecurityPolicySettings.toBuilder();
            this.setEdgeSecurityPolicyOperationSettings = settings.setEdgeSecurityPolicyOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.setSecurityPolicySettings = settings.setSecurityPolicySettings.toBuilder();
            this.setSecurityPolicyOperationSettings = settings.setSecurityPolicyOperationSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addSignedUrlKeySettings, this.aggregatedListSettings, this.deleteSettings, this.deleteSignedUrlKeySettings, this.getSettings, this.getHealthSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.listUsableSettings, this.patchSettings, this.setEdgeSecurityPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.setSecurityPolicySettings, this.testIamPermissionsSettings, this.updateSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BackendServicesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BackendServicesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BackendServicesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BackendServicesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addSignedUrlKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSignedUrlKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getHealthSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listUsableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setEdgeSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addSignedUrlKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteSignedUrlKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setEdgeSecurityPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setSecurityPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddSignedUrlKeyBackendServiceRequest, Operation> addSignedUrlKeySettings() {
            return this.addSignedUrlKeySettings;
        }

        public OperationCallSettings.Builder<AddSignedUrlKeyBackendServiceRequest, Operation, Operation> addSignedUrlKeyOperationSettings() {
            return this.addSignedUrlKeyOperationSettings;
        }

        public PagedCallSettings.Builder<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, BackendServicesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackendServiceRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteBackendServiceRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSignedUrlKeyBackendServiceRequest, Operation> deleteSignedUrlKeySettings() {
            return this.deleteSignedUrlKeySettings;
        }

        public OperationCallSettings.Builder<DeleteSignedUrlKeyBackendServiceRequest, Operation, Operation> deleteSignedUrlKeyOperationSettings() {
            return this.deleteSignedUrlKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<GetBackendServiceRequest, BackendService> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetHealthBackendServiceRequest, BackendServiceGroupHealth> getHealthSettings() {
            return this.getHealthSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyBackendServiceRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertBackendServiceRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertBackendServiceRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListBackendServicesRequest, BackendServiceList, BackendServicesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListUsableBackendServicesRequest, BackendServiceListUsable, BackendServicesClient.ListUsablePagedResponse> listUsableSettings() {
            return this.listUsableSettings;
        }

        public UnaryCallSettings.Builder<PatchBackendServiceRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchBackendServiceRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<SetEdgeSecurityPolicyBackendServiceRequest, Operation> setEdgeSecurityPolicySettings() {
            return this.setEdgeSecurityPolicySettings;
        }

        public OperationCallSettings.Builder<SetEdgeSecurityPolicyBackendServiceRequest, Operation, Operation> setEdgeSecurityPolicyOperationSettings() {
            return this.setEdgeSecurityPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyBackendServiceRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetSecurityPolicyBackendServiceRequest, Operation> setSecurityPolicySettings() {
            return this.setSecurityPolicySettings;
        }

        public OperationCallSettings.Builder<SetSecurityPolicyBackendServiceRequest, Operation, Operation> setSecurityPolicyOperationSettings() {
            return this.setSecurityPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsBackendServiceRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackendServiceRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        public OperationCallSettings.Builder<UpdateBackendServiceRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public BackendServicesStubSettings build() throws IOException {
            return new BackendServicesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

