/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetNetworkProfileRequest;
import com.google.cloud.compute.v1.ListNetworkProfilesRequest;
import com.google.cloud.compute.v1.NetworkProfile;
import com.google.cloud.compute.v1.NetworkProfilesListResponse;
import com.google.cloud.compute.v1.NetworkProfilesSettings;
import com.google.cloud.compute.v1.stub.NetworkProfilesStub;
import com.google.cloud.compute.v1.stub.NetworkProfilesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NetworkProfilesClient
implements BackgroundResource {
    private final NetworkProfilesSettings settings;
    private final NetworkProfilesStub stub;

    public static final NetworkProfilesClient create() throws IOException {
        return NetworkProfilesClient.create(NetworkProfilesSettings.newBuilder().build());
    }

    public static final NetworkProfilesClient create(NetworkProfilesSettings settings) throws IOException {
        return new NetworkProfilesClient(settings);
    }

    public static final NetworkProfilesClient create(NetworkProfilesStub stub) {
        return new NetworkProfilesClient(stub);
    }

    protected NetworkProfilesClient(NetworkProfilesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkProfilesStubSettings)settings.getStubSettings()).createStub();
    }

    protected NetworkProfilesClient(NetworkProfilesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NetworkProfilesSettings getSettings() {
        return this.settings;
    }

    public NetworkProfilesStub getStub() {
        return this.stub;
    }

    public final NetworkProfile get(String project, String networkProfile) {
        GetNetworkProfileRequest request = GetNetworkProfileRequest.newBuilder().setProject(project).setNetworkProfile(networkProfile).build();
        return this.get(request);
    }

    public final NetworkProfile get(GetNetworkProfileRequest request) {
        return (NetworkProfile)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkProfileRequest, NetworkProfile> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project) {
        ListNetworkProfilesRequest request = ListNetworkProfilesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListNetworkProfilesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworkProfilesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListNetworkProfilesRequest, NetworkProfilesListResponse> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkProfilesRequest, NetworkProfilesListResponse, NetworkProfile, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListNetworkProfilesRequest, NetworkProfilesListResponse, NetworkProfile, ListPage> {
        private ListPage(PageContext<ListNetworkProfilesRequest, NetworkProfilesListResponse, NetworkProfile> context, NetworkProfilesListResponse response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListNetworkProfilesRequest, NetworkProfilesListResponse, NetworkProfile> context, NetworkProfilesListResponse response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListNetworkProfilesRequest, NetworkProfilesListResponse, NetworkProfile> context, ApiFuture<NetworkProfilesListResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListNetworkProfilesRequest, NetworkProfilesListResponse, NetworkProfile, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListNetworkProfilesRequest, NetworkProfilesListResponse, NetworkProfile> context, ApiFuture<NetworkProfilesListResponse> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

