/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.compute.v1;

import static com.google.cloud.compute.v1.NodeGroupsClient.AggregatedListPagedResponse;
import static com.google.cloud.compute.v1.NodeGroupsClient.ListNodesPagedResponse;
import static com.google.cloud.compute.v1.NodeGroupsClient.ListPagedResponse;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.compute.v1.stub.NodeGroupsStubSettings;
import java.io.IOException;
import java.util.List;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * Settings class to configure an instance of {@link NodeGroupsClient}.
 *
 * <p>The default instance has everything set to sensible defaults:
 *
 * <ul>
 *   <li>The default service address (compute.googleapis.com) and default port (443) are used.
 *   <li>Credentials are acquired automatically through Application Default Credentials.
 *   <li>Retries are configured for idempotent methods but not for non-idempotent methods.
 * </ul>
 *
 * <p>The builder of this class is recursive, so contained classes are themselves builders. When
 * build() is called, the tree of builders is called to create the complete settings object.
 *
 * <p>For example, to set the total timeout of get to 30 seconds:
 *
 * <pre>{@code
 * NodeGroupsSettings.Builder nodeGroupsSettingsBuilder = NodeGroupsSettings.newBuilder();
 * nodeGroupsSettingsBuilder
 *     .getSettings()
 *     .setRetrySettings(
 *         nodeGroupsSettingsBuilder
 *             .getSettings()
 *             .getRetrySettings()
 *             .toBuilder()
 *             .setTotalTimeout(Duration.ofSeconds(30))
 *             .build());
 * NodeGroupsSettings nodeGroupsSettings = nodeGroupsSettingsBuilder.build();
 * }</pre>
 */
@Generated("by gapic-generator-java")
public class NodeGroupsSettings extends ClientSettings<NodeGroupsSettings> {

  /** Returns the object with the settings used for calls to addNodes. */
  public UnaryCallSettings<AddNodesNodeGroupRequest, Operation> addNodesSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).addNodesSettings();
  }

  /** Returns the object with the settings used for calls to addNodes. */
  public OperationCallSettings<AddNodesNodeGroupRequest, Operation, Operation>
      addNodesOperationSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).addNodesOperationSettings();
  }

  /** Returns the object with the settings used for calls to aggregatedList. */
  public PagedCallSettings<
          AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, AggregatedListPagedResponse>
      aggregatedListSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).aggregatedListSettings();
  }

  /** Returns the object with the settings used for calls to delete. */
  public UnaryCallSettings<DeleteNodeGroupRequest, Operation> deleteSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).deleteSettings();
  }

  /** Returns the object with the settings used for calls to delete. */
  public OperationCallSettings<DeleteNodeGroupRequest, Operation, Operation>
      deleteOperationSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).deleteOperationSettings();
  }

  /** Returns the object with the settings used for calls to deleteNodes. */
  public UnaryCallSettings<DeleteNodesNodeGroupRequest, Operation> deleteNodesSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).deleteNodesSettings();
  }

  /** Returns the object with the settings used for calls to deleteNodes. */
  public OperationCallSettings<DeleteNodesNodeGroupRequest, Operation, Operation>
      deleteNodesOperationSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).deleteNodesOperationSettings();
  }

  /** Returns the object with the settings used for calls to get. */
  public UnaryCallSettings<GetNodeGroupRequest, NodeGroup> getSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).getSettings();
  }

  /** Returns the object with the settings used for calls to getIamPolicy. */
  public UnaryCallSettings<GetIamPolicyNodeGroupRequest, Policy> getIamPolicySettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).getIamPolicySettings();
  }

  /** Returns the object with the settings used for calls to insert. */
  public UnaryCallSettings<InsertNodeGroupRequest, Operation> insertSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).insertSettings();
  }

  /** Returns the object with the settings used for calls to insert. */
  public OperationCallSettings<InsertNodeGroupRequest, Operation, Operation>
      insertOperationSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).insertOperationSettings();
  }

  /** Returns the object with the settings used for calls to list. */
  public PagedCallSettings<ListNodeGroupsRequest, NodeGroupList, ListPagedResponse> listSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).listSettings();
  }

  /** Returns the object with the settings used for calls to listNodes. */
  public PagedCallSettings<ListNodesNodeGroupsRequest, NodeGroupsListNodes, ListNodesPagedResponse>
      listNodesSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).listNodesSettings();
  }

  /** Returns the object with the settings used for calls to patch. */
  public UnaryCallSettings<PatchNodeGroupRequest, Operation> patchSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).patchSettings();
  }

  /** Returns the object with the settings used for calls to patch. */
  public OperationCallSettings<PatchNodeGroupRequest, Operation, Operation>
      patchOperationSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).patchOperationSettings();
  }

  /** Returns the object with the settings used for calls to setIamPolicy. */
  public UnaryCallSettings<SetIamPolicyNodeGroupRequest, Policy> setIamPolicySettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).setIamPolicySettings();
  }

  /** Returns the object with the settings used for calls to setNodeTemplate. */
  public UnaryCallSettings<SetNodeTemplateNodeGroupRequest, Operation> setNodeTemplateSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).setNodeTemplateSettings();
  }

  /** Returns the object with the settings used for calls to setNodeTemplate. */
  public OperationCallSettings<SetNodeTemplateNodeGroupRequest, Operation, Operation>
      setNodeTemplateOperationSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).setNodeTemplateOperationSettings();
  }

  /** Returns the object with the settings used for calls to testIamPermissions. */
  public UnaryCallSettings<TestIamPermissionsNodeGroupRequest, TestPermissionsResponse>
      testIamPermissionsSettings() {
    return ((NodeGroupsStubSettings) getStubSettings()).testIamPermissionsSettings();
  }

  public static final NodeGroupsSettings create(NodeGroupsStubSettings stub) throws IOException {
    return new NodeGroupsSettings.Builder(stub.toBuilder()).build();
  }

  /** Returns a builder for the default ExecutorProvider for this service. */
  public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
    return NodeGroupsStubSettings.defaultExecutorProviderBuilder();
  }

  /** Returns the default service endpoint. */
  public static String getDefaultEndpoint() {
    return NodeGroupsStubSettings.getDefaultEndpoint();
  }

  /** Returns the default service scopes. */
  public static List<String> getDefaultServiceScopes() {
    return NodeGroupsStubSettings.getDefaultServiceScopes();
  }

  /** Returns a builder for the default credentials for this service. */
  public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
    return NodeGroupsStubSettings.defaultCredentialsProviderBuilder();
  }

  /** Returns a builder for the default ChannelProvider for this service. */
  public static InstantiatingHttpJsonChannelProvider.Builder
      defaultHttpJsonTransportProviderBuilder() {
    return NodeGroupsStubSettings.defaultHttpJsonTransportProviderBuilder();
  }

  public static TransportChannelProvider defaultTransportChannelProvider() {
    return NodeGroupsStubSettings.defaultTransportChannelProvider();
  }

  @BetaApi("The surface for customizing headers is not stable yet and may change in the future.")
  public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
    return NodeGroupsStubSettings.defaultApiClientHeaderProviderBuilder();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder() {
    return Builder.createDefault();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder(ClientContext clientContext) {
    return new Builder(clientContext);
  }

  /** Returns a builder containing all the values of this settings class. */
  public Builder toBuilder() {
    return new Builder(this);
  }

  protected NodeGroupsSettings(Builder settingsBuilder) throws IOException {
    super(settingsBuilder);
  }

  /** Builder for NodeGroupsSettings. */
  public static class Builder extends ClientSettings.Builder<NodeGroupsSettings, Builder> {

    protected Builder() throws IOException {
      this(((ClientContext) null));
    }

    protected Builder(ClientContext clientContext) {
      super(NodeGroupsStubSettings.newBuilder(clientContext));
    }

    protected Builder(NodeGroupsSettings settings) {
      super(settings.getStubSettings().toBuilder());
    }

    protected Builder(NodeGroupsStubSettings.Builder stubSettings) {
      super(stubSettings);
    }

    private static Builder createDefault() {
      return new Builder(NodeGroupsStubSettings.newBuilder());
    }

    public NodeGroupsStubSettings.Builder getStubSettingsBuilder() {
      return ((NodeGroupsStubSettings.Builder) getStubSettings());
    }

    /**
     * Applies the given settings updater function to all of the unary API methods in this service.
     *
     * <p>Note: This method does not support applying settings to streaming methods.
     */
    public Builder applyToAllUnaryMethods(
        ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
      super.applyToAllUnaryMethods(
          getStubSettingsBuilder().unaryMethodSettingsBuilders(), settingsUpdater);
      return this;
    }

    /** Returns the builder for the settings used for calls to addNodes. */
    public UnaryCallSettings.Builder<AddNodesNodeGroupRequest, Operation> addNodesSettings() {
      return getStubSettingsBuilder().addNodesSettings();
    }

    /** Returns the builder for the settings used for calls to addNodes. */
    public OperationCallSettings.Builder<AddNodesNodeGroupRequest, Operation, Operation>
        addNodesOperationSettings() {
      return getStubSettingsBuilder().addNodesOperationSettings();
    }

    /** Returns the builder for the settings used for calls to aggregatedList. */
    public PagedCallSettings.Builder<
            AggregatedListNodeGroupsRequest, NodeGroupAggregatedList, AggregatedListPagedResponse>
        aggregatedListSettings() {
      return getStubSettingsBuilder().aggregatedListSettings();
    }

    /** Returns the builder for the settings used for calls to delete. */
    public UnaryCallSettings.Builder<DeleteNodeGroupRequest, Operation> deleteSettings() {
      return getStubSettingsBuilder().deleteSettings();
    }

    /** Returns the builder for the settings used for calls to delete. */
    public OperationCallSettings.Builder<DeleteNodeGroupRequest, Operation, Operation>
        deleteOperationSettings() {
      return getStubSettingsBuilder().deleteOperationSettings();
    }

    /** Returns the builder for the settings used for calls to deleteNodes. */
    public UnaryCallSettings.Builder<DeleteNodesNodeGroupRequest, Operation> deleteNodesSettings() {
      return getStubSettingsBuilder().deleteNodesSettings();
    }

    /** Returns the builder for the settings used for calls to deleteNodes. */
    public OperationCallSettings.Builder<DeleteNodesNodeGroupRequest, Operation, Operation>
        deleteNodesOperationSettings() {
      return getStubSettingsBuilder().deleteNodesOperationSettings();
    }

    /** Returns the builder for the settings used for calls to get. */
    public UnaryCallSettings.Builder<GetNodeGroupRequest, NodeGroup> getSettings() {
      return getStubSettingsBuilder().getSettings();
    }

    /** Returns the builder for the settings used for calls to getIamPolicy. */
    public UnaryCallSettings.Builder<GetIamPolicyNodeGroupRequest, Policy> getIamPolicySettings() {
      return getStubSettingsBuilder().getIamPolicySettings();
    }

    /** Returns the builder for the settings used for calls to insert. */
    public UnaryCallSettings.Builder<InsertNodeGroupRequest, Operation> insertSettings() {
      return getStubSettingsBuilder().insertSettings();
    }

    /** Returns the builder for the settings used for calls to insert. */
    public OperationCallSettings.Builder<InsertNodeGroupRequest, Operation, Operation>
        insertOperationSettings() {
      return getStubSettingsBuilder().insertOperationSettings();
    }

    /** Returns the builder for the settings used for calls to list. */
    public PagedCallSettings.Builder<ListNodeGroupsRequest, NodeGroupList, ListPagedResponse>
        listSettings() {
      return getStubSettingsBuilder().listSettings();
    }

    /** Returns the builder for the settings used for calls to listNodes. */
    public PagedCallSettings.Builder<
            ListNodesNodeGroupsRequest, NodeGroupsListNodes, ListNodesPagedResponse>
        listNodesSettings() {
      return getStubSettingsBuilder().listNodesSettings();
    }

    /** Returns the builder for the settings used for calls to patch. */
    public UnaryCallSettings.Builder<PatchNodeGroupRequest, Operation> patchSettings() {
      return getStubSettingsBuilder().patchSettings();
    }

    /** Returns the builder for the settings used for calls to patch. */
    public OperationCallSettings.Builder<PatchNodeGroupRequest, Operation, Operation>
        patchOperationSettings() {
      return getStubSettingsBuilder().patchOperationSettings();
    }

    /** Returns the builder for the settings used for calls to setIamPolicy. */
    public UnaryCallSettings.Builder<SetIamPolicyNodeGroupRequest, Policy> setIamPolicySettings() {
      return getStubSettingsBuilder().setIamPolicySettings();
    }

    /** Returns the builder for the settings used for calls to setNodeTemplate. */
    public UnaryCallSettings.Builder<SetNodeTemplateNodeGroupRequest, Operation>
        setNodeTemplateSettings() {
      return getStubSettingsBuilder().setNodeTemplateSettings();
    }

    /** Returns the builder for the settings used for calls to setNodeTemplate. */
    public OperationCallSettings.Builder<SetNodeTemplateNodeGroupRequest, Operation, Operation>
        setNodeTemplateOperationSettings() {
      return getStubSettingsBuilder().setNodeTemplateOperationSettings();
    }

    /** Returns the builder for the settings used for calls to testIamPermissions. */
    public UnaryCallSettings.Builder<TestIamPermissionsNodeGroupRequest, TestPermissionsResponse>
        testIamPermissionsSettings() {
      return getStubSettingsBuilder().testIamPermissionsSettings();
    }

    @Override
    public NodeGroupsSettings build() throws IOException {
      return new NodeGroupsSettings(this);
    }
  }
}
