/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.stub.SslPoliciesStub;
import com.google.cloud.compute.v1.stub.SslPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * Service Description: The SslPolicies API.
 *
 * <p>This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * <pre>{@code
 * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
 *   String project = "project-309310695";
 *   String sslPolicy = "sslPolicy618174046";
 *   SslPolicy response = sslPoliciesClient.get(project, sslPolicy);
 * }
 * }</pre>
 *
 * <p>Note: close() needs to be called on the SslPoliciesClient object to clean up resources such as
 * threads. In the example above, try-with-resources is used, which automatically calls close().
 *
 * <p>The surface of this class includes several types of Java methods for each of the API's
 * methods:
 *
 * <ol>
 *   <li>A "flattened" method. With this type of method, the fields of the request type have been
 *       converted into function parameters. It may be the case that not all fields are available as
 *       parameters, and not every API method will have a flattened method entry point.
 *   <li>A "request object" method. This type of method only takes one parameter, a request object,
 *       which must be constructed before the call. Not every API method will have a request object
 *       method.
 *   <li>A "callable" method. This type of method takes no parameters and returns an immutable API
 *       callable object, which can be used to initiate calls to the service.
 * </ol>
 *
 * <p>See the individual methods for example code.
 *
 * <p>Many parameters require resource names to be formatted in a particular way. To assist with
 * these names, this class includes a format method for each type of name, and additionally a parse
 * method to extract the individual identifiers contained within names that are returned.
 *
 * <p>This class can be customized by passing in a custom instance of SslPoliciesSettings to
 * create(). For example:
 *
 * <p>To customize credentials:
 *
 * <pre>{@code
 * SslPoliciesSettings sslPoliciesSettings =
 *     SslPoliciesSettings.newBuilder()
 *         .setCredentialsProvider(FixedCredentialsProvider.create(myCredentials))
 *         .build();
 * SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create(sslPoliciesSettings);
 * }</pre>
 *
 * <p>To customize the endpoint:
 *
 * <pre>{@code
 * SslPoliciesSettings sslPoliciesSettings =
 *     SslPoliciesSettings.newBuilder().setEndpoint(myEndpoint).build();
 * SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create(sslPoliciesSettings);
 * }</pre>
 *
 * <p>Please refer to the GitHub repository's samples for more quickstart code snippets.
 */
@Generated("by gapic-generator-java")
public class SslPoliciesClient implements BackgroundResource {
  private final SslPoliciesSettings settings;
  private final SslPoliciesStub stub;

  /** Constructs an instance of SslPoliciesClient with default settings. */
  public static final SslPoliciesClient create() throws IOException {
    return create(SslPoliciesSettings.newBuilder().build());
  }

  /**
   * Constructs an instance of SslPoliciesClient, using the given settings. The channels are created
   * based on the settings passed in, or defaults for any settings that are not set.
   */
  public static final SslPoliciesClient create(SslPoliciesSettings settings) throws IOException {
    return new SslPoliciesClient(settings);
  }

  /**
   * Constructs an instance of SslPoliciesClient, using the given stub for making calls. This is for
   * advanced usage - prefer using create(SslPoliciesSettings).
   */
  @BetaApi("A restructuring of stub classes is planned, so this may break in the future")
  public static final SslPoliciesClient create(SslPoliciesStub stub) {
    return new SslPoliciesClient(stub);
  }

  /**
   * Constructs an instance of SslPoliciesClient, using the given settings. This is protected so
   * that it is easy to make a subclass, but otherwise, the static factory methods should be
   * preferred.
   */
  protected SslPoliciesClient(SslPoliciesSettings settings) throws IOException {
    this.settings = settings;
    this.stub = ((SslPoliciesStubSettings) settings.getStubSettings()).createStub();
  }

  @BetaApi("A restructuring of stub classes is planned, so this may break in the future")
  protected SslPoliciesClient(SslPoliciesStub stub) {
    this.settings = null;
    this.stub = stub;
  }

  public final SslPoliciesSettings getSettings() {
    return settings;
  }

  @BetaApi("A restructuring of stub classes is planned, so this may break in the future")
  public SslPoliciesStub getStub() {
    return stub;
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Deletes the specified SSL policy. The SSL policy resource can be deleted only if it is not in
   * use by any TargetHttpsProxy or TargetSslProxy resources.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   String project = "project-309310695";
   *   String sslPolicy = "sslPolicy618174046";
   *   Operation response = sslPoliciesClient.deleteAsync(project, sslPolicy).get();
   * }
   * }</pre>
   *
   * @param project Project ID for this request.
   * @param sslPolicy Name of the SSL policy to delete. The name must be 1-63 characters long, and
   *     comply with RFC1035.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final OperationFuture<Operation, Operation> deleteAsync(String project, String sslPolicy) {
    DeleteSslPolicyRequest request =
        DeleteSslPolicyRequest.newBuilder().setProject(project).setSslPolicy(sslPolicy).build();
    return deleteAsync(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Deletes the specified SSL policy. The SSL policy resource can be deleted only if it is not in
   * use by any TargetHttpsProxy or TargetSslProxy resources.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   DeleteSslPolicyRequest request =
   *       DeleteSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setRequestId("requestId693933066")
   *           .setSslPolicy("sslPolicy618174046")
   *           .build();
   *   Operation response = sslPoliciesClient.deleteAsync(request).get();
   * }
   * }</pre>
   *
   * @param request The request object containing all of the parameters for the API call.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  @BetaApi(
      "The surface for long-running operations is not stable yet and may change in the future.")
  public final OperationFuture<Operation, Operation> deleteAsync(DeleteSslPolicyRequest request) {
    return deleteOperationCallable().futureCall(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Deletes the specified SSL policy. The SSL policy resource can be deleted only if it is not in
   * use by any TargetHttpsProxy or TargetSslProxy resources.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   DeleteSslPolicyRequest request =
   *       DeleteSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setRequestId("requestId693933066")
   *           .setSslPolicy("sslPolicy618174046")
   *           .build();
   *   OperationFuture<Operation, Operation> future =
   *       sslPoliciesClient.deleteOperationCallable().futureCall(request);
   *   // Do something.
   *   Operation response = future.get();
   * }
   * }</pre>
   */
  public final OperationCallable<DeleteSslPolicyRequest, Operation, Operation>
      deleteOperationCallable() {
    return stub.deleteOperationCallable();
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Deletes the specified SSL policy. The SSL policy resource can be deleted only if it is not in
   * use by any TargetHttpsProxy or TargetSslProxy resources.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   DeleteSslPolicyRequest request =
   *       DeleteSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setRequestId("requestId693933066")
   *           .setSslPolicy("sslPolicy618174046")
   *           .build();
   *   ApiFuture<Operation> future = sslPoliciesClient.deleteCallable().futureCall(request);
   *   // Do something.
   *   Operation response = future.get();
   * }
   * }</pre>
   */
  public final UnaryCallable<DeleteSslPolicyRequest, Operation> deleteCallable() {
    return stub.deleteCallable();
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Lists all of the ordered rules present in a single specified policy.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   String project = "project-309310695";
   *   String sslPolicy = "sslPolicy618174046";
   *   SslPolicy response = sslPoliciesClient.get(project, sslPolicy);
   * }
   * }</pre>
   *
   * @param project Project ID for this request.
   * @param sslPolicy Name of the SSL policy to update. The name must be 1-63 characters long, and
   *     comply with RFC1035.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final SslPolicy get(String project, String sslPolicy) {
    GetSslPolicyRequest request =
        GetSslPolicyRequest.newBuilder().setProject(project).setSslPolicy(sslPolicy).build();
    return get(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Lists all of the ordered rules present in a single specified policy.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   GetSslPolicyRequest request =
   *       GetSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setSslPolicy("sslPolicy618174046")
   *           .build();
   *   SslPolicy response = sslPoliciesClient.get(request);
   * }
   * }</pre>
   *
   * @param request The request object containing all of the parameters for the API call.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final SslPolicy get(GetSslPolicyRequest request) {
    return getCallable().call(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Lists all of the ordered rules present in a single specified policy.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   GetSslPolicyRequest request =
   *       GetSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setSslPolicy("sslPolicy618174046")
   *           .build();
   *   ApiFuture<SslPolicy> future = sslPoliciesClient.getCallable().futureCall(request);
   *   // Do something.
   *   SslPolicy response = future.get();
   * }
   * }</pre>
   */
  public final UnaryCallable<GetSslPolicyRequest, SslPolicy> getCallable() {
    return stub.getCallable();
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Returns the specified SSL policy resource. Gets a list of available SSL policies by making a
   * list() request.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   String project = "project-309310695";
   *   SslPolicy sslPolicyResource = SslPolicy.newBuilder().build();
   *   Operation response = sslPoliciesClient.insertAsync(project, sslPolicyResource).get();
   * }
   * }</pre>
   *
   * @param project Project ID for this request.
   * @param sslPolicyResource The body resource for this request
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final OperationFuture<Operation, Operation> insertAsync(
      String project, SslPolicy sslPolicyResource) {
    InsertSslPolicyRequest request =
        InsertSslPolicyRequest.newBuilder()
            .setProject(project)
            .setSslPolicyResource(sslPolicyResource)
            .build();
    return insertAsync(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Returns the specified SSL policy resource. Gets a list of available SSL policies by making a
   * list() request.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   InsertSslPolicyRequest request =
   *       InsertSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setRequestId("requestId693933066")
   *           .setSslPolicyResource(SslPolicy.newBuilder().build())
   *           .build();
   *   Operation response = sslPoliciesClient.insertAsync(request).get();
   * }
   * }</pre>
   *
   * @param request The request object containing all of the parameters for the API call.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  @BetaApi(
      "The surface for long-running operations is not stable yet and may change in the future.")
  public final OperationFuture<Operation, Operation> insertAsync(InsertSslPolicyRequest request) {
    return insertOperationCallable().futureCall(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Returns the specified SSL policy resource. Gets a list of available SSL policies by making a
   * list() request.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   InsertSslPolicyRequest request =
   *       InsertSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setRequestId("requestId693933066")
   *           .setSslPolicyResource(SslPolicy.newBuilder().build())
   *           .build();
   *   OperationFuture<Operation, Operation> future =
   *       sslPoliciesClient.insertOperationCallable().futureCall(request);
   *   // Do something.
   *   Operation response = future.get();
   * }
   * }</pre>
   */
  public final OperationCallable<InsertSslPolicyRequest, Operation, Operation>
      insertOperationCallable() {
    return stub.insertOperationCallable();
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Returns the specified SSL policy resource. Gets a list of available SSL policies by making a
   * list() request.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   InsertSslPolicyRequest request =
   *       InsertSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setRequestId("requestId693933066")
   *           .setSslPolicyResource(SslPolicy.newBuilder().build())
   *           .build();
   *   ApiFuture<Operation> future = sslPoliciesClient.insertCallable().futureCall(request);
   *   // Do something.
   *   Operation response = future.get();
   * }
   * }</pre>
   */
  public final UnaryCallable<InsertSslPolicyRequest, Operation> insertCallable() {
    return stub.insertCallable();
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Lists all the SSL policies that have been configured for the specified project.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   String project = "project-309310695";
   *   for (SslPolicy element : sslPoliciesClient.list(project).iterateAll()) {
   *     // doThingsWith(element);
   *   }
   * }
   * }</pre>
   *
   * @param project Project ID for this request.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final ListPagedResponse list(String project) {
    ListSslPoliciesRequest request =
        ListSslPoliciesRequest.newBuilder().setProject(project).build();
    return list(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Lists all the SSL policies that have been configured for the specified project.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   ListSslPoliciesRequest request =
   *       ListSslPoliciesRequest.newBuilder()
   *           .setFilter("filter-1274492040")
   *           .setMaxResults(1128457243)
   *           .setOrderBy("orderBy-1207110587")
   *           .setPageToken("pageToken873572522")
   *           .setProject("project-309310695")
   *           .setReturnPartialSuccess(true)
   *           .build();
   *   for (SslPolicy element : sslPoliciesClient.list(request).iterateAll()) {
   *     // doThingsWith(element);
   *   }
   * }
   * }</pre>
   *
   * @param request The request object containing all of the parameters for the API call.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final ListPagedResponse list(ListSslPoliciesRequest request) {
    return listPagedCallable().call(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Lists all the SSL policies that have been configured for the specified project.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   ListSslPoliciesRequest request =
   *       ListSslPoliciesRequest.newBuilder()
   *           .setFilter("filter-1274492040")
   *           .setMaxResults(1128457243)
   *           .setOrderBy("orderBy-1207110587")
   *           .setPageToken("pageToken873572522")
   *           .setProject("project-309310695")
   *           .setReturnPartialSuccess(true)
   *           .build();
   *   ApiFuture<SslPolicy> future = sslPoliciesClient.listPagedCallable().futureCall(request);
   *   // Do something.
   *   for (SslPolicy element : future.get().iterateAll()) {
   *     // doThingsWith(element);
   *   }
   * }
   * }</pre>
   */
  public final UnaryCallable<ListSslPoliciesRequest, ListPagedResponse> listPagedCallable() {
    return stub.listPagedCallable();
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Lists all the SSL policies that have been configured for the specified project.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   ListSslPoliciesRequest request =
   *       ListSslPoliciesRequest.newBuilder()
   *           .setFilter("filter-1274492040")
   *           .setMaxResults(1128457243)
   *           .setOrderBy("orderBy-1207110587")
   *           .setPageToken("pageToken873572522")
   *           .setProject("project-309310695")
   *           .setReturnPartialSuccess(true)
   *           .build();
   *   while (true) {
   *     SslPoliciesList response = sslPoliciesClient.listCallable().call(request);
   *     for (SslPolicy element : response.getResponsesList()) {
   *       // doThingsWith(element);
   *     }
   *     String nextPageToken = response.getNextPageToken();
   *     if (!Strings.isNullOrEmpty(nextPageToken)) {
   *       request = request.toBuilder().setPageToken(nextPageToken).build();
   *     } else {
   *       break;
   *     }
   *   }
   * }
   * }</pre>
   */
  public final UnaryCallable<ListSslPoliciesRequest, SslPoliciesList> listCallable() {
    return stub.listCallable();
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Lists all features that can be specified in the SSL policy when using custom profile.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   String project = "project-309310695";
   *   SslPoliciesListAvailableFeaturesResponse response =
   *       sslPoliciesClient.listAvailableFeatures(project);
   * }
   * }</pre>
   *
   * @param project Project ID for this request.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final SslPoliciesListAvailableFeaturesResponse listAvailableFeatures(String project) {
    ListAvailableFeaturesSslPoliciesRequest request =
        ListAvailableFeaturesSslPoliciesRequest.newBuilder().setProject(project).build();
    return listAvailableFeatures(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Lists all features that can be specified in the SSL policy when using custom profile.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   ListAvailableFeaturesSslPoliciesRequest request =
   *       ListAvailableFeaturesSslPoliciesRequest.newBuilder()
   *           .setFilter("filter-1274492040")
   *           .setMaxResults(1128457243)
   *           .setOrderBy("orderBy-1207110587")
   *           .setPageToken("pageToken873572522")
   *           .setProject("project-309310695")
   *           .setReturnPartialSuccess(true)
   *           .build();
   *   SslPoliciesListAvailableFeaturesResponse response =
   *       sslPoliciesClient.listAvailableFeatures(request);
   * }
   * }</pre>
   *
   * @param request The request object containing all of the parameters for the API call.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final SslPoliciesListAvailableFeaturesResponse listAvailableFeatures(
      ListAvailableFeaturesSslPoliciesRequest request) {
    return listAvailableFeaturesCallable().call(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Lists all features that can be specified in the SSL policy when using custom profile.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   ListAvailableFeaturesSslPoliciesRequest request =
   *       ListAvailableFeaturesSslPoliciesRequest.newBuilder()
   *           .setFilter("filter-1274492040")
   *           .setMaxResults(1128457243)
   *           .setOrderBy("orderBy-1207110587")
   *           .setPageToken("pageToken873572522")
   *           .setProject("project-309310695")
   *           .setReturnPartialSuccess(true)
   *           .build();
   *   ApiFuture<SslPoliciesListAvailableFeaturesResponse> future =
   *       sslPoliciesClient.listAvailableFeaturesCallable().futureCall(request);
   *   // Do something.
   *   SslPoliciesListAvailableFeaturesResponse response = future.get();
   * }
   * }</pre>
   */
  public final UnaryCallable<
          ListAvailableFeaturesSslPoliciesRequest, SslPoliciesListAvailableFeaturesResponse>
      listAvailableFeaturesCallable() {
    return stub.listAvailableFeaturesCallable();
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Patches the specified SSL policy with the data included in the request.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   String project = "project-309310695";
   *   String sslPolicy = "sslPolicy618174046";
   *   SslPolicy sslPolicyResource = SslPolicy.newBuilder().build();
   *   Operation response =
   *       sslPoliciesClient.patchAsync(project, sslPolicy, sslPolicyResource).get();
   * }
   * }</pre>
   *
   * @param project Project ID for this request.
   * @param sslPolicy Name of the SSL policy to update. The name must be 1-63 characters long, and
   *     comply with RFC1035.
   * @param sslPolicyResource The body resource for this request
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  public final OperationFuture<Operation, Operation> patchAsync(
      String project, String sslPolicy, SslPolicy sslPolicyResource) {
    PatchSslPolicyRequest request =
        PatchSslPolicyRequest.newBuilder()
            .setProject(project)
            .setSslPolicy(sslPolicy)
            .setSslPolicyResource(sslPolicyResource)
            .build();
    return patchAsync(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Patches the specified SSL policy with the data included in the request.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   PatchSslPolicyRequest request =
   *       PatchSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setRequestId("requestId693933066")
   *           .setSslPolicy("sslPolicy618174046")
   *           .setSslPolicyResource(SslPolicy.newBuilder().build())
   *           .build();
   *   Operation response = sslPoliciesClient.patchAsync(request).get();
   * }
   * }</pre>
   *
   * @param request The request object containing all of the parameters for the API call.
   * @throws com.google.api.gax.rpc.ApiException if the remote call fails
   */
  @BetaApi(
      "The surface for long-running operations is not stable yet and may change in the future.")
  public final OperationFuture<Operation, Operation> patchAsync(PatchSslPolicyRequest request) {
    return patchOperationCallable().futureCall(request);
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Patches the specified SSL policy with the data included in the request.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   PatchSslPolicyRequest request =
   *       PatchSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setRequestId("requestId693933066")
   *           .setSslPolicy("sslPolicy618174046")
   *           .setSslPolicyResource(SslPolicy.newBuilder().build())
   *           .build();
   *   OperationFuture<Operation, Operation> future =
   *       sslPoliciesClient.patchOperationCallable().futureCall(request);
   *   // Do something.
   *   Operation response = future.get();
   * }
   * }</pre>
   */
  public final OperationCallable<PatchSslPolicyRequest, Operation, Operation>
      patchOperationCallable() {
    return stub.patchOperationCallable();
  }

  // AUTO-GENERATED DOCUMENTATION AND METHOD.
  /**
   * Patches the specified SSL policy with the data included in the request.
   *
   * <p>Sample code:
   *
   * <pre>{@code
   * try (SslPoliciesClient sslPoliciesClient = SslPoliciesClient.create()) {
   *   PatchSslPolicyRequest request =
   *       PatchSslPolicyRequest.newBuilder()
   *           .setProject("project-309310695")
   *           .setRequestId("requestId693933066")
   *           .setSslPolicy("sslPolicy618174046")
   *           .setSslPolicyResource(SslPolicy.newBuilder().build())
   *           .build();
   *   ApiFuture<Operation> future = sslPoliciesClient.patchCallable().futureCall(request);
   *   // Do something.
   *   Operation response = future.get();
   * }
   * }</pre>
   */
  public final UnaryCallable<PatchSslPolicyRequest, Operation> patchCallable() {
    return stub.patchCallable();
  }

  @Override
  public final void close() {
    stub.close();
  }

  @Override
  public void shutdown() {
    stub.shutdown();
  }

  @Override
  public boolean isShutdown() {
    return stub.isShutdown();
  }

  @Override
  public boolean isTerminated() {
    return stub.isTerminated();
  }

  @Override
  public void shutdownNow() {
    stub.shutdownNow();
  }

  @Override
  public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
    return stub.awaitTermination(duration, unit);
  }

  public static class ListPagedResponse
      extends AbstractPagedListResponse<
          ListSslPoliciesRequest, SslPoliciesList, SslPolicy, ListPage, ListFixedSizeCollection> {

    public static ApiFuture<ListPagedResponse> createAsync(
        PageContext<ListSslPoliciesRequest, SslPoliciesList, SslPolicy> context,
        ApiFuture<SslPoliciesList> futureResponse) {
      ApiFuture<ListPage> futurePage =
          ListPage.createEmptyPage().createPageAsync(context, futureResponse);
      return ApiFutures.transform(
          futurePage, input -> new ListPagedResponse(input), MoreExecutors.directExecutor());
    }

    private ListPagedResponse(ListPage page) {
      super(page, ListFixedSizeCollection.createEmptyCollection());
    }
  }

  public static class ListPage
      extends AbstractPage<ListSslPoliciesRequest, SslPoliciesList, SslPolicy, ListPage> {

    private ListPage(
        PageContext<ListSslPoliciesRequest, SslPoliciesList, SslPolicy> context,
        SslPoliciesList response) {
      super(context, response);
    }

    private static ListPage createEmptyPage() {
      return new ListPage(null, null);
    }

    @Override
    protected ListPage createPage(
        PageContext<ListSslPoliciesRequest, SslPoliciesList, SslPolicy> context,
        SslPoliciesList response) {
      return new ListPage(context, response);
    }

    @Override
    public ApiFuture<ListPage> createPageAsync(
        PageContext<ListSslPoliciesRequest, SslPoliciesList, SslPolicy> context,
        ApiFuture<SslPoliciesList> futureResponse) {
      return super.createPageAsync(context, futureResponse);
    }
  }

  public static class ListFixedSizeCollection
      extends AbstractFixedSizeCollection<
          ListSslPoliciesRequest, SslPoliciesList, SslPolicy, ListPage, ListFixedSizeCollection> {

    private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
      super(pages, collectionSize);
    }

    private static ListFixedSizeCollection createEmptyCollection() {
      return new ListFixedSizeCollection(null, 0);
    }

    @Override
    protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
      return new ListFixedSizeCollection(pages, collectionSize);
    }
  }
}
