/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetReservationSubBlockRequest;
import com.google.cloud.compute.v1.ListReservationSubBlocksRequest;
import com.google.cloud.compute.v1.ReservationSubBlock;
import com.google.cloud.compute.v1.ReservationSubBlocksClient;
import com.google.cloud.compute.v1.ReservationSubBlocksGetResponse;
import com.google.cloud.compute.v1.ReservationSubBlocksListResponse;
import com.google.cloud.compute.v1.stub.HttpJsonReservationSubBlocksStub;
import com.google.cloud.compute.v1.stub.ReservationSubBlocksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ReservationSubBlocksStubSettings
extends StubSettings<ReservationSubBlocksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getSettings;
    private final PagedCallSettings<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse> listSettings;
    private static final PagedListDescriptor<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock>(){

        public String emptyToken() {
            return "";
        }

        public ListReservationSubBlocksRequest injectToken(ListReservationSubBlocksRequest payload, String token) {
            return ListReservationSubBlocksRequest.newBuilder((ListReservationSubBlocksRequest)payload).setPageToken(token).build();
        }

        public ListReservationSubBlocksRequest injectPageSize(ListReservationSubBlocksRequest payload, int pageSize) {
            return ListReservationSubBlocksRequest.newBuilder((ListReservationSubBlocksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListReservationSubBlocksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ReservationSubBlocksListResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ReservationSubBlock> extractResources(ReservationSubBlocksListResponse payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse>(){

        public ApiFuture<ReservationSubBlocksClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse> callable, ListReservationSubBlocksRequest request, ApiCallContext context, ApiFuture<ReservationSubBlocksListResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReservationSubBlocksClient.ListPagedResponse.createAsync((PageContext<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getSettings() {
        return this.getSettings;
    }

    public PagedCallSettings<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public ReservationSubBlocksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonReservationSubBlocksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ReservationSubBlocksStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReservationSubBlocksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ReservationSubBlocksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSettings = settingsBuilder.getSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ReservationSubBlocksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getSettings;
        private final PagedCallSettings.Builder<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse> listSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSettings, this.listSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ReservationSubBlocksStubSettings settings) {
            super((StubSettings)settings);
            this.getSettings = settings.getSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSettings, this.listSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ReservationSubBlocksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ReservationSubBlocksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReservationSubBlocksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ReservationSubBlocksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getSettings() {
            return this.getSettings;
        }

        public PagedCallSettings.Builder<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public ReservationSubBlocksStubSettings build() throws IOException {
            return new ReservationSubBlocksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

