/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.conformance;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ConformanceTestLocator {
    private ConformanceTestLocator() {
    }

    public static List<String> findAllResourcePaths(MatchPattern matchPattern) throws IOException, URISyntaxException {
        return ConformanceTestLocator.findAllResourcePaths(matchPattern, Thread.currentThread().getContextClassLoader());
    }

    public static List<String> findAllResourcePaths(MatchPattern matchPattern, ClassLoader classLoader) throws IOException, URISyntaxException {
        ArrayList<String> resourcePaths = new ArrayList<String>();
        Enumeration<URL> pkgDir = classLoader.getResources(matchPattern.getBaseResourcePath());
        block8: while (pkgDir.hasMoreElements()) {
            String scheme;
            URL url = pkgDir.nextElement();
            if (url == null) continue;
            switch (scheme = url.getProtocol()) {
                case "file": {
                    List<String> cf = ConformanceTestLocator.handleFileScheme(url, matchPattern);
                    resourcePaths.addAll(cf);
                    continue block8;
                }
                case "jar": {
                    List<String> cj = ConformanceTestLocator.handleJarScheme(url, matchPattern);
                    resourcePaths.addAll(cj);
                    continue block8;
                }
            }
            throw new IllegalStateException("Unable to scan scheme '" + scheme + "'");
        }
        return resourcePaths;
    }

    private static List<String> handleFileScheme(URL url, MatchPattern mp) throws IOException, URISyntaxException {
        Path path = Paths.get(url.toURI());
        return ConformanceTestLocator.handleFileScheme(mp, path);
    }

    private static List<String> handleFileScheme(MatchPattern mp, Path path) throws IOException {
        ArrayList<String> resourcePaths = new ArrayList<String>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(path);){
            for (Path p : paths) {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    resourcePaths.addAll(ConformanceTestLocator.handleFileScheme(mp, p));
                    continue;
                }
                String filePath = ConformanceTestLocator.normalizePath(p);
                String resourcePath = filePath.substring(filePath.indexOf(mp.getBaseResourcePath()));
                if (!mp.matches(resourcePath)) continue;
                resourcePaths.add(resourcePath);
            }
        }
        return resourcePaths;
    }

    private static List<String> handleJarScheme(URL url, MatchPattern mp) throws IOException {
        String urlPath = url.getPath();
        String jarPath = urlPath.substring(5, urlPath.indexOf("!"));
        ArrayList<String> resourcePaths = new ArrayList<String>();
        JarFile jarFile = new JarFile(jarPath);
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry je = jarEntries.nextElement();
            if (je.isDirectory() || !mp.matches(je.getName())) continue;
            resourcePaths.add(je.getName());
        }
        return resourcePaths;
    }

    private static String normalizePath(Path p) {
        String s = p.normalize().toString();
        if (File.separatorChar == '\\') {
            return s.replace('\\', '/');
        }
        return s;
    }

    public static MatchPattern newMatchPattern(String baseResourcePath, String suffix) {
        if (baseResourcePath == null) {
            throw new IllegalArgumentException("baseResourcePath must be non-null");
        }
        if (suffix == null || suffix.isEmpty()) {
            throw new IllegalArgumentException("suffix must be non-null and non-empty");
        }
        int begin = 0;
        if (baseResourcePath.startsWith("/")) {
            begin = 1;
        }
        return new SimpleMatchPattern(baseResourcePath.substring(begin), suffix);
    }

    private static final class SimpleMatchPattern
    implements MatchPattern {
        private final String baseResourcePath;
        private final String suffix;

        SimpleMatchPattern(String baseResourcePath, String suffix) {
            this.baseResourcePath = baseResourcePath;
            this.suffix = suffix;
        }

        @Override
        public String getBaseResourcePath() {
            return this.baseResourcePath;
        }

        @Override
        public boolean matches(String resourcePath) {
            return resourcePath.startsWith(this.baseResourcePath) && resourcePath.endsWith(this.suffix);
        }
    }

    public static interface MatchPattern {
        public String getBaseResourcePath();

        public boolean matches(String var1);
    }
}

