/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contactcenterinsights.v1.Analysis;
import com.google.cloud.contactcenterinsights.v1.AnalysisName;
import com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata;
import com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest;
import com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsResponse;
import com.google.cloud.contactcenterinsights.v1.BulkDeleteConversationsMetadata;
import com.google.cloud.contactcenterinsights.v1.BulkDeleteConversationsRequest;
import com.google.cloud.contactcenterinsights.v1.BulkDeleteConversationsResponse;
import com.google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsRequest;
import com.google.cloud.contactcenterinsights.v1.CalculateIssueModelStatsResponse;
import com.google.cloud.contactcenterinsights.v1.CalculateStatsRequest;
import com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse;
import com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsSettings;
import com.google.cloud.contactcenterinsights.v1.Conversation;
import com.google.cloud.contactcenterinsights.v1.ConversationName;
import com.google.cloud.contactcenterinsights.v1.CreateAnalysisOperationMetadata;
import com.google.cloud.contactcenterinsights.v1.CreateAnalysisRequest;
import com.google.cloud.contactcenterinsights.v1.CreateConversationRequest;
import com.google.cloud.contactcenterinsights.v1.CreateIssueModelMetadata;
import com.google.cloud.contactcenterinsights.v1.CreateIssueModelRequest;
import com.google.cloud.contactcenterinsights.v1.CreatePhraseMatcherRequest;
import com.google.cloud.contactcenterinsights.v1.CreateViewRequest;
import com.google.cloud.contactcenterinsights.v1.DeleteAnalysisRequest;
import com.google.cloud.contactcenterinsights.v1.DeleteConversationRequest;
import com.google.cloud.contactcenterinsights.v1.DeleteIssueModelMetadata;
import com.google.cloud.contactcenterinsights.v1.DeleteIssueModelRequest;
import com.google.cloud.contactcenterinsights.v1.DeleteIssueRequest;
import com.google.cloud.contactcenterinsights.v1.DeletePhraseMatcherRequest;
import com.google.cloud.contactcenterinsights.v1.DeleteViewRequest;
import com.google.cloud.contactcenterinsights.v1.DeployIssueModelMetadata;
import com.google.cloud.contactcenterinsights.v1.DeployIssueModelRequest;
import com.google.cloud.contactcenterinsights.v1.DeployIssueModelResponse;
import com.google.cloud.contactcenterinsights.v1.EncryptionSpec;
import com.google.cloud.contactcenterinsights.v1.EncryptionSpecName;
import com.google.cloud.contactcenterinsights.v1.ExportInsightsDataMetadata;
import com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest;
import com.google.cloud.contactcenterinsights.v1.ExportInsightsDataResponse;
import com.google.cloud.contactcenterinsights.v1.ExportIssueModelMetadata;
import com.google.cloud.contactcenterinsights.v1.ExportIssueModelRequest;
import com.google.cloud.contactcenterinsights.v1.ExportIssueModelResponse;
import com.google.cloud.contactcenterinsights.v1.GetAnalysisRequest;
import com.google.cloud.contactcenterinsights.v1.GetConversationRequest;
import com.google.cloud.contactcenterinsights.v1.GetEncryptionSpecRequest;
import com.google.cloud.contactcenterinsights.v1.GetIssueModelRequest;
import com.google.cloud.contactcenterinsights.v1.GetIssueRequest;
import com.google.cloud.contactcenterinsights.v1.GetPhraseMatcherRequest;
import com.google.cloud.contactcenterinsights.v1.GetSettingsRequest;
import com.google.cloud.contactcenterinsights.v1.GetViewRequest;
import com.google.cloud.contactcenterinsights.v1.ImportIssueModelMetadata;
import com.google.cloud.contactcenterinsights.v1.ImportIssueModelRequest;
import com.google.cloud.contactcenterinsights.v1.ImportIssueModelResponse;
import com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata;
import com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest;
import com.google.cloud.contactcenterinsights.v1.IngestConversationsResponse;
import com.google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecMetadata;
import com.google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecRequest;
import com.google.cloud.contactcenterinsights.v1.InitializeEncryptionSpecResponse;
import com.google.cloud.contactcenterinsights.v1.Issue;
import com.google.cloud.contactcenterinsights.v1.IssueModel;
import com.google.cloud.contactcenterinsights.v1.IssueModelName;
import com.google.cloud.contactcenterinsights.v1.IssueName;
import com.google.cloud.contactcenterinsights.v1.ListAnalysesRequest;
import com.google.cloud.contactcenterinsights.v1.ListAnalysesResponse;
import com.google.cloud.contactcenterinsights.v1.ListConversationsRequest;
import com.google.cloud.contactcenterinsights.v1.ListConversationsResponse;
import com.google.cloud.contactcenterinsights.v1.ListIssueModelsRequest;
import com.google.cloud.contactcenterinsights.v1.ListIssueModelsResponse;
import com.google.cloud.contactcenterinsights.v1.ListIssuesRequest;
import com.google.cloud.contactcenterinsights.v1.ListIssuesResponse;
import com.google.cloud.contactcenterinsights.v1.ListPhraseMatchersRequest;
import com.google.cloud.contactcenterinsights.v1.ListPhraseMatchersResponse;
import com.google.cloud.contactcenterinsights.v1.ListViewsRequest;
import com.google.cloud.contactcenterinsights.v1.ListViewsResponse;
import com.google.cloud.contactcenterinsights.v1.LocationName;
import com.google.cloud.contactcenterinsights.v1.PhraseMatcher;
import com.google.cloud.contactcenterinsights.v1.PhraseMatcherName;
import com.google.cloud.contactcenterinsights.v1.Settings;
import com.google.cloud.contactcenterinsights.v1.SettingsName;
import com.google.cloud.contactcenterinsights.v1.UndeployIssueModelMetadata;
import com.google.cloud.contactcenterinsights.v1.UndeployIssueModelRequest;
import com.google.cloud.contactcenterinsights.v1.UndeployIssueModelResponse;
import com.google.cloud.contactcenterinsights.v1.UpdateConversationRequest;
import com.google.cloud.contactcenterinsights.v1.UpdateIssueModelRequest;
import com.google.cloud.contactcenterinsights.v1.UpdateIssueRequest;
import com.google.cloud.contactcenterinsights.v1.UpdatePhraseMatcherRequest;
import com.google.cloud.contactcenterinsights.v1.UpdateSettingsRequest;
import com.google.cloud.contactcenterinsights.v1.UpdateViewRequest;
import com.google.cloud.contactcenterinsights.v1.UploadConversationMetadata;
import com.google.cloud.contactcenterinsights.v1.UploadConversationRequest;
import com.google.cloud.contactcenterinsights.v1.View;
import com.google.cloud.contactcenterinsights.v1.ViewName;
import com.google.cloud.contactcenterinsights.v1.stub.ContactCenterInsightsStub;
import com.google.cloud.contactcenterinsights.v1.stub.ContactCenterInsightsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ContactCenterInsightsClient
implements BackgroundResource {
    private final ContactCenterInsightsSettings settings;
    private final ContactCenterInsightsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ContactCenterInsightsClient create() throws IOException {
        return ContactCenterInsightsClient.create(ContactCenterInsightsSettings.newBuilder().build());
    }

    public static final ContactCenterInsightsClient create(ContactCenterInsightsSettings settings) throws IOException {
        return new ContactCenterInsightsClient(settings);
    }

    public static final ContactCenterInsightsClient create(ContactCenterInsightsStub stub) {
        return new ContactCenterInsightsClient(stub);
    }

    protected ContactCenterInsightsClient(ContactCenterInsightsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContactCenterInsightsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ContactCenterInsightsClient(ContactCenterInsightsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ContactCenterInsightsSettings getSettings() {
        return this.settings;
    }

    public ContactCenterInsightsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Conversation createConversation(LocationName parent, Conversation conversation, String conversationId) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConversation(conversation).setConversationId(conversationId).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(String parent, Conversation conversation, String conversationId) {
        CreateConversationRequest request = CreateConversationRequest.newBuilder().setParent(parent).setConversation(conversation).setConversationId(conversationId).build();
        return this.createConversation(request);
    }

    public final Conversation createConversation(CreateConversationRequest request) {
        return (Conversation)this.createConversationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable() {
        return this.stub.createConversationCallable();
    }

    public final OperationFuture<Conversation, UploadConversationMetadata> uploadConversationAsync(UploadConversationRequest request) {
        return this.uploadConversationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UploadConversationRequest, Conversation, UploadConversationMetadata> uploadConversationOperationCallable() {
        return this.stub.uploadConversationOperationCallable();
    }

    public final UnaryCallable<UploadConversationRequest, Operation> uploadConversationCallable() {
        return this.stub.uploadConversationCallable();
    }

    public final Conversation updateConversation(Conversation conversation, FieldMask updateMask) {
        UpdateConversationRequest request = UpdateConversationRequest.newBuilder().setConversation(conversation).setUpdateMask(updateMask).build();
        return this.updateConversation(request);
    }

    public final Conversation updateConversation(UpdateConversationRequest request) {
        return (Conversation)this.updateConversationCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateConversationRequest, Conversation> updateConversationCallable() {
        return this.stub.updateConversationCallable();
    }

    public final Conversation getConversation(ConversationName name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(String name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(GetConversationRequest request) {
        return (Conversation)this.getConversationCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.stub.getConversationCallable();
    }

    public final ListConversationsPagedResponse listConversations(LocationName parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(String parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(ListConversationsRequest request) {
        return (ListConversationsPagedResponse)((Object)this.listConversationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.stub.listConversationsPagedCallable();
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.stub.listConversationsCallable();
    }

    public final void deleteConversation(ConversationName name) {
        DeleteConversationRequest request = DeleteConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConversation(request);
    }

    public final void deleteConversation(String name) {
        DeleteConversationRequest request = DeleteConversationRequest.newBuilder().setName(name).build();
        this.deleteConversation(request);
    }

    public final void deleteConversation(DeleteConversationRequest request) {
        this.deleteConversationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteConversationRequest, Empty> deleteConversationCallable() {
        return this.stub.deleteConversationCallable();
    }

    public final OperationFuture<Analysis, CreateAnalysisOperationMetadata> createAnalysisAsync(ConversationName parent, Analysis analysis) {
        CreateAnalysisRequest request = CreateAnalysisRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAnalysis(analysis).build();
        return this.createAnalysisAsync(request);
    }

    public final OperationFuture<Analysis, CreateAnalysisOperationMetadata> createAnalysisAsync(String parent, Analysis analysis) {
        CreateAnalysisRequest request = CreateAnalysisRequest.newBuilder().setParent(parent).setAnalysis(analysis).build();
        return this.createAnalysisAsync(request);
    }

    public final OperationFuture<Analysis, CreateAnalysisOperationMetadata> createAnalysisAsync(CreateAnalysisRequest request) {
        return this.createAnalysisOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAnalysisRequest, Analysis, CreateAnalysisOperationMetadata> createAnalysisOperationCallable() {
        return this.stub.createAnalysisOperationCallable();
    }

    public final UnaryCallable<CreateAnalysisRequest, Operation> createAnalysisCallable() {
        return this.stub.createAnalysisCallable();
    }

    public final Analysis getAnalysis(AnalysisName name) {
        GetAnalysisRequest request = GetAnalysisRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAnalysis(request);
    }

    public final Analysis getAnalysis(String name) {
        GetAnalysisRequest request = GetAnalysisRequest.newBuilder().setName(name).build();
        return this.getAnalysis(request);
    }

    public final Analysis getAnalysis(GetAnalysisRequest request) {
        return (Analysis)this.getAnalysisCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnalysisRequest, Analysis> getAnalysisCallable() {
        return this.stub.getAnalysisCallable();
    }

    public final ListAnalysesPagedResponse listAnalyses(ConversationName parent) {
        ListAnalysesRequest request = ListAnalysesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAnalyses(request);
    }

    public final ListAnalysesPagedResponse listAnalyses(String parent) {
        ListAnalysesRequest request = ListAnalysesRequest.newBuilder().setParent(parent).build();
        return this.listAnalyses(request);
    }

    public final ListAnalysesPagedResponse listAnalyses(ListAnalysesRequest request) {
        return (ListAnalysesPagedResponse)((Object)this.listAnalysesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAnalysesRequest, ListAnalysesPagedResponse> listAnalysesPagedCallable() {
        return this.stub.listAnalysesPagedCallable();
    }

    public final UnaryCallable<ListAnalysesRequest, ListAnalysesResponse> listAnalysesCallable() {
        return this.stub.listAnalysesCallable();
    }

    public final void deleteAnalysis(AnalysisName name) {
        DeleteAnalysisRequest request = DeleteAnalysisRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAnalysis(request);
    }

    public final void deleteAnalysis(String name) {
        DeleteAnalysisRequest request = DeleteAnalysisRequest.newBuilder().setName(name).build();
        this.deleteAnalysis(request);
    }

    public final void deleteAnalysis(DeleteAnalysisRequest request) {
        this.deleteAnalysisCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAnalysisRequest, Empty> deleteAnalysisCallable() {
        return this.stub.deleteAnalysisCallable();
    }

    public final OperationFuture<BulkAnalyzeConversationsResponse, BulkAnalyzeConversationsMetadata> bulkAnalyzeConversationsAsync(LocationName parent, String filter, float analysisPercentage) {
        BulkAnalyzeConversationsRequest request = BulkAnalyzeConversationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).setAnalysisPercentage(analysisPercentage).build();
        return this.bulkAnalyzeConversationsAsync(request);
    }

    public final OperationFuture<BulkAnalyzeConversationsResponse, BulkAnalyzeConversationsMetadata> bulkAnalyzeConversationsAsync(String parent, String filter, float analysisPercentage) {
        BulkAnalyzeConversationsRequest request = BulkAnalyzeConversationsRequest.newBuilder().setParent(parent).setFilter(filter).setAnalysisPercentage(analysisPercentage).build();
        return this.bulkAnalyzeConversationsAsync(request);
    }

    public final OperationFuture<BulkAnalyzeConversationsResponse, BulkAnalyzeConversationsMetadata> bulkAnalyzeConversationsAsync(BulkAnalyzeConversationsRequest request) {
        return this.bulkAnalyzeConversationsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BulkAnalyzeConversationsRequest, BulkAnalyzeConversationsResponse, BulkAnalyzeConversationsMetadata> bulkAnalyzeConversationsOperationCallable() {
        return this.stub.bulkAnalyzeConversationsOperationCallable();
    }

    public final UnaryCallable<BulkAnalyzeConversationsRequest, Operation> bulkAnalyzeConversationsCallable() {
        return this.stub.bulkAnalyzeConversationsCallable();
    }

    public final OperationFuture<BulkDeleteConversationsResponse, BulkDeleteConversationsMetadata> bulkDeleteConversationsAsync(LocationName parent, String filter) {
        BulkDeleteConversationsRequest request = BulkDeleteConversationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.bulkDeleteConversationsAsync(request);
    }

    public final OperationFuture<BulkDeleteConversationsResponse, BulkDeleteConversationsMetadata> bulkDeleteConversationsAsync(String parent, String filter) {
        BulkDeleteConversationsRequest request = BulkDeleteConversationsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.bulkDeleteConversationsAsync(request);
    }

    public final OperationFuture<BulkDeleteConversationsResponse, BulkDeleteConversationsMetadata> bulkDeleteConversationsAsync(BulkDeleteConversationsRequest request) {
        return this.bulkDeleteConversationsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BulkDeleteConversationsRequest, BulkDeleteConversationsResponse, BulkDeleteConversationsMetadata> bulkDeleteConversationsOperationCallable() {
        return this.stub.bulkDeleteConversationsOperationCallable();
    }

    public final UnaryCallable<BulkDeleteConversationsRequest, Operation> bulkDeleteConversationsCallable() {
        return this.stub.bulkDeleteConversationsCallable();
    }

    public final OperationFuture<IngestConversationsResponse, IngestConversationsMetadata> ingestConversationsAsync(LocationName parent) {
        IngestConversationsRequest request = IngestConversationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.ingestConversationsAsync(request);
    }

    public final OperationFuture<IngestConversationsResponse, IngestConversationsMetadata> ingestConversationsAsync(String parent) {
        IngestConversationsRequest request = IngestConversationsRequest.newBuilder().setParent(parent).build();
        return this.ingestConversationsAsync(request);
    }

    public final OperationFuture<IngestConversationsResponse, IngestConversationsMetadata> ingestConversationsAsync(IngestConversationsRequest request) {
        return this.ingestConversationsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<IngestConversationsRequest, IngestConversationsResponse, IngestConversationsMetadata> ingestConversationsOperationCallable() {
        return this.stub.ingestConversationsOperationCallable();
    }

    public final UnaryCallable<IngestConversationsRequest, Operation> ingestConversationsCallable() {
        return this.stub.ingestConversationsCallable();
    }

    public final OperationFuture<ExportInsightsDataResponse, ExportInsightsDataMetadata> exportInsightsDataAsync(LocationName parent) {
        ExportInsightsDataRequest request = ExportInsightsDataRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.exportInsightsDataAsync(request);
    }

    public final OperationFuture<ExportInsightsDataResponse, ExportInsightsDataMetadata> exportInsightsDataAsync(String parent) {
        ExportInsightsDataRequest request = ExportInsightsDataRequest.newBuilder().setParent(parent).build();
        return this.exportInsightsDataAsync(request);
    }

    public final OperationFuture<ExportInsightsDataResponse, ExportInsightsDataMetadata> exportInsightsDataAsync(ExportInsightsDataRequest request) {
        return this.exportInsightsDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportInsightsDataRequest, ExportInsightsDataResponse, ExportInsightsDataMetadata> exportInsightsDataOperationCallable() {
        return this.stub.exportInsightsDataOperationCallable();
    }

    public final UnaryCallable<ExportInsightsDataRequest, Operation> exportInsightsDataCallable() {
        return this.stub.exportInsightsDataCallable();
    }

    public final OperationFuture<IssueModel, CreateIssueModelMetadata> createIssueModelAsync(LocationName parent, IssueModel issueModel) {
        CreateIssueModelRequest request = CreateIssueModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIssueModel(issueModel).build();
        return this.createIssueModelAsync(request);
    }

    public final OperationFuture<IssueModel, CreateIssueModelMetadata> createIssueModelAsync(String parent, IssueModel issueModel) {
        CreateIssueModelRequest request = CreateIssueModelRequest.newBuilder().setParent(parent).setIssueModel(issueModel).build();
        return this.createIssueModelAsync(request);
    }

    public final OperationFuture<IssueModel, CreateIssueModelMetadata> createIssueModelAsync(CreateIssueModelRequest request) {
        return this.createIssueModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateIssueModelRequest, IssueModel, CreateIssueModelMetadata> createIssueModelOperationCallable() {
        return this.stub.createIssueModelOperationCallable();
    }

    public final UnaryCallable<CreateIssueModelRequest, Operation> createIssueModelCallable() {
        return this.stub.createIssueModelCallable();
    }

    public final IssueModel updateIssueModel(IssueModel issueModel, FieldMask updateMask) {
        UpdateIssueModelRequest request = UpdateIssueModelRequest.newBuilder().setIssueModel(issueModel).setUpdateMask(updateMask).build();
        return this.updateIssueModel(request);
    }

    public final IssueModel updateIssueModel(UpdateIssueModelRequest request) {
        return (IssueModel)this.updateIssueModelCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateIssueModelRequest, IssueModel> updateIssueModelCallable() {
        return this.stub.updateIssueModelCallable();
    }

    public final IssueModel getIssueModel(IssueModelName name) {
        GetIssueModelRequest request = GetIssueModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIssueModel(request);
    }

    public final IssueModel getIssueModel(String name) {
        GetIssueModelRequest request = GetIssueModelRequest.newBuilder().setName(name).build();
        return this.getIssueModel(request);
    }

    public final IssueModel getIssueModel(GetIssueModelRequest request) {
        return (IssueModel)this.getIssueModelCallable().call((Object)request);
    }

    public final UnaryCallable<GetIssueModelRequest, IssueModel> getIssueModelCallable() {
        return this.stub.getIssueModelCallable();
    }

    public final ListIssueModelsResponse listIssueModels(LocationName parent) {
        ListIssueModelsRequest request = ListIssueModelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIssueModels(request);
    }

    public final ListIssueModelsResponse listIssueModels(String parent) {
        ListIssueModelsRequest request = ListIssueModelsRequest.newBuilder().setParent(parent).build();
        return this.listIssueModels(request);
    }

    public final ListIssueModelsResponse listIssueModels(ListIssueModelsRequest request) {
        return (ListIssueModelsResponse)this.listIssueModelsCallable().call((Object)request);
    }

    public final UnaryCallable<ListIssueModelsRequest, ListIssueModelsResponse> listIssueModelsCallable() {
        return this.stub.listIssueModelsCallable();
    }

    public final OperationFuture<Empty, DeleteIssueModelMetadata> deleteIssueModelAsync(IssueModelName name) {
        DeleteIssueModelRequest request = DeleteIssueModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteIssueModelAsync(request);
    }

    public final OperationFuture<Empty, DeleteIssueModelMetadata> deleteIssueModelAsync(String name) {
        DeleteIssueModelRequest request = DeleteIssueModelRequest.newBuilder().setName(name).build();
        return this.deleteIssueModelAsync(request);
    }

    public final OperationFuture<Empty, DeleteIssueModelMetadata> deleteIssueModelAsync(DeleteIssueModelRequest request) {
        return this.deleteIssueModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteIssueModelRequest, Empty, DeleteIssueModelMetadata> deleteIssueModelOperationCallable() {
        return this.stub.deleteIssueModelOperationCallable();
    }

    public final UnaryCallable<DeleteIssueModelRequest, Operation> deleteIssueModelCallable() {
        return this.stub.deleteIssueModelCallable();
    }

    public final OperationFuture<DeployIssueModelResponse, DeployIssueModelMetadata> deployIssueModelAsync(IssueModelName name) {
        DeployIssueModelRequest request = DeployIssueModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deployIssueModelAsync(request);
    }

    public final OperationFuture<DeployIssueModelResponse, DeployIssueModelMetadata> deployIssueModelAsync(String name) {
        DeployIssueModelRequest request = DeployIssueModelRequest.newBuilder().setName(name).build();
        return this.deployIssueModelAsync(request);
    }

    public final OperationFuture<DeployIssueModelResponse, DeployIssueModelMetadata> deployIssueModelAsync(DeployIssueModelRequest request) {
        return this.deployIssueModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeployIssueModelRequest, DeployIssueModelResponse, DeployIssueModelMetadata> deployIssueModelOperationCallable() {
        return this.stub.deployIssueModelOperationCallable();
    }

    public final UnaryCallable<DeployIssueModelRequest, Operation> deployIssueModelCallable() {
        return this.stub.deployIssueModelCallable();
    }

    public final OperationFuture<UndeployIssueModelResponse, UndeployIssueModelMetadata> undeployIssueModelAsync(IssueModelName name) {
        UndeployIssueModelRequest request = UndeployIssueModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeployIssueModelAsync(request);
    }

    public final OperationFuture<UndeployIssueModelResponse, UndeployIssueModelMetadata> undeployIssueModelAsync(String name) {
        UndeployIssueModelRequest request = UndeployIssueModelRequest.newBuilder().setName(name).build();
        return this.undeployIssueModelAsync(request);
    }

    public final OperationFuture<UndeployIssueModelResponse, UndeployIssueModelMetadata> undeployIssueModelAsync(UndeployIssueModelRequest request) {
        return this.undeployIssueModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeployIssueModelRequest, UndeployIssueModelResponse, UndeployIssueModelMetadata> undeployIssueModelOperationCallable() {
        return this.stub.undeployIssueModelOperationCallable();
    }

    public final UnaryCallable<UndeployIssueModelRequest, Operation> undeployIssueModelCallable() {
        return this.stub.undeployIssueModelCallable();
    }

    public final OperationFuture<ExportIssueModelResponse, ExportIssueModelMetadata> exportIssueModelAsync(IssueModelName name) {
        ExportIssueModelRequest request = ExportIssueModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.exportIssueModelAsync(request);
    }

    public final OperationFuture<ExportIssueModelResponse, ExportIssueModelMetadata> exportIssueModelAsync(String name) {
        ExportIssueModelRequest request = ExportIssueModelRequest.newBuilder().setName(name).build();
        return this.exportIssueModelAsync(request);
    }

    public final OperationFuture<ExportIssueModelResponse, ExportIssueModelMetadata> exportIssueModelAsync(ExportIssueModelRequest request) {
        return this.exportIssueModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportIssueModelRequest, ExportIssueModelResponse, ExportIssueModelMetadata> exportIssueModelOperationCallable() {
        return this.stub.exportIssueModelOperationCallable();
    }

    public final UnaryCallable<ExportIssueModelRequest, Operation> exportIssueModelCallable() {
        return this.stub.exportIssueModelCallable();
    }

    public final OperationFuture<ImportIssueModelResponse, ImportIssueModelMetadata> importIssueModelAsync(LocationName parent) {
        ImportIssueModelRequest request = ImportIssueModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.importIssueModelAsync(request);
    }

    public final OperationFuture<ImportIssueModelResponse, ImportIssueModelMetadata> importIssueModelAsync(String parent) {
        ImportIssueModelRequest request = ImportIssueModelRequest.newBuilder().setParent(parent).build();
        return this.importIssueModelAsync(request);
    }

    public final OperationFuture<ImportIssueModelResponse, ImportIssueModelMetadata> importIssueModelAsync(ImportIssueModelRequest request) {
        return this.importIssueModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportIssueModelRequest, ImportIssueModelResponse, ImportIssueModelMetadata> importIssueModelOperationCallable() {
        return this.stub.importIssueModelOperationCallable();
    }

    public final UnaryCallable<ImportIssueModelRequest, Operation> importIssueModelCallable() {
        return this.stub.importIssueModelCallable();
    }

    public final Issue getIssue(IssueName name) {
        GetIssueRequest request = GetIssueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIssue(request);
    }

    public final Issue getIssue(String name) {
        GetIssueRequest request = GetIssueRequest.newBuilder().setName(name).build();
        return this.getIssue(request);
    }

    public final Issue getIssue(GetIssueRequest request) {
        return (Issue)this.getIssueCallable().call((Object)request);
    }

    public final UnaryCallable<GetIssueRequest, Issue> getIssueCallable() {
        return this.stub.getIssueCallable();
    }

    public final ListIssuesResponse listIssues(IssueModelName parent) {
        ListIssuesRequest request = ListIssuesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIssues(request);
    }

    public final ListIssuesResponse listIssues(String parent) {
        ListIssuesRequest request = ListIssuesRequest.newBuilder().setParent(parent).build();
        return this.listIssues(request);
    }

    public final ListIssuesResponse listIssues(ListIssuesRequest request) {
        return (ListIssuesResponse)this.listIssuesCallable().call((Object)request);
    }

    public final UnaryCallable<ListIssuesRequest, ListIssuesResponse> listIssuesCallable() {
        return this.stub.listIssuesCallable();
    }

    public final Issue updateIssue(Issue issue, FieldMask updateMask) {
        UpdateIssueRequest request = UpdateIssueRequest.newBuilder().setIssue(issue).setUpdateMask(updateMask).build();
        return this.updateIssue(request);
    }

    public final Issue updateIssue(UpdateIssueRequest request) {
        return (Issue)this.updateIssueCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateIssueRequest, Issue> updateIssueCallable() {
        return this.stub.updateIssueCallable();
    }

    public final void deleteIssue(IssueName name) {
        DeleteIssueRequest request = DeleteIssueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteIssue(request);
    }

    public final void deleteIssue(String name) {
        DeleteIssueRequest request = DeleteIssueRequest.newBuilder().setName(name).build();
        this.deleteIssue(request);
    }

    public final void deleteIssue(DeleteIssueRequest request) {
        this.deleteIssueCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteIssueRequest, Empty> deleteIssueCallable() {
        return this.stub.deleteIssueCallable();
    }

    public final CalculateIssueModelStatsResponse calculateIssueModelStats(IssueModelName issueModel) {
        CalculateIssueModelStatsRequest request = CalculateIssueModelStatsRequest.newBuilder().setIssueModel(issueModel == null ? null : issueModel.toString()).build();
        return this.calculateIssueModelStats(request);
    }

    public final CalculateIssueModelStatsResponse calculateIssueModelStats(String issueModel) {
        CalculateIssueModelStatsRequest request = CalculateIssueModelStatsRequest.newBuilder().setIssueModel(issueModel).build();
        return this.calculateIssueModelStats(request);
    }

    public final CalculateIssueModelStatsResponse calculateIssueModelStats(CalculateIssueModelStatsRequest request) {
        return (CalculateIssueModelStatsResponse)this.calculateIssueModelStatsCallable().call((Object)request);
    }

    public final UnaryCallable<CalculateIssueModelStatsRequest, CalculateIssueModelStatsResponse> calculateIssueModelStatsCallable() {
        return this.stub.calculateIssueModelStatsCallable();
    }

    public final PhraseMatcher createPhraseMatcher(LocationName parent, PhraseMatcher phraseMatcher) {
        CreatePhraseMatcherRequest request = CreatePhraseMatcherRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPhraseMatcher(phraseMatcher).build();
        return this.createPhraseMatcher(request);
    }

    public final PhraseMatcher createPhraseMatcher(String parent, PhraseMatcher phraseMatcher) {
        CreatePhraseMatcherRequest request = CreatePhraseMatcherRequest.newBuilder().setParent(parent).setPhraseMatcher(phraseMatcher).build();
        return this.createPhraseMatcher(request);
    }

    public final PhraseMatcher createPhraseMatcher(CreatePhraseMatcherRequest request) {
        return (PhraseMatcher)this.createPhraseMatcherCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePhraseMatcherRequest, PhraseMatcher> createPhraseMatcherCallable() {
        return this.stub.createPhraseMatcherCallable();
    }

    public final PhraseMatcher getPhraseMatcher(PhraseMatcherName name) {
        GetPhraseMatcherRequest request = GetPhraseMatcherRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPhraseMatcher(request);
    }

    public final PhraseMatcher getPhraseMatcher(String name) {
        GetPhraseMatcherRequest request = GetPhraseMatcherRequest.newBuilder().setName(name).build();
        return this.getPhraseMatcher(request);
    }

    public final PhraseMatcher getPhraseMatcher(GetPhraseMatcherRequest request) {
        return (PhraseMatcher)this.getPhraseMatcherCallable().call((Object)request);
    }

    public final UnaryCallable<GetPhraseMatcherRequest, PhraseMatcher> getPhraseMatcherCallable() {
        return this.stub.getPhraseMatcherCallable();
    }

    public final ListPhraseMatchersPagedResponse listPhraseMatchers(LocationName parent) {
        ListPhraseMatchersRequest request = ListPhraseMatchersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPhraseMatchers(request);
    }

    public final ListPhraseMatchersPagedResponse listPhraseMatchers(String parent) {
        ListPhraseMatchersRequest request = ListPhraseMatchersRequest.newBuilder().setParent(parent).build();
        return this.listPhraseMatchers(request);
    }

    public final ListPhraseMatchersPagedResponse listPhraseMatchers(ListPhraseMatchersRequest request) {
        return (ListPhraseMatchersPagedResponse)((Object)this.listPhraseMatchersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPhraseMatchersRequest, ListPhraseMatchersPagedResponse> listPhraseMatchersPagedCallable() {
        return this.stub.listPhraseMatchersPagedCallable();
    }

    public final UnaryCallable<ListPhraseMatchersRequest, ListPhraseMatchersResponse> listPhraseMatchersCallable() {
        return this.stub.listPhraseMatchersCallable();
    }

    public final void deletePhraseMatcher(PhraseMatcherName name) {
        DeletePhraseMatcherRequest request = DeletePhraseMatcherRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePhraseMatcher(request);
    }

    public final void deletePhraseMatcher(String name) {
        DeletePhraseMatcherRequest request = DeletePhraseMatcherRequest.newBuilder().setName(name).build();
        this.deletePhraseMatcher(request);
    }

    public final void deletePhraseMatcher(DeletePhraseMatcherRequest request) {
        this.deletePhraseMatcherCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePhraseMatcherRequest, Empty> deletePhraseMatcherCallable() {
        return this.stub.deletePhraseMatcherCallable();
    }

    public final PhraseMatcher updatePhraseMatcher(PhraseMatcher phraseMatcher, FieldMask updateMask) {
        UpdatePhraseMatcherRequest request = UpdatePhraseMatcherRequest.newBuilder().setPhraseMatcher(phraseMatcher).setUpdateMask(updateMask).build();
        return this.updatePhraseMatcher(request);
    }

    public final PhraseMatcher updatePhraseMatcher(UpdatePhraseMatcherRequest request) {
        return (PhraseMatcher)this.updatePhraseMatcherCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePhraseMatcherRequest, PhraseMatcher> updatePhraseMatcherCallable() {
        return this.stub.updatePhraseMatcherCallable();
    }

    public final CalculateStatsResponse calculateStats(LocationName location) {
        CalculateStatsRequest request = CalculateStatsRequest.newBuilder().setLocation(location == null ? null : location.toString()).build();
        return this.calculateStats(request);
    }

    public final CalculateStatsResponse calculateStats(String location) {
        CalculateStatsRequest request = CalculateStatsRequest.newBuilder().setLocation(location).build();
        return this.calculateStats(request);
    }

    public final CalculateStatsResponse calculateStats(CalculateStatsRequest request) {
        return (CalculateStatsResponse)this.calculateStatsCallable().call((Object)request);
    }

    public final UnaryCallable<CalculateStatsRequest, CalculateStatsResponse> calculateStatsCallable() {
        return this.stub.calculateStatsCallable();
    }

    public final Settings getSettings(SettingsName name) {
        GetSettingsRequest request = GetSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSettings(request);
    }

    public final Settings getSettings(String name) {
        GetSettingsRequest request = GetSettingsRequest.newBuilder().setName(name).build();
        return this.getSettings(request);
    }

    public final Settings getSettings(GetSettingsRequest request) {
        return (Settings)this.getSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetSettingsRequest, Settings> getSettingsCallable() {
        return this.stub.getSettingsCallable();
    }

    public final Settings updateSettings(Settings settings, FieldMask updateMask) {
        UpdateSettingsRequest request = UpdateSettingsRequest.newBuilder().setSettings(settings).setUpdateMask(updateMask).build();
        return this.updateSettings(request);
    }

    public final Settings updateSettings(UpdateSettingsRequest request) {
        return (Settings)this.updateSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSettingsRequest, Settings> updateSettingsCallable() {
        return this.stub.updateSettingsCallable();
    }

    public final EncryptionSpec getEncryptionSpec(EncryptionSpecName name) {
        GetEncryptionSpecRequest request = GetEncryptionSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEncryptionSpec(request);
    }

    public final EncryptionSpec getEncryptionSpec(String name) {
        GetEncryptionSpecRequest request = GetEncryptionSpecRequest.newBuilder().setName(name).build();
        return this.getEncryptionSpec(request);
    }

    public final EncryptionSpec getEncryptionSpec(GetEncryptionSpecRequest request) {
        return (EncryptionSpec)this.getEncryptionSpecCallable().call((Object)request);
    }

    public final UnaryCallable<GetEncryptionSpecRequest, EncryptionSpec> getEncryptionSpecCallable() {
        return this.stub.getEncryptionSpecCallable();
    }

    public final OperationFuture<InitializeEncryptionSpecResponse, InitializeEncryptionSpecMetadata> initializeEncryptionSpecAsync(EncryptionSpec encryptionSpec) {
        InitializeEncryptionSpecRequest request = InitializeEncryptionSpecRequest.newBuilder().setEncryptionSpec(encryptionSpec).build();
        return this.initializeEncryptionSpecAsync(request);
    }

    public final OperationFuture<InitializeEncryptionSpecResponse, InitializeEncryptionSpecMetadata> initializeEncryptionSpecAsync(InitializeEncryptionSpecRequest request) {
        return this.initializeEncryptionSpecOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InitializeEncryptionSpecRequest, InitializeEncryptionSpecResponse, InitializeEncryptionSpecMetadata> initializeEncryptionSpecOperationCallable() {
        return this.stub.initializeEncryptionSpecOperationCallable();
    }

    public final UnaryCallable<InitializeEncryptionSpecRequest, Operation> initializeEncryptionSpecCallable() {
        return this.stub.initializeEncryptionSpecCallable();
    }

    public final View createView(LocationName parent, View view) {
        CreateViewRequest request = CreateViewRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setView(view).build();
        return this.createView(request);
    }

    public final View createView(String parent, View view) {
        CreateViewRequest request = CreateViewRequest.newBuilder().setParent(parent).setView(view).build();
        return this.createView(request);
    }

    public final View createView(CreateViewRequest request) {
        return (View)this.createViewCallable().call((Object)request);
    }

    public final UnaryCallable<CreateViewRequest, View> createViewCallable() {
        return this.stub.createViewCallable();
    }

    public final View getView(ViewName name) {
        GetViewRequest request = GetViewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getView(request);
    }

    public final View getView(String name) {
        GetViewRequest request = GetViewRequest.newBuilder().setName(name).build();
        return this.getView(request);
    }

    public final View getView(GetViewRequest request) {
        return (View)this.getViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetViewRequest, View> getViewCallable() {
        return this.stub.getViewCallable();
    }

    public final ListViewsPagedResponse listViews(LocationName parent) {
        ListViewsRequest request = ListViewsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listViews(request);
    }

    public final ListViewsPagedResponse listViews(String parent) {
        ListViewsRequest request = ListViewsRequest.newBuilder().setParent(parent).build();
        return this.listViews(request);
    }

    public final ListViewsPagedResponse listViews(ListViewsRequest request) {
        return (ListViewsPagedResponse)((Object)this.listViewsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListViewsRequest, ListViewsPagedResponse> listViewsPagedCallable() {
        return this.stub.listViewsPagedCallable();
    }

    public final UnaryCallable<ListViewsRequest, ListViewsResponse> listViewsCallable() {
        return this.stub.listViewsCallable();
    }

    public final View updateView(View view, FieldMask updateMask) {
        UpdateViewRequest request = UpdateViewRequest.newBuilder().setView(view).setUpdateMask(updateMask).build();
        return this.updateView(request);
    }

    public final View updateView(UpdateViewRequest request) {
        return (View)this.updateViewCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateViewRequest, View> updateViewCallable() {
        return this.stub.updateViewCallable();
    }

    public final void deleteView(ViewName name) {
        DeleteViewRequest request = DeleteViewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteView(request);
    }

    public final void deleteView(String name) {
        DeleteViewRequest request = DeleteViewRequest.newBuilder().setName(name).build();
        this.deleteView(request);
    }

    public final void deleteView(DeleteViewRequest request) {
        this.deleteViewCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteViewRequest, Empty> deleteViewCallable() {
        return this.stub.deleteViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListViewsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListViewsRequest, ListViewsResponse, View, ListViewsPage, ListViewsFixedSizeCollection> {
        private ListViewsFixedSizeCollection(List<ListViewsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListViewsFixedSizeCollection createEmptyCollection() {
            return new ListViewsFixedSizeCollection(null, 0);
        }

        protected ListViewsFixedSizeCollection createCollection(List<ListViewsPage> pages, int collectionSize) {
            return new ListViewsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListViewsPage
    extends AbstractPage<ListViewsRequest, ListViewsResponse, View, ListViewsPage> {
        private ListViewsPage(PageContext<ListViewsRequest, ListViewsResponse, View> context, ListViewsResponse response) {
            super(context, (Object)response);
        }

        private static ListViewsPage createEmptyPage() {
            return new ListViewsPage(null, null);
        }

        protected ListViewsPage createPage(PageContext<ListViewsRequest, ListViewsResponse, View> context, ListViewsResponse response) {
            return new ListViewsPage(context, response);
        }

        public ApiFuture<ListViewsPage> createPageAsync(PageContext<ListViewsRequest, ListViewsResponse, View> context, ApiFuture<ListViewsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListViewsPagedResponse
    extends AbstractPagedListResponse<ListViewsRequest, ListViewsResponse, View, ListViewsPage, ListViewsFixedSizeCollection> {
        public static ApiFuture<ListViewsPagedResponse> createAsync(PageContext<ListViewsRequest, ListViewsResponse, View> context, ApiFuture<ListViewsResponse> futureResponse) {
            ApiFuture<ListViewsPage> futurePage = ListViewsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListViewsPagedResponse((ListViewsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListViewsPagedResponse(ListViewsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListViewsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPhraseMatchersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher, ListPhraseMatchersPage, ListPhraseMatchersFixedSizeCollection> {
        private ListPhraseMatchersFixedSizeCollection(List<ListPhraseMatchersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPhraseMatchersFixedSizeCollection createEmptyCollection() {
            return new ListPhraseMatchersFixedSizeCollection(null, 0);
        }

        protected ListPhraseMatchersFixedSizeCollection createCollection(List<ListPhraseMatchersPage> pages, int collectionSize) {
            return new ListPhraseMatchersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPhraseMatchersPage
    extends AbstractPage<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher, ListPhraseMatchersPage> {
        private ListPhraseMatchersPage(PageContext<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher> context, ListPhraseMatchersResponse response) {
            super(context, (Object)response);
        }

        private static ListPhraseMatchersPage createEmptyPage() {
            return new ListPhraseMatchersPage(null, null);
        }

        protected ListPhraseMatchersPage createPage(PageContext<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher> context, ListPhraseMatchersResponse response) {
            return new ListPhraseMatchersPage(context, response);
        }

        public ApiFuture<ListPhraseMatchersPage> createPageAsync(PageContext<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher> context, ApiFuture<ListPhraseMatchersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPhraseMatchersPagedResponse
    extends AbstractPagedListResponse<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher, ListPhraseMatchersPage, ListPhraseMatchersFixedSizeCollection> {
        public static ApiFuture<ListPhraseMatchersPagedResponse> createAsync(PageContext<ListPhraseMatchersRequest, ListPhraseMatchersResponse, PhraseMatcher> context, ApiFuture<ListPhraseMatchersResponse> futureResponse) {
            ApiFuture<ListPhraseMatchersPage> futurePage = ListPhraseMatchersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPhraseMatchersPagedResponse((ListPhraseMatchersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPhraseMatchersPagedResponse(ListPhraseMatchersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPhraseMatchersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAnalysesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAnalysesRequest, ListAnalysesResponse, Analysis, ListAnalysesPage, ListAnalysesFixedSizeCollection> {
        private ListAnalysesFixedSizeCollection(List<ListAnalysesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAnalysesFixedSizeCollection createEmptyCollection() {
            return new ListAnalysesFixedSizeCollection(null, 0);
        }

        protected ListAnalysesFixedSizeCollection createCollection(List<ListAnalysesPage> pages, int collectionSize) {
            return new ListAnalysesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAnalysesPage
    extends AbstractPage<ListAnalysesRequest, ListAnalysesResponse, Analysis, ListAnalysesPage> {
        private ListAnalysesPage(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ListAnalysesResponse response) {
            super(context, (Object)response);
        }

        private static ListAnalysesPage createEmptyPage() {
            return new ListAnalysesPage(null, null);
        }

        protected ListAnalysesPage createPage(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ListAnalysesResponse response) {
            return new ListAnalysesPage(context, response);
        }

        public ApiFuture<ListAnalysesPage> createPageAsync(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ApiFuture<ListAnalysesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAnalysesPagedResponse
    extends AbstractPagedListResponse<ListAnalysesRequest, ListAnalysesResponse, Analysis, ListAnalysesPage, ListAnalysesFixedSizeCollection> {
        public static ApiFuture<ListAnalysesPagedResponse> createAsync(PageContext<ListAnalysesRequest, ListAnalysesResponse, Analysis> context, ApiFuture<ListAnalysesResponse> futureResponse) {
            ApiFuture<ListAnalysesPage> futurePage = ListAnalysesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAnalysesPagedResponse((ListAnalysesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAnalysesPagedResponse(ListAnalysesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAnalysesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConversationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        private ListConversationsFixedSizeCollection(List<ListConversationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversationsFixedSizeCollection createEmptyCollection() {
            return new ListConversationsFixedSizeCollection(null, 0);
        }

        protected ListConversationsFixedSizeCollection createCollection(List<ListConversationsPage> pages, int collectionSize) {
            return new ListConversationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversationsPage
    extends AbstractPage<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage> {
        private ListConversationsPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            super(context, (Object)response);
        }

        private static ListConversationsPage createEmptyPage() {
            return new ListConversationsPage(null, null);
        }

        protected ListConversationsPage createPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            return new ListConversationsPage(context, response);
        }

        public ApiFuture<ListConversationsPage> createPageAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversationsPagedResponse
    extends AbstractPagedListResponse<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        public static ApiFuture<ListConversationsPagedResponse> createAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            ApiFuture<ListConversationsPage> futurePage = ListConversationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversationsPagedResponse((ListConversationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversationsPagedResponse(ListConversationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

