/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datafusion.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datafusion.v1beta1.AddDnsPeeringRequest;
import com.google.cloud.datafusion.v1beta1.AddDnsPeeringResponse;
import com.google.cloud.datafusion.v1beta1.CreateInstanceRequest;
import com.google.cloud.datafusion.v1beta1.DataFusionClient;
import com.google.cloud.datafusion.v1beta1.DeleteInstanceRequest;
import com.google.cloud.datafusion.v1beta1.DnsPeering;
import com.google.cloud.datafusion.v1beta1.GetInstanceRequest;
import com.google.cloud.datafusion.v1beta1.Instance;
import com.google.cloud.datafusion.v1beta1.ListAvailableVersionsRequest;
import com.google.cloud.datafusion.v1beta1.ListAvailableVersionsResponse;
import com.google.cloud.datafusion.v1beta1.ListDnsPeeringsRequest;
import com.google.cloud.datafusion.v1beta1.ListDnsPeeringsResponse;
import com.google.cloud.datafusion.v1beta1.ListInstancesRequest;
import com.google.cloud.datafusion.v1beta1.ListInstancesResponse;
import com.google.cloud.datafusion.v1beta1.ListNamespacesRequest;
import com.google.cloud.datafusion.v1beta1.ListNamespacesResponse;
import com.google.cloud.datafusion.v1beta1.Namespace;
import com.google.cloud.datafusion.v1beta1.OperationMetadata;
import com.google.cloud.datafusion.v1beta1.RemoveDnsPeeringRequest;
import com.google.cloud.datafusion.v1beta1.RemoveDnsPeeringResponse;
import com.google.cloud.datafusion.v1beta1.RemoveIamPolicyRequest;
import com.google.cloud.datafusion.v1beta1.RemoveIamPolicyResponse;
import com.google.cloud.datafusion.v1beta1.RestartInstanceRequest;
import com.google.cloud.datafusion.v1beta1.UpdateInstanceRequest;
import com.google.cloud.datafusion.v1beta1.UpgradeInstanceRequest;
import com.google.cloud.datafusion.v1beta1.Version;
import com.google.cloud.datafusion.v1beta1.stub.DataFusionStub;
import com.google.cloud.datafusion.v1beta1.stub.GrpcDataFusionStub;
import com.google.cloud.datafusion.v1beta1.stub.HttpJsonDataFusionStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DataFusionStubSettings
extends StubSettings<DataFusionStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListAvailableVersionsRequest, ListAvailableVersionsResponse, DataFusionClient.ListAvailableVersionsPagedResponse> listAvailableVersionsSettings;
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, DataFusionClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings;
    private final OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings;
    private final OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
    private final UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings;
    private final OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
    private final UnaryCallSettings<RestartInstanceRequest, Operation> restartInstanceSettings;
    private final OperationCallSettings<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationSettings;
    private final UnaryCallSettings<UpgradeInstanceRequest, Operation> upgradeInstanceSettings;
    private final OperationCallSettings<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings;
    private final UnaryCallSettings<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicySettings;
    private final PagedCallSettings<ListNamespacesRequest, ListNamespacesResponse, DataFusionClient.ListNamespacesPagedResponse> listNamespacesSettings;
    private final UnaryCallSettings<AddDnsPeeringRequest, AddDnsPeeringResponse> addDnsPeeringSettings;
    private final UnaryCallSettings<RemoveDnsPeeringRequest, RemoveDnsPeeringResponse> removeDnsPeeringSettings;
    private final PagedCallSettings<ListDnsPeeringsRequest, ListDnsPeeringsResponse, DataFusionClient.ListDnsPeeringsPagedResponse> listDnsPeeringsSettings;
    private static final PagedListDescriptor<ListAvailableVersionsRequest, ListAvailableVersionsResponse, Version> LIST_AVAILABLE_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListAvailableVersionsRequest, ListAvailableVersionsResponse, Version>(){

        public String emptyToken() {
            return "";
        }

        public ListAvailableVersionsRequest injectToken(ListAvailableVersionsRequest payload, String token) {
            return ListAvailableVersionsRequest.newBuilder((ListAvailableVersionsRequest)payload).setPageToken(token).build();
        }

        public ListAvailableVersionsRequest injectPageSize(ListAvailableVersionsRequest payload, int pageSize) {
            return ListAvailableVersionsRequest.newBuilder((ListAvailableVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAvailableVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAvailableVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Version> extractResources(ListAvailableVersionsResponse payload) {
            return payload.getAvailableVersionsList() == null ? ImmutableList.of() : payload.getAvailableVersionsList();
        }
    };
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList() == null ? ImmutableList.of() : payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<ListNamespacesRequest, ListNamespacesResponse, Namespace> LIST_NAMESPACES_PAGE_STR_DESC = new PagedListDescriptor<ListNamespacesRequest, ListNamespacesResponse, Namespace>(){

        public String emptyToken() {
            return "";
        }

        public ListNamespacesRequest injectToken(ListNamespacesRequest payload, String token) {
            return ListNamespacesRequest.newBuilder((ListNamespacesRequest)payload).setPageToken(token).build();
        }

        public ListNamespacesRequest injectPageSize(ListNamespacesRequest payload, int pageSize) {
            return ListNamespacesRequest.newBuilder((ListNamespacesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNamespacesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNamespacesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Namespace> extractResources(ListNamespacesResponse payload) {
            return payload.getNamespacesList() == null ? ImmutableList.of() : payload.getNamespacesList();
        }
    };
    private static final PagedListDescriptor<ListDnsPeeringsRequest, ListDnsPeeringsResponse, DnsPeering> LIST_DNS_PEERINGS_PAGE_STR_DESC = new PagedListDescriptor<ListDnsPeeringsRequest, ListDnsPeeringsResponse, DnsPeering>(){

        public String emptyToken() {
            return "";
        }

        public ListDnsPeeringsRequest injectToken(ListDnsPeeringsRequest payload, String token) {
            return ListDnsPeeringsRequest.newBuilder((ListDnsPeeringsRequest)payload).setPageToken(token).build();
        }

        public ListDnsPeeringsRequest injectPageSize(ListDnsPeeringsRequest payload, int pageSize) {
            return ListDnsPeeringsRequest.newBuilder((ListDnsPeeringsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDnsPeeringsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDnsPeeringsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DnsPeering> extractResources(ListDnsPeeringsResponse payload) {
            return payload.getDnsPeeringsList() == null ? ImmutableList.of() : payload.getDnsPeeringsList();
        }
    };
    private static final PagedListResponseFactory<ListAvailableVersionsRequest, ListAvailableVersionsResponse, DataFusionClient.ListAvailableVersionsPagedResponse> LIST_AVAILABLE_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListAvailableVersionsRequest, ListAvailableVersionsResponse, DataFusionClient.ListAvailableVersionsPagedResponse>(){

        public ApiFuture<DataFusionClient.ListAvailableVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAvailableVersionsRequest, ListAvailableVersionsResponse> callable, ListAvailableVersionsRequest request, ApiCallContext context, ApiFuture<ListAvailableVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AVAILABLE_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataFusionClient.ListAvailableVersionsPagedResponse.createAsync((PageContext<ListAvailableVersionsRequest, ListAvailableVersionsResponse, Version>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, DataFusionClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, DataFusionClient.ListInstancesPagedResponse>(){

        public ApiFuture<DataFusionClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataFusionClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNamespacesRequest, ListNamespacesResponse, DataFusionClient.ListNamespacesPagedResponse> LIST_NAMESPACES_PAGE_STR_FACT = new PagedListResponseFactory<ListNamespacesRequest, ListNamespacesResponse, DataFusionClient.ListNamespacesPagedResponse>(){

        public ApiFuture<DataFusionClient.ListNamespacesPagedResponse> getFuturePagedResponse(UnaryCallable<ListNamespacesRequest, ListNamespacesResponse> callable, ListNamespacesRequest request, ApiCallContext context, ApiFuture<ListNamespacesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NAMESPACES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataFusionClient.ListNamespacesPagedResponse.createAsync((PageContext<ListNamespacesRequest, ListNamespacesResponse, Namespace>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDnsPeeringsRequest, ListDnsPeeringsResponse, DataFusionClient.ListDnsPeeringsPagedResponse> LIST_DNS_PEERINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListDnsPeeringsRequest, ListDnsPeeringsResponse, DataFusionClient.ListDnsPeeringsPagedResponse>(){

        public ApiFuture<DataFusionClient.ListDnsPeeringsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDnsPeeringsRequest, ListDnsPeeringsResponse> callable, ListDnsPeeringsRequest request, ApiCallContext context, ApiFuture<ListDnsPeeringsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DNS_PEERINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataFusionClient.ListDnsPeeringsPagedResponse.createAsync((PageContext<ListDnsPeeringsRequest, ListDnsPeeringsResponse, DnsPeering>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAvailableVersionsRequest, ListAvailableVersionsResponse, DataFusionClient.ListAvailableVersionsPagedResponse> listAvailableVersionsSettings() {
        return this.listAvailableVersionsSettings;
    }

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, DataFusionClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings() {
        return this.createInstanceSettings;
    }

    public OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
        return this.createInstanceOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
        return this.deleteInstanceSettings;
    }

    public OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
        return this.deleteInstanceOperationSettings;
    }

    public UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings() {
        return this.updateInstanceSettings;
    }

    public OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
        return this.updateInstanceOperationSettings;
    }

    public UnaryCallSettings<RestartInstanceRequest, Operation> restartInstanceSettings() {
        return this.restartInstanceSettings;
    }

    public OperationCallSettings<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationSettings() {
        return this.restartInstanceOperationSettings;
    }

    public UnaryCallSettings<UpgradeInstanceRequest, Operation> upgradeInstanceSettings() {
        return this.upgradeInstanceSettings;
    }

    public OperationCallSettings<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings() {
        return this.upgradeInstanceOperationSettings;
    }

    public UnaryCallSettings<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicySettings() {
        return this.removeIamPolicySettings;
    }

    public PagedCallSettings<ListNamespacesRequest, ListNamespacesResponse, DataFusionClient.ListNamespacesPagedResponse> listNamespacesSettings() {
        return this.listNamespacesSettings;
    }

    public UnaryCallSettings<AddDnsPeeringRequest, AddDnsPeeringResponse> addDnsPeeringSettings() {
        return this.addDnsPeeringSettings;
    }

    public UnaryCallSettings<RemoveDnsPeeringRequest, RemoveDnsPeeringResponse> removeDnsPeeringSettings() {
        return this.removeDnsPeeringSettings;
    }

    public PagedCallSettings<ListDnsPeeringsRequest, ListDnsPeeringsResponse, DataFusionClient.ListDnsPeeringsPagedResponse> listDnsPeeringsSettings() {
        return this.listDnsPeeringsSettings;
    }

    public DataFusionStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataFusionStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataFusionStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "datafusion";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "datafusion.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "datafusion.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataFusionStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataFusionStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataFusionStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataFusionStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataFusionStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAvailableVersionsSettings = settingsBuilder.listAvailableVersionsSettings().build();
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.createInstanceSettings = settingsBuilder.createInstanceSettings().build();
        this.createInstanceOperationSettings = settingsBuilder.createInstanceOperationSettings().build();
        this.deleteInstanceSettings = settingsBuilder.deleteInstanceSettings().build();
        this.deleteInstanceOperationSettings = settingsBuilder.deleteInstanceOperationSettings().build();
        this.updateInstanceSettings = settingsBuilder.updateInstanceSettings().build();
        this.updateInstanceOperationSettings = settingsBuilder.updateInstanceOperationSettings().build();
        this.restartInstanceSettings = settingsBuilder.restartInstanceSettings().build();
        this.restartInstanceOperationSettings = settingsBuilder.restartInstanceOperationSettings().build();
        this.upgradeInstanceSettings = settingsBuilder.upgradeInstanceSettings().build();
        this.upgradeInstanceOperationSettings = settingsBuilder.upgradeInstanceOperationSettings().build();
        this.removeIamPolicySettings = settingsBuilder.removeIamPolicySettings().build();
        this.listNamespacesSettings = settingsBuilder.listNamespacesSettings().build();
        this.addDnsPeeringSettings = settingsBuilder.addDnsPeeringSettings().build();
        this.removeDnsPeeringSettings = settingsBuilder.removeDnsPeeringSettings().build();
        this.listDnsPeeringsSettings = settingsBuilder.listDnsPeeringsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataFusionStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAvailableVersionsRequest, ListAvailableVersionsResponse, DataFusionClient.ListAvailableVersionsPagedResponse> listAvailableVersionsSettings;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, DataFusionClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings;
        private final OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings;
        private final OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
        private final UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings;
        private final OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
        private final UnaryCallSettings.Builder<RestartInstanceRequest, Operation> restartInstanceSettings;
        private final OperationCallSettings.Builder<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationSettings;
        private final UnaryCallSettings.Builder<UpgradeInstanceRequest, Operation> upgradeInstanceSettings;
        private final OperationCallSettings.Builder<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings;
        private final UnaryCallSettings.Builder<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicySettings;
        private final PagedCallSettings.Builder<ListNamespacesRequest, ListNamespacesResponse, DataFusionClient.ListNamespacesPagedResponse> listNamespacesSettings;
        private final UnaryCallSettings.Builder<AddDnsPeeringRequest, AddDnsPeeringResponse> addDnsPeeringSettings;
        private final UnaryCallSettings.Builder<RemoveDnsPeeringRequest, RemoveDnsPeeringResponse> removeDnsPeeringSettings;
        private final PagedCallSettings.Builder<ListDnsPeeringsRequest, ListDnsPeeringsResponse, DataFusionClient.ListDnsPeeringsPagedResponse> listDnsPeeringsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAvailableVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AVAILABLE_VERSIONS_PAGE_STR_FACT);
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.updateInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.restartInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restartInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.upgradeInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.upgradeInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.removeIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNamespacesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NAMESPACES_PAGE_STR_FACT);
            this.addDnsPeeringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeDnsPeeringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDnsPeeringsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DNS_PEERINGS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAvailableVersionsSettings, this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.deleteInstanceSettings, this.updateInstanceSettings, this.restartInstanceSettings, this.upgradeInstanceSettings, this.removeIamPolicySettings, this.listNamespacesSettings, this.addDnsPeeringSettings, this.removeDnsPeeringSettings, (Object[])new UnaryCallSettings.Builder[]{this.listDnsPeeringsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DataFusionStubSettings settings) {
            super((StubSettings)settings);
            this.listAvailableVersionsSettings = settings.listAvailableVersionsSettings.toBuilder();
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.createInstanceSettings = settings.createInstanceSettings.toBuilder();
            this.createInstanceOperationSettings = settings.createInstanceOperationSettings.toBuilder();
            this.deleteInstanceSettings = settings.deleteInstanceSettings.toBuilder();
            this.deleteInstanceOperationSettings = settings.deleteInstanceOperationSettings.toBuilder();
            this.updateInstanceSettings = settings.updateInstanceSettings.toBuilder();
            this.updateInstanceOperationSettings = settings.updateInstanceOperationSettings.toBuilder();
            this.restartInstanceSettings = settings.restartInstanceSettings.toBuilder();
            this.restartInstanceOperationSettings = settings.restartInstanceOperationSettings.toBuilder();
            this.upgradeInstanceSettings = settings.upgradeInstanceSettings.toBuilder();
            this.upgradeInstanceOperationSettings = settings.upgradeInstanceOperationSettings.toBuilder();
            this.removeIamPolicySettings = settings.removeIamPolicySettings.toBuilder();
            this.listNamespacesSettings = settings.listNamespacesSettings.toBuilder();
            this.addDnsPeeringSettings = settings.addDnsPeeringSettings.toBuilder();
            this.removeDnsPeeringSettings = settings.removeDnsPeeringSettings.toBuilder();
            this.listDnsPeeringsSettings = settings.listDnsPeeringsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAvailableVersionsSettings, this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.deleteInstanceSettings, this.updateInstanceSettings, this.restartInstanceSettings, this.upgradeInstanceSettings, this.removeIamPolicySettings, this.listNamespacesSettings, this.addDnsPeeringSettings, this.removeDnsPeeringSettings, (Object[])new UnaryCallSettings.Builder[]{this.listDnsPeeringsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataFusionStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataFusionStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataFusionStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataFusionStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataFusionStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataFusionStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataFusionStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataFusionStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataFusionStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataFusionStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAvailableVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.restartInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.upgradeInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.removeIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listNamespacesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.addDnsPeeringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.removeDnsPeeringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listDnsPeeringsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restartInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.upgradeInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAvailableVersionsRequest, ListAvailableVersionsResponse, DataFusionClient.ListAvailableVersionsPagedResponse> listAvailableVersionsSettings() {
            return this.listAvailableVersionsSettings;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, DataFusionClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings() {
            return this.createInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
            return this.createInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
            return this.deleteInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
            return this.deleteInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings() {
            return this.updateInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
            return this.updateInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<RestartInstanceRequest, Operation> restartInstanceSettings() {
            return this.restartInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationSettings() {
            return this.restartInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpgradeInstanceRequest, Operation> upgradeInstanceSettings() {
            return this.upgradeInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings() {
            return this.upgradeInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicySettings() {
            return this.removeIamPolicySettings;
        }

        public PagedCallSettings.Builder<ListNamespacesRequest, ListNamespacesResponse, DataFusionClient.ListNamespacesPagedResponse> listNamespacesSettings() {
            return this.listNamespacesSettings;
        }

        public UnaryCallSettings.Builder<AddDnsPeeringRequest, AddDnsPeeringResponse> addDnsPeeringSettings() {
            return this.addDnsPeeringSettings;
        }

        public UnaryCallSettings.Builder<RemoveDnsPeeringRequest, RemoveDnsPeeringResponse> removeDnsPeeringSettings() {
            return this.removeDnsPeeringSettings;
        }

        public PagedCallSettings.Builder<ListDnsPeeringsRequest, ListDnsPeeringsResponse, DataFusionClient.ListDnsPeeringsPagedResponse> listDnsPeeringsSettings() {
            return this.listDnsPeeringsSettings;
        }

        public DataFusionStubSettings build() throws IOException {
            return new DataFusionStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

