/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.dataflow.v1beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.dataflow.v1beta3.LaunchFlexTemplateRequest;
import com.google.dataflow.v1beta3.LaunchFlexTemplateResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * gRPC stub implementation for the FlexTemplatesService service API.
 *
 * <p>This class is for advanced usage and reflects the underlying API directly.
 */
@BetaApi
@Generated("by gapic-generator-java")
public class GrpcFlexTemplatesServiceStub extends FlexTemplatesServiceStub {
  private static final MethodDescriptor<LaunchFlexTemplateRequest, LaunchFlexTemplateResponse>
      launchFlexTemplateMethodDescriptor =
          MethodDescriptor.<LaunchFlexTemplateRequest, LaunchFlexTemplateResponse>newBuilder()
              .setType(MethodDescriptor.MethodType.UNARY)
              .setFullMethodName("google.dataflow.v1beta3.FlexTemplatesService/LaunchFlexTemplate")
              .setRequestMarshaller(
                  ProtoUtils.marshaller(LaunchFlexTemplateRequest.getDefaultInstance()))
              .setResponseMarshaller(
                  ProtoUtils.marshaller(LaunchFlexTemplateResponse.getDefaultInstance()))
              .build();

  private final UnaryCallable<LaunchFlexTemplateRequest, LaunchFlexTemplateResponse>
      launchFlexTemplateCallable;

  private final BackgroundResource backgroundResources;
  private final GrpcOperationsStub operationsStub;
  private final GrpcStubCallableFactory callableFactory;

  public static final GrpcFlexTemplatesServiceStub create(FlexTemplatesServiceStubSettings settings)
      throws IOException {
    return new GrpcFlexTemplatesServiceStub(settings, ClientContext.create(settings));
  }

  public static final GrpcFlexTemplatesServiceStub create(ClientContext clientContext)
      throws IOException {
    return new GrpcFlexTemplatesServiceStub(
        FlexTemplatesServiceStubSettings.newBuilder().build(), clientContext);
  }

  public static final GrpcFlexTemplatesServiceStub create(
      ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
    return new GrpcFlexTemplatesServiceStub(
        FlexTemplatesServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
  }

  /**
   * Constructs an instance of GrpcFlexTemplatesServiceStub, using the given settings. This is
   * protected so that it is easy to make a subclass, but otherwise, the static factory methods
   * should be preferred.
   */
  protected GrpcFlexTemplatesServiceStub(
      FlexTemplatesServiceStubSettings settings, ClientContext clientContext) throws IOException {
    this(settings, clientContext, new GrpcFlexTemplatesServiceCallableFactory());
  }

  /**
   * Constructs an instance of GrpcFlexTemplatesServiceStub, using the given settings. This is
   * protected so that it is easy to make a subclass, but otherwise, the static factory methods
   * should be preferred.
   */
  protected GrpcFlexTemplatesServiceStub(
      FlexTemplatesServiceStubSettings settings,
      ClientContext clientContext,
      GrpcStubCallableFactory callableFactory)
      throws IOException {
    this.callableFactory = callableFactory;
    this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);

    GrpcCallSettings<LaunchFlexTemplateRequest, LaunchFlexTemplateResponse>
        launchFlexTemplateTransportSettings =
            GrpcCallSettings.<LaunchFlexTemplateRequest, LaunchFlexTemplateResponse>newBuilder()
                .setMethodDescriptor(launchFlexTemplateMethodDescriptor)
                .setParamsExtractor(
                    request -> {
                      RequestParamsBuilder builder = RequestParamsBuilder.create();
                      builder.add("location", String.valueOf(request.getLocation()));
                      builder.add("project_id", String.valueOf(request.getProjectId()));
                      return builder.build();
                    })
                .build();

    this.launchFlexTemplateCallable =
        callableFactory.createUnaryCallable(
            launchFlexTemplateTransportSettings,
            settings.launchFlexTemplateSettings(),
            clientContext);

    this.backgroundResources =
        new BackgroundResourceAggregation(clientContext.getBackgroundResources());
  }

  public GrpcOperationsStub getOperationsStub() {
    return operationsStub;
  }

  @Override
  public UnaryCallable<LaunchFlexTemplateRequest, LaunchFlexTemplateResponse>
      launchFlexTemplateCallable() {
    return launchFlexTemplateCallable;
  }

  @Override
  public final void close() {
    try {
      backgroundResources.close();
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw new IllegalStateException("Failed to close resource", e);
    }
  }

  @Override
  public void shutdown() {
    backgroundResources.shutdown();
  }

  @Override
  public boolean isShutdown() {
    return backgroundResources.isShutdown();
  }

  @Override
  public boolean isTerminated() {
    return backgroundResources.isTerminated();
  }

  @Override
  public void shutdownNow() {
    backgroundResources.shutdownNow();
  }

  @Override
  public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
    return backgroundResources.awaitTermination(duration, unit);
  }
}
