/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.metastore.v1.CreateFederationRequest;
import com.google.cloud.metastore.v1.DataprocMetastoreFederationClient;
import com.google.cloud.metastore.v1.DeleteFederationRequest;
import com.google.cloud.metastore.v1.Federation;
import com.google.cloud.metastore.v1.GetFederationRequest;
import com.google.cloud.metastore.v1.ListFederationsRequest;
import com.google.cloud.metastore.v1.ListFederationsResponse;
import com.google.cloud.metastore.v1.OperationMetadata;
import com.google.cloud.metastore.v1.UpdateFederationRequest;
import com.google.cloud.metastore.v1.stub.DataprocMetastoreFederationStub;
import com.google.cloud.metastore.v1.stub.DataprocMetastoreFederationStubSettings;
import com.google.cloud.metastore.v1.stub.HttpJsonDataprocMetastoreFederationCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonDataprocMetastoreFederationStub
extends DataprocMetastoreFederationStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Federation.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListFederationsRequest, ListFederationsResponse> listFederationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastoreFederation/ListFederations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/federations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListFederationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetFederationRequest, Federation> getFederationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastoreFederation/GetFederation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/federations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Federation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateFederationRequest, Operation> createFederationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastoreFederation/CreateFederation").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/federations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "federationId", (Object)request.getFederationId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("federation", (Message)request.getFederation(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateFederationRequest, Operation> updateFederationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastoreFederation/UpdateFederation").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{federation.name=projects/*/locations/*/federations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "federation.name", (Object)request.getFederation().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("federation", (Message)request.getFederation(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteFederationRequest, Operation> deleteFederationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastoreFederation/DeleteFederation").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/federations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListFederationsRequest, ListFederationsResponse> listFederationsCallable;
    private final UnaryCallable<ListFederationsRequest, DataprocMetastoreFederationClient.ListFederationsPagedResponse> listFederationsPagedCallable;
    private final UnaryCallable<GetFederationRequest, Federation> getFederationCallable;
    private final UnaryCallable<CreateFederationRequest, Operation> createFederationCallable;
    private final OperationCallable<CreateFederationRequest, Federation, OperationMetadata> createFederationOperationCallable;
    private final UnaryCallable<UpdateFederationRequest, Operation> updateFederationCallable;
    private final OperationCallable<UpdateFederationRequest, Federation, OperationMetadata> updateFederationOperationCallable;
    private final UnaryCallable<DeleteFederationRequest, Operation> deleteFederationCallable;
    private final OperationCallable<DeleteFederationRequest, Empty, OperationMetadata> deleteFederationOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDataprocMetastoreFederationStub create(DataprocMetastoreFederationStubSettings settings) throws IOException {
        return new HttpJsonDataprocMetastoreFederationStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDataprocMetastoreFederationStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDataprocMetastoreFederationStub(DataprocMetastoreFederationStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDataprocMetastoreFederationStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDataprocMetastoreFederationStub(DataprocMetastoreFederationStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDataprocMetastoreFederationStub(DataprocMetastoreFederationStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDataprocMetastoreFederationCallableFactory());
    }

    protected HttpJsonDataprocMetastoreFederationStub(DataprocMetastoreFederationStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings listFederationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listFederationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getFederationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFederationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createFederationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createFederationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateFederationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateFederationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteFederationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteFederationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listFederationsCallable = callableFactory.createUnaryCallable(listFederationsTransportSettings, settings.listFederationsSettings(), clientContext);
        this.listFederationsPagedCallable = callableFactory.createPagedCallable(listFederationsTransportSettings, settings.listFederationsSettings(), clientContext);
        this.getFederationCallable = callableFactory.createUnaryCallable(getFederationTransportSettings, settings.getFederationSettings(), clientContext);
        this.createFederationCallable = callableFactory.createUnaryCallable(createFederationTransportSettings, settings.createFederationSettings(), clientContext);
        this.createFederationOperationCallable = callableFactory.createOperationCallable(createFederationTransportSettings, settings.createFederationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateFederationCallable = callableFactory.createUnaryCallable(updateFederationTransportSettings, settings.updateFederationSettings(), clientContext);
        this.updateFederationOperationCallable = callableFactory.createOperationCallable(updateFederationTransportSettings, settings.updateFederationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteFederationCallable = callableFactory.createUnaryCallable(deleteFederationTransportSettings, settings.deleteFederationSettings(), clientContext);
        this.deleteFederationOperationCallable = callableFactory.createOperationCallable(deleteFederationTransportSettings, settings.deleteFederationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listFederationsMethodDescriptor);
        methodDescriptors.add(getFederationMethodDescriptor);
        methodDescriptors.add(createFederationMethodDescriptor);
        methodDescriptors.add(updateFederationMethodDescriptor);
        methodDescriptors.add(deleteFederationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListFederationsRequest, ListFederationsResponse> listFederationsCallable() {
        return this.listFederationsCallable;
    }

    @Override
    public UnaryCallable<ListFederationsRequest, DataprocMetastoreFederationClient.ListFederationsPagedResponse> listFederationsPagedCallable() {
        return this.listFederationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetFederationRequest, Federation> getFederationCallable() {
        return this.getFederationCallable;
    }

    @Override
    public UnaryCallable<CreateFederationRequest, Operation> createFederationCallable() {
        return this.createFederationCallable;
    }

    @Override
    public OperationCallable<CreateFederationRequest, Federation, OperationMetadata> createFederationOperationCallable() {
        return this.createFederationOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateFederationRequest, Operation> updateFederationCallable() {
        return this.updateFederationCallable;
    }

    @Override
    public OperationCallable<UpdateFederationRequest, Federation, OperationMetadata> updateFederationOperationCallable() {
        return this.updateFederationOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFederationRequest, Operation> deleteFederationCallable() {
        return this.deleteFederationCallable;
    }

    @Override
    public OperationCallable<DeleteFederationRequest, Empty, OperationMetadata> deleteFederationOperationCallable() {
        return this.deleteFederationOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

