/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CancelJobRequest;
import com.google.cloud.dataproc.v1.DeleteJobRequest;
import com.google.cloud.dataproc.v1.GetJobRequest;
import com.google.cloud.dataproc.v1.Job;
import com.google.cloud.dataproc.v1.JobControllerClient;
import com.google.cloud.dataproc.v1.ListJobsRequest;
import com.google.cloud.dataproc.v1.ListJobsResponse;
import com.google.cloud.dataproc.v1.SubmitJobRequest;
import com.google.cloud.dataproc.v1.UpdateJobRequest;
import com.google.cloud.dataproc.v1.stub.GrpcJobControllerStub;
import com.google.cloud.dataproc.v1.stub.JobControllerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class JobControllerStubSettings
extends StubSettings<JobControllerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<SubmitJobRequest, Job> submitJobSettings;
    private final UnaryCallSettings<GetJobRequest, Job> getJobSettings;
    private final PagedCallSettings<ListJobsRequest, ListJobsResponse, JobControllerClient.ListJobsPagedResponse> listJobsSettings;
    private final UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings;
    private final UnaryCallSettings<CancelJobRequest, Job> cancelJobSettings;
    private final UnaryCallSettings<DeleteJobRequest, Empty> deleteJobSettings;
    private static final PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job> LIST_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job>(){

        public String emptyToken() {
            return "";
        }

        public ListJobsRequest injectToken(ListJobsRequest payload, String token) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageToken(token).build();
        }

        public ListJobsRequest injectPageSize(ListJobsRequest payload, int pageSize) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Job> extractResources(ListJobsResponse payload) {
            return payload.getJobsList() != null ? payload.getJobsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListJobsRequest, ListJobsResponse, JobControllerClient.ListJobsPagedResponse> LIST_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobsRequest, ListJobsResponse, JobControllerClient.ListJobsPagedResponse>(){

        public ApiFuture<JobControllerClient.ListJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobsRequest, ListJobsResponse> callable, ListJobsRequest request, ApiCallContext context, ApiFuture<ListJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return JobControllerClient.ListJobsPagedResponse.createAsync((PageContext<ListJobsRequest, ListJobsResponse, Job>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<SubmitJobRequest, Job> submitJobSettings() {
        return this.submitJobSettings;
    }

    public UnaryCallSettings<GetJobRequest, Job> getJobSettings() {
        return this.getJobSettings;
    }

    public PagedCallSettings<ListJobsRequest, ListJobsResponse, JobControllerClient.ListJobsPagedResponse> listJobsSettings() {
        return this.listJobsSettings;
    }

    public UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings() {
        return this.updateJobSettings;
    }

    public UnaryCallSettings<CancelJobRequest, Job> cancelJobSettings() {
        return this.cancelJobSettings;
    }

    public UnaryCallSettings<DeleteJobRequest, Empty> deleteJobSettings() {
        return this.deleteJobSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public JobControllerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcJobControllerStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataproc.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return JobControllerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(JobControllerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected JobControllerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.submitJobSettings = settingsBuilder.submitJobSettings().build();
        this.getJobSettings = settingsBuilder.getJobSettings().build();
        this.listJobsSettings = settingsBuilder.listJobsSettings().build();
        this.updateJobSettings = settingsBuilder.updateJobSettings().build();
        this.cancelJobSettings = settingsBuilder.cancelJobSettings().build();
        this.deleteJobSettings = settingsBuilder.deleteJobSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<JobControllerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<SubmitJobRequest, Job> submitJobSettings;
        private final UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings;
        private final PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, JobControllerClient.ListJobsPagedResponse> listJobsSettings;
        private final UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings;
        private final UnaryCallSettings.Builder<CancelJobRequest, Job> cancelJobSettings;
        private final UnaryCallSettings.Builder<DeleteJobRequest, Empty> deleteJobSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.submitJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOBS_PAGE_STR_FACT);
            this.updateJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.submitJobSettings, this.getJobSettings, this.listJobsSettings, this.updateJobSettings, this.cancelJobSettings, this.deleteJobSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(JobControllerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)JobControllerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)JobControllerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(JobControllerStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.submitJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.cancelJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(JobControllerStubSettings settings) {
            super((StubSettings)settings);
            this.submitJobSettings = settings.submitJobSettings.toBuilder();
            this.getJobSettings = settings.getJobSettings.toBuilder();
            this.listJobsSettings = settings.listJobsSettings.toBuilder();
            this.updateJobSettings = settings.updateJobSettings.toBuilder();
            this.cancelJobSettings = settings.cancelJobSettings.toBuilder();
            this.deleteJobSettings = settings.deleteJobSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.submitJobSettings, this.getJobSettings, this.listJobsSettings, this.updateJobSettings, this.cancelJobSettings, this.deleteJobSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<SubmitJobRequest, Job> submitJobSettings() {
            return this.submitJobSettings;
        }

        public UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings() {
            return this.getJobSettings;
        }

        public PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, JobControllerClient.ListJobsPagedResponse> listJobsSettings() {
            return this.listJobsSettings;
        }

        public UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings() {
            return this.updateJobSettings;
        }

        public UnaryCallSettings.Builder<CancelJobRequest, Job> cancelJobSettings() {
            return this.cancelJobSettings;
        }

        public UnaryCallSettings.Builder<DeleteJobRequest, Empty> deleteJobSettings() {
            return this.deleteJobSettings;
        }

        public JobControllerStubSettings build() throws IOException {
            return new JobControllerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)900000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

