/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CancelJobRequest;
import com.google.cloud.dataproc.v1.DeleteJobRequest;
import com.google.cloud.dataproc.v1.GetJobRequest;
import com.google.cloud.dataproc.v1.Job;
import com.google.cloud.dataproc.v1.JobControllerClient;
import com.google.cloud.dataproc.v1.ListJobsRequest;
import com.google.cloud.dataproc.v1.ListJobsResponse;
import com.google.cloud.dataproc.v1.SubmitJobRequest;
import com.google.cloud.dataproc.v1.UpdateJobRequest;
import com.google.cloud.dataproc.v1.stub.GrpcJobControllerCallableFactory;
import com.google.cloud.dataproc.v1.stub.JobControllerStub;
import com.google.cloud.dataproc.v1.stub.JobControllerStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcJobControllerStub
extends JobControllerStub {
    private static final MethodDescriptor<SubmitJobRequest, Job> submitJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/SubmitJob").setRequestMarshaller(ProtoUtils.marshaller((Message)SubmitJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/GetJob").setRequestMarshaller(ProtoUtils.marshaller((Message)GetJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/ListJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateJobRequest, Job> updateJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/UpdateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<CancelJobRequest, Job> cancelJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/CancelJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CancelJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteJobRequest, Empty> deleteJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/DeleteJob").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<SubmitJobRequest, Job> submitJobCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, JobControllerClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<UpdateJobRequest, Job> updateJobCallable;
    private final UnaryCallable<CancelJobRequest, Job> cancelJobCallable;
    private final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcJobControllerStub create(JobControllerStubSettings settings) throws IOException {
        return new GrpcJobControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcJobControllerStub create(ClientContext clientContext) throws IOException {
        return new GrpcJobControllerStub(JobControllerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcJobControllerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcJobControllerStub(JobControllerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcJobControllerStub(JobControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcJobControllerCallableFactory());
    }

    protected GrpcJobControllerStub(JobControllerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings submitJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(submitJobMethodDescriptor).build();
        GrpcCallSettings getJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).build();
        GrpcCallSettings listJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).build();
        GrpcCallSettings updateJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateJobMethodDescriptor).build();
        GrpcCallSettings cancelJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(cancelJobMethodDescriptor).build();
        GrpcCallSettings deleteJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).build();
        this.submitJobCallable = callableFactory.createUnaryCallable(submitJobTransportSettings, settings.submitJobSettings(), clientContext);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.updateJobCallable = callableFactory.createUnaryCallable(updateJobTransportSettings, settings.updateJobSettings(), clientContext);
        this.cancelJobCallable = callableFactory.createUnaryCallable(cancelJobTransportSettings, settings.cancelJobSettings(), clientContext);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<SubmitJobRequest, Job> submitJobCallable() {
        return this.submitJobCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, JobControllerClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.updateJobCallable;
    }

    @Override
    public UnaryCallable<CancelJobRequest, Job> cancelJobCallable() {
        return this.cancelJobCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

