/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.HttpTransportOptions;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreFactory;
import com.google.cloud.datastore.DatastoreImpl;
import com.google.cloud.datastore.Validator;
import com.google.cloud.datastore.spi.DatastoreRpc;
import com.google.cloud.datastore.spi.DatastoreRpcFactory;
import com.google.cloud.datastore.spi.DefaultDatastoreRpc;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;

public class DatastoreOptions
extends ServiceOptions<Datastore, DatastoreRpc, DatastoreOptions> {
    private static final long serialVersionUID = -1018382430058137336L;
    private static final String API_SHORT_NAME = "Datastore";
    private static final String DATASTORE_SCOPE = "https://www.googleapis.com/auth/datastore";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/datastore");
    private final String namespace;

    private DatastoreOptions(Builder builder) {
        super(DatastoreFactory.class, DatastoreRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new DatastoreDefaults());
        this.namespace = builder.namespace != null ? builder.namespace : DatastoreOptions.defaultNamespace();
    }

    protected String getDefaultHost() {
        String host = System.getProperty("DATASTORE_EMULATOR_HOST", System.getenv("DATASTORE_EMULATOR_HOST"));
        return host != null ? host : "https://datastore.googleapis.com";
    }

    protected String getDefaultProject() {
        String projectId = System.getProperty("DATASTORE_PROJECT_ID", System.getenv("DATASTORE_PROJECT_ID"));
        return projectId != null ? projectId : super.getDefaultProject();
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().build();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static DatastoreOptions getDefaultInstance() {
        return DatastoreOptions.newBuilder().build();
    }

    private static String defaultNamespace() {
        try {
            Class<?> clazz = Class.forName("com.google.appengine.api.NamespaceManager");
            Method method = clazz.getMethod("get", new Class[0]);
            String namespace = (String)method.invoke(null, new Object[0]);
            return (String)MoreObjects.firstNonNull((Object)namespace, (Object)"");
        }
        catch (Exception ignore) {
            return "";
        }
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.namespace);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DatastoreOptions)) {
            return false;
        }
        DatastoreOptions other = (DatastoreOptions)((Object)obj);
        return this.baseEquals(other) && Objects.equals(this.namespace, other.namespace);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class DatastoreDefaults
    implements ServiceDefaults<Datastore, DatastoreRpc, DatastoreOptions> {
        private DatastoreDefaults() {
        }

        public DatastoreFactory getDefaultServiceFactory() {
            return DefaultDatastoreFactory.INSTANCE;
        }

        public DatastoreRpcFactory getDefaultRpcFactory() {
            return DefaultDatastoreRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return DatastoreOptions.getDefaultHttpTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<Datastore, DatastoreRpc, DatastoreOptions, Builder> {
        private String namespace;

        private Builder() {
        }

        private Builder(DatastoreOptions options) {
            super((ServiceOptions)options);
            this.namespace = options.namespace;
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for Datastore.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public DatastoreOptions build() {
            return new DatastoreOptions(this);
        }

        public Builder setNamespace(String namespace) {
            this.namespace = Validator.validateNamespace(namespace);
            return this;
        }
    }

    public static class DefaultDatastoreRpcFactory
    implements DatastoreRpcFactory {
        private static final DatastoreRpcFactory INSTANCE = new DefaultDatastoreRpcFactory();

        public DatastoreRpc create(DatastoreOptions options) {
            return new DefaultDatastoreRpc(options);
        }
    }

    public static class DefaultDatastoreFactory
    implements DatastoreFactory {
        private static final DatastoreFactory INSTANCE = new DefaultDatastoreFactory();

        public Datastore create(DatastoreOptions options) {
            return new DatastoreImpl(options);
        }
    }
}

