/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.Value;
import com.google.cloud.datastore.ValueType;
import com.google.datastore.v1.Value;

public final class DateTimeValue
extends Value<DateTime> {
    private static final long serialVersionUID = -5096238337676649540L;
    static final Value.BaseMarshaller<DateTime, DateTimeValue, Builder> MARSHALLER = new Value.BaseMarshaller<DateTime, DateTimeValue, Builder>(){
        private static final long serialVersionUID = -5695812592049332840L;

        @Override
        public int getProtoFieldId() {
            return 10;
        }

        @Override
        public Builder newBuilder(DateTime value) {
            return DateTimeValue.builder(value);
        }

        @Override
        protected DateTime getValue(com.google.datastore.v1.Value from) {
            return new DateTime(DateTime.timestampPbToMicroseconds(from.getTimestampValue()));
        }

        @Override
        protected void setValue(DateTimeValue from, Value.Builder to) {
            to.setTimestampValue(DateTime.microsecondsToTimestampPb(((DateTime)from.get()).timestampMicroseconds()));
        }
    };

    public DateTimeValue(DateTime dateTime) {
        this(DateTimeValue.builder(dateTime));
    }

    private DateTimeValue(Builder builder) {
        super(builder);
    }

    public Builder toBuilder() {
        return (Builder)new Builder().mergeFrom(this);
    }

    public static DateTimeValue of(DateTime dateTime) {
        return new DateTimeValue(dateTime);
    }

    public static Builder builder(DateTime dateTime) {
        return (Builder)new Builder().set(dateTime);
    }

    public static final class Builder
    extends Value.BaseBuilder<DateTime, DateTimeValue, Builder> {
        private Builder() {
            super(ValueType.DATE_TIME);
        }

        @Override
        public DateTimeValue build() {
            return new DateTimeValue(this);
        }
    }
}

