/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.DateTimeValue;
import com.google.cloud.datastore.DoubleValue;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.Serializable;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Validator;
import com.google.cloud.datastore.Value;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.datastore.v1.GqlQuery;
import com.google.datastore.v1.GqlQueryParameter;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class GqlQuery<V>
extends Query<V> {
    private static final long serialVersionUID = 5988280590929540569L;
    private final transient String queryString;
    private final transient boolean allowLiteral;
    private final transient ImmutableMap<String, Binding> namedBindings;
    private final transient ImmutableList<Binding> positionalBindings;

    private GqlQuery(Builder<V> builder) {
        super(((Builder)builder).resultType, ((Builder)builder).namespace);
        this.queryString = ((Builder)builder).queryString;
        this.allowLiteral = ((Builder)builder).allowLiteral;
        this.namedBindings = ImmutableMap.copyOf((Map)((Builder)builder).namedBindings);
        this.positionalBindings = ImmutableList.copyOf((Collection)((Builder)builder).positionalBindings);
    }

    public String queryString() {
        return this.queryString;
    }

    public boolean allowLiteral() {
        return this.allowLiteral;
    }

    public Map<String, Object> namedBindings() {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry binding : this.namedBindings.entrySet()) {
            builder.put(binding.getKey(), ((Binding)binding.getValue()).cursorOrValue());
        }
        return builder.build();
    }

    public List<Object> numberArgs() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Binding binding : this.positionalBindings) {
            builder.add(binding.cursorOrValue());
        }
        return builder.build();
    }

    public int hashCode() {
        return Objects.hash(this.namespace(), this.queryString, this.allowLiteral, this.namedBindings, this.positionalBindings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GqlQuery)) {
            return false;
        }
        GqlQuery other = (GqlQuery)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.queryString, other.queryString) && this.allowLiteral == other.allowLiteral && Objects.equals(this.namedBindings, other.namedBindings) && Objects.equals(this.positionalBindings, other.positionalBindings);
    }

    @Override
    com.google.datastore.v1.GqlQuery toPb() {
        GqlQuery.Builder queryPb = com.google.datastore.v1.GqlQuery.newBuilder();
        queryPb.setQueryString(this.queryString);
        queryPb.setAllowLiterals(this.allowLiteral);
        Map namedBindingsPb = queryPb.getMutableNamedBindings();
        for (Map.Entry entry : this.namedBindings.entrySet()) {
            namedBindingsPb.put(entry.getKey(), ((Binding)entry.getValue()).toPb());
        }
        for (Binding argument : this.positionalBindings) {
            queryPb.addPositionalBindings(argument.toPb());
        }
        return queryPb.build();
    }

    @Override
    void populatePb(RunQueryRequest.Builder requestPb) {
        requestPb.setGqlQuery(this.toPb());
    }

    @Override
    Query<V> nextQuery(RunQueryResponse responsePb) {
        return StructuredQuery.fromPb(this.type(), this.namespace(), responsePb.getQuery()).nextQuery(responsePb);
    }

    @Override
    Object fromPb(Query.ResultType<V> resultType, String namespace, byte[] bytesPb) throws InvalidProtocolBufferException {
        return GqlQuery.fromPb(resultType, namespace, com.google.datastore.v1.GqlQuery.parseFrom((byte[])bytesPb));
    }

    private static <V> GqlQuery<V> fromPb(Query.ResultType<V> resultType, String ns, com.google.datastore.v1.GqlQuery queryPb) {
        Binding currBinding;
        Builder<V> builder = new Builder<V>(resultType, queryPb.getQueryString());
        builder.namespace(ns);
        ((Builder)builder).allowLiteral = queryPb.getAllowLiterals();
        for (Map.Entry nameArg : queryPb.getNamedBindings().entrySet()) {
            currBinding = Binding.fromPb((GqlQueryParameter)nameArg.getValue());
            ((Builder)builder).namedBindings.put(nameArg.getKey(), currBinding);
        }
        for (GqlQueryParameter numberArg : queryPb.getPositionalBindingsList()) {
            currBinding = Binding.fromPb(numberArg);
            ((Builder)builder).positionalBindings.add(currBinding);
        }
        return builder.build();
    }

    public static final class Builder<V> {
        private final Query.ResultType<V> resultType;
        private String namespace;
        private String queryString;
        private boolean allowLiteral;
        private final Map<String, Binding> namedBindings = new TreeMap<String, Binding>();
        private final List<Binding> positionalBindings = new LinkedList<Binding>();

        Builder(Query.ResultType<V> resultType, String query) {
            this.resultType = (Query.ResultType)Preconditions.checkNotNull(resultType);
            this.queryString = (String)Preconditions.checkNotNull((Object)query);
        }

        public Builder<V> query(String query) {
            this.queryString = (String)Preconditions.checkNotNull((Object)query);
            return this;
        }

        public Builder<V> namespace(String namespace) {
            this.namespace = Validator.validateNamespace(namespace);
            return this;
        }

        public Builder<V> allowLiteral(boolean allowLiteral) {
            this.allowLiteral = allowLiteral;
            return this;
        }

        public Builder<V> clearBindings() {
            this.namedBindings.clear();
            this.positionalBindings.clear();
            return this;
        }

        public Builder<V> setBinding(String name, Cursor cursor) {
            this.namedBindings.put(name, new Binding(cursor));
            return this;
        }

        public Builder<V> setBinding(String name, String ... value) {
            this.namedBindings.put(name, Builder.toBinding(StringValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, long ... value) {
            this.namedBindings.put(name, Builder.toBinding(LongValue.MARSHALLER, Longs.asList((long[])value)));
            return this;
        }

        public Builder<V> setBinding(String name, double ... value) {
            this.namedBindings.put(name, Builder.toBinding(DoubleValue.MARSHALLER, Doubles.asList((double[])value)));
            return this;
        }

        public Builder<V> setBinding(String name, boolean ... value) {
            this.namedBindings.put(name, Builder.toBinding(BooleanValue.MARSHALLER, Booleans.asList((boolean[])value)));
            return this;
        }

        public Builder<V> setBinding(String name, DateTime ... value) {
            this.namedBindings.put(name, Builder.toBinding(DateTimeValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, Key ... value) {
            this.namedBindings.put(name, Builder.toBinding(KeyValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, FullEntity<?> ... value) {
            this.namedBindings.put(name, Builder.toBinding(EntityValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, Blob ... value) {
            this.namedBindings.put(name, Builder.toBinding(BlobValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(Cursor cursor) {
            this.positionalBindings.add(new Binding(cursor));
            return this;
        }

        public Builder<V> addBinding(String ... value) {
            this.positionalBindings.add(Builder.toBinding(StringValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(long ... value) {
            this.positionalBindings.add(Builder.toBinding(LongValue.MARSHALLER, Longs.asList((long[])value)));
            return this;
        }

        public Builder<V> addBinding(double ... value) {
            this.positionalBindings.add(Builder.toBinding(DoubleValue.MARSHALLER, Doubles.asList((double[])value)));
            return this;
        }

        public Builder<V> addBinding(boolean ... value) {
            this.positionalBindings.add(Builder.toBinding(BooleanValue.MARSHALLER, Booleans.asList((boolean[])value)));
            return this;
        }

        public Builder<V> addBinding(DateTime ... value) {
            this.positionalBindings.add(Builder.toBinding(DateTimeValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(Key ... value) {
            this.positionalBindings.add(Builder.toBinding(KeyValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(FullEntity<?> ... value) {
            this.positionalBindings.add(Builder.toBinding(EntityValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(Blob ... value) {
            this.positionalBindings.add(Builder.toBinding(BlobValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public GqlQuery<V> build() {
            return new GqlQuery(this);
        }

        private static <V> Binding toBinding(Value.BuilderFactory<V, ?, ?> builderFactory, List<?> values) {
            ArrayList list = new ArrayList(values.size());
            Iterator<?> i$ = values.iterator();
            while (i$.hasNext()) {
                Object object;
                Object v = object = i$.next();
                list.add(builderFactory.newBuilder(v).build());
            }
            Value value = list.isEmpty() ? new NullValue() : (list.size() == 1 ? (Value)list.get(0) : new ListValue(list));
            return new Binding(value);
        }
    }

    static final class Binding
    extends Serializable<GqlQueryParameter> {
        private static final long serialVersionUID = 1976895435257636275L;
        private final transient Cursor cursor;
        private final transient Value<?> value;

        Binding(Cursor cursor) {
            this.cursor = (Cursor)Preconditions.checkNotNull((Object)cursor);
            this.value = null;
        }

        Binding(Value<?> value) {
            this.value = (Value)Preconditions.checkNotNull(value);
            this.cursor = null;
        }

        Object cursorOrValue() {
            return MoreObjects.firstNonNull((Object)this.cursor, this.value);
        }

        public int hashCode() {
            return Objects.hash(this.cursor, this.value);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Binding)) {
                return false;
            }
            Binding other = (Binding)obj;
            return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.value, other.value);
        }

        @Override
        GqlQueryParameter toPb() {
            GqlQueryParameter.Builder argPb = GqlQueryParameter.newBuilder();
            if (this.cursor != null) {
                argPb.setCursor(this.cursor.byteString());
            }
            if (this.value != null) {
                argPb.setValue(this.value.toPb());
            }
            return argPb.build();
        }

        @Override
        Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
            return Binding.fromPb(GqlQueryParameter.parseFrom((byte[])bytesPb));
        }

        static Binding fromPb(GqlQueryParameter argPb) {
            switch (argPb.getParameterTypeCase()) {
                case CURSOR: {
                    return new Binding(new Cursor(argPb.getCursor()));
                }
                case VALUE: {
                    return new Binding(Value.fromPb(argPb.getValue()));
                }
            }
            throw new AssertionError((Object)("Unexpected enum value " + argPb.getParameterTypeCase()));
        }
    }
}

