/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.HttpServiceOptions;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreFactory;
import com.google.cloud.datastore.DatastoreImpl;
import com.google.cloud.datastore.Validator;
import com.google.cloud.datastore.spi.DatastoreRpc;
import com.google.cloud.datastore.spi.DatastoreRpcFactory;
import com.google.cloud.datastore.spi.DefaultDatastoreRpc;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;

public class DatastoreOptions
extends HttpServiceOptions<Datastore, DatastoreRpc, DatastoreOptions> {
    private static final long serialVersionUID = -7859275434360052450L;
    private static final String DATASTORE_SCOPE = "https://www.googleapis.com/auth/datastore";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/datastore");
    private final String namespace;

    private DatastoreOptions(Builder builder) {
        super(DatastoreFactory.class, DatastoreRpcFactory.class, (HttpServiceOptions.Builder)builder);
        this.namespace = builder.namespace != null ? builder.namespace : DatastoreOptions.defaultNamespace();
    }

    public HttpRequestInitializer httpRequestInitializer() {
        final HttpRequestInitializer delegate = super.httpRequestInitializer();
        return new HttpRequestInitializer(){

            public void initialize(HttpRequest httpRequest) throws IOException {
                delegate.initialize(httpRequest);
                httpRequest.getHeaders().setUserAgent(DatastoreOptions.this.applicationName());
            }
        };
    }

    protected String defaultHost() {
        String host = System.getProperty("DATASTORE_EMULATOR_HOST", System.getenv("DATASTORE_EMULATOR_HOST"));
        return host != null ? host : "https://datastore.googleapis.com";
    }

    protected String defaultProject() {
        String projectId = System.getProperty("DATASTORE_PROJECT_ID", System.getenv("DATASTORE_PROJECT_ID"));
        return projectId != null ? projectId : super.defaultProject();
    }

    protected DatastoreFactory defaultServiceFactory() {
        return DefaultDatastoreFactory.INSTANCE;
    }

    protected DatastoreRpcFactory defaultRpcFactory() {
        return DefaultDatastoreRpcFactory.INSTANCE;
    }

    public String namespace() {
        return this.namespace;
    }

    public static DatastoreOptions defaultInstance() {
        return DatastoreOptions.builder().build();
    }

    private static String defaultNamespace() {
        try {
            Class<?> clazz = Class.forName("com.google.appengine.api.NamespaceManager");
            Method method = clazz.getMethod("get", new Class[0]);
            String namespace = (String)method.invoke(null, new Object[0]);
            return (String)MoreObjects.firstNonNull((Object)namespace, (Object)"");
        }
        catch (Exception ignore) {
            return "";
        }
    }

    protected Set<String> scopes() {
        return SCOPES;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.namespace);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DatastoreOptions)) {
            return false;
        }
        DatastoreOptions other = (DatastoreOptions)((Object)obj);
        return this.baseEquals(other) && Objects.equals(this.namespace, other.namespace);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends HttpServiceOptions.Builder<Datastore, DatastoreRpc, DatastoreOptions, Builder> {
        private String namespace;

        private Builder() {
        }

        private Builder(DatastoreOptions options) {
            super((HttpServiceOptions)options);
            this.namespace = options.namespace;
        }

        public DatastoreOptions build() {
            return new DatastoreOptions(this);
        }

        public Builder namespace(String namespace) {
            this.namespace = Validator.validateNamespace(namespace);
            return this;
        }
    }

    public static class DefaultDatastoreRpcFactory
    implements DatastoreRpcFactory {
        private static final DatastoreRpcFactory INSTANCE = new DefaultDatastoreRpcFactory();

        public DatastoreRpc create(DatastoreOptions options) {
            return new DefaultDatastoreRpc(options);
        }
    }

    public static class DefaultDatastoreFactory
    implements DatastoreFactory {
        private static final DatastoreFactory INSTANCE = new DefaultDatastoreFactory();

        public Datastore create(DatastoreOptions options) {
            return new DatastoreImpl(options);
        }
    }
}

