/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Value;
import com.google.cloud.datastore.ValueType;
import com.google.datastore.v1.Value;

public final class LongValue
extends Value<Long> {
    private static final long serialVersionUID = -3433015349912039278L;
    static final Value.BaseMarshaller<Long, LongValue, Builder> MARSHALLER = new Value.BaseMarshaller<Long, LongValue, Builder>(){
        private static final long serialVersionUID = -8359920606872800391L;

        @Override
        public int getProtoFieldId() {
            return 2;
        }

        @Override
        public Builder newBuilder(Long value) {
            return LongValue.builder(value);
        }

        @Override
        protected Long getValue(com.google.datastore.v1.Value from) {
            return from.getIntegerValue();
        }

        @Override
        protected void setValue(LongValue from, Value.Builder to) {
            to.setIntegerValue(((Long)from.get()).longValue());
        }
    };

    public LongValue(long value) {
        this(LongValue.builder(value));
    }

    private LongValue(Builder builder) {
        super(builder);
    }

    public Builder toBuilder() {
        return (Builder)new Builder().mergeFrom(this);
    }

    public static LongValue of(long value) {
        return new LongValue(value);
    }

    public static Builder builder(long value) {
        return (Builder)new Builder().set((Object)value);
    }

    public static final class Builder
    extends Value.BaseBuilder<Long, LongValue, Builder> {
        private Builder() {
            super(ValueType.LONG);
        }

        @Override
        public LongValue build() {
            return new LongValue(this);
        }
    }
}

