/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.DateTimeValue;
import com.google.cloud.datastore.DoubleValue;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.ProjectionEntityQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.Value;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1.CompositeFilter;
import com.google.datastore.v1.Filter;
import com.google.datastore.v1.Projection;
import com.google.datastore.v1.PropertyFilter;
import com.google.datastore.v1.PropertyOrder;
import com.google.datastore.v1.PropertyReference;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.protobuf.Int32Value;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class StructuredQuery<V>
extends Query<V> {
    private static final long serialVersionUID = 546838955624019594L;
    static final String KEY_PROPERTY_NAME = "__key__";
    private final String kind;
    private final ImmutableList<String> projection;
    private final Filter filter;
    private final ImmutableList<String> distinctOn;
    private final ImmutableList<OrderBy> orderBy;
    private final Cursor startCursor;
    private final Cursor endCursor;
    private final int offset;
    private final Integer limit;

    StructuredQuery(BuilderImpl<V, ?> builder) {
        super(((BuilderImpl)builder).resultType, ((BuilderImpl)builder).namespace);
        this.kind = ((BuilderImpl)builder).kind;
        this.projection = ImmutableList.copyOf((Collection)((BuilderImpl)builder).projection);
        this.filter = ((BuilderImpl)builder).filter;
        this.distinctOn = ImmutableList.copyOf((Collection)((BuilderImpl)builder).distinctOn);
        this.orderBy = ImmutableList.copyOf((Collection)((BuilderImpl)builder).orderBy);
        this.startCursor = ((BuilderImpl)builder).startCursor;
        this.endCursor = ((BuilderImpl)builder).endCursor;
        this.offset = ((BuilderImpl)builder).offset;
        this.limit = ((BuilderImpl)builder).limit;
    }

    public String toString() {
        return this.toStringHelper().add("kind", (Object)this.kind).add("startCursor", (Object)this.startCursor).add("endCursor", (Object)this.endCursor).add("offset", this.offset).add("limit", (Object)this.limit).add("filter", (Object)this.filter).add("orderBy", this.orderBy).add("projection", this.projection).add("distinctOn", this.distinctOn).toString();
    }

    public int hashCode() {
        return Objects.hash(this.namespace(), this.kind, this.startCursor, this.endCursor, this.offset, this.limit, this.filter, this.orderBy, this.projection, this.distinctOn);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StructuredQuery)) {
            return false;
        }
        StructuredQuery other = (StructuredQuery)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.kind, other.kind) && Objects.equals(this.startCursor, other.startCursor) && Objects.equals(this.endCursor, other.endCursor) && Objects.equals(this.offset, other.offset) && Objects.equals(this.limit, other.limit) && Objects.equals(this.filter, other.filter) && Objects.equals(this.orderBy, other.orderBy) && Objects.equals(this.projection, other.projection) && Objects.equals(this.distinctOn, other.distinctOn);
    }

    public String kind() {
        return this.kind;
    }

    boolean keyOnly() {
        return this.projection.size() == 1 && KEY_PROPERTY_NAME.equals(this.projection.get(0));
    }

    public List<String> projection() {
        return this.projection;
    }

    public Filter filter() {
        return this.filter;
    }

    public List<String> distinctOn() {
        return this.distinctOn;
    }

    public ImmutableList<OrderBy> orderBy() {
        return this.orderBy;
    }

    public Cursor startCursor() {
        return this.startCursor;
    }

    public Cursor endCursor() {
        return this.endCursor;
    }

    public int offset() {
        return this.offset;
    }

    public Integer limit() {
        return this.limit;
    }

    public abstract Builder<V> toBuilder();

    @Override
    void populatePb(RunQueryRequest.Builder requestPb) {
        requestPb.setQuery(this.toPb());
    }

    @Override
    StructuredQuery<V> nextQuery(RunQueryResponse responsePb) {
        Builder<V> builder = this.toBuilder();
        builder.startCursor(new Cursor(responsePb.getBatch().getEndCursor()));
        if (this.offset > 0 && responsePb.getBatch().getSkippedResults() < this.offset) {
            builder.offset(this.offset - responsePb.getBatch().getSkippedResults());
        } else {
            builder.offset(0);
            if (this.limit != null) {
                builder.limit(this.limit - responsePb.getBatch().getEntityResultsCount());
            }
        }
        return builder.build();
    }

    com.google.datastore.v1.Query toPb() {
        Query.Builder queryPb = com.google.datastore.v1.Query.newBuilder();
        if (this.kind != null) {
            queryPb.addKindBuilder().setName(this.kind);
        }
        if (this.startCursor != null) {
            queryPb.setStartCursor(this.startCursor.byteString());
        }
        if (this.endCursor != null) {
            queryPb.setEndCursor(this.endCursor.byteString());
        }
        if (this.offset > 0) {
            queryPb.setOffset(this.offset);
        }
        if (this.limit != null) {
            queryPb.setLimit(Int32Value.newBuilder().setValue(this.limit.intValue()));
        }
        if (this.filter != null) {
            queryPb.setFilter(this.filter.toPb());
        }
        for (Object value : this.orderBy) {
            queryPb.addOrder(((OrderBy)value).toPb());
        }
        for (Object value : this.distinctOn) {
            queryPb.addDistinctOn(PropertyReference.newBuilder().setName((String)value).build());
        }
        for (Object value : this.projection) {
            Projection.Builder expressionPb = Projection.newBuilder();
            expressionPb.setProperty(PropertyReference.newBuilder().setName((String)value).build());
            queryPb.addProjection(expressionPb.build());
        }
        return queryPb.build();
    }

    static <V> StructuredQuery<V> fromPb(Query.ResultType<?> resultType, String namespace, com.google.datastore.v1.Query queryPb) {
        BuilderImpl builder = resultType.equals(Query.ResultType.ENTITY) ? new EntityQuery.Builder() : (resultType.equals(Query.ResultType.KEY) ? new KeyQuery.Builder() : new ProjectionEntityQuery.Builder());
        return ((BuilderImpl)builder.namespace(namespace)).mergeFrom(queryPb).build();
    }

    static abstract class BuilderImpl<V, B extends BuilderImpl<V, B>>
    implements Builder<V> {
        private final Query.ResultType<V> resultType;
        private String namespace;
        private String kind;
        private final List<String> projection = new LinkedList<String>();
        private Filter filter;
        private final List<String> distinctOn = new LinkedList<String>();
        private final List<OrderBy> orderBy = new LinkedList<OrderBy>();
        private Cursor startCursor;
        private Cursor endCursor;
        private int offset;
        private Integer limit;

        BuilderImpl(Query.ResultType<V> resultType) {
            this.resultType = resultType;
        }

        BuilderImpl(StructuredQuery<V> query) {
            this(query.type());
            this.namespace = query.namespace();
            this.kind = ((StructuredQuery)query).kind;
            this.projection.addAll((Collection<String>)((StructuredQuery)query).projection);
            this.filter = ((StructuredQuery)query).filter;
            this.distinctOn.addAll((Collection<String>)((StructuredQuery)query).distinctOn);
            this.orderBy.addAll((Collection<OrderBy>)((StructuredQuery)query).orderBy);
            this.startCursor = ((StructuredQuery)query).startCursor;
            this.endCursor = ((StructuredQuery)query).endCursor;
            this.offset = ((StructuredQuery)query).offset;
            this.limit = ((StructuredQuery)query).limit;
        }

        B self() {
            return (B)this;
        }

        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        public B kind(String kind) {
            this.kind = kind;
            return this.self();
        }

        public B startCursor(Cursor startCursor) {
            this.startCursor = startCursor;
            return this.self();
        }

        public B endCursor(Cursor endCursor) {
            this.endCursor = endCursor;
            return this.self();
        }

        public B offset(int offset) {
            Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset must not be negative");
            this.offset = offset;
            return this.self();
        }

        public B limit(Integer limit) {
            Preconditions.checkArgument((limit == null || limit > 0 ? 1 : 0) != 0, (Object)"limit must be positive");
            this.limit = limit;
            return this.self();
        }

        public B filter(Filter filter) {
            this.filter = filter;
            return this.self();
        }

        public B clearOrderBy() {
            this.orderBy.clear();
            return this.self();
        }

        public B orderBy(OrderBy orderBy, OrderBy ... others) {
            this.clearOrderBy();
            this.addOrderBy(orderBy, others);
            return this.self();
        }

        public B addOrderBy(OrderBy orderBy, OrderBy ... others) {
            this.orderBy.add(orderBy);
            Collections.addAll(this.orderBy, others);
            return this.self();
        }

        B clearProjection() {
            this.projection.clear();
            return this.self();
        }

        B projection(String projection, String ... others) {
            this.clearProjection();
            this.addProjection(projection, others);
            return this.self();
        }

        B addProjection(String projection, String ... others) {
            this.projection.add(projection);
            Collections.addAll(this.projection, others);
            return this.self();
        }

        B clearDistinctOn() {
            this.distinctOn.clear();
            return this.self();
        }

        B distinctOn(String property, String ... others) {
            this.clearDistinctOn();
            this.addDistinctOn(property, others);
            return this.self();
        }

        B addDistinctOn(String property, String ... others) {
            this.distinctOn.add(property);
            Collections.addAll(this.distinctOn, others);
            return this.self();
        }

        B mergeFrom(com.google.datastore.v1.Query queryPb) {
            Filter currFilter;
            if (queryPb.getKindCount() > 0) {
                this.kind(queryPb.getKind(0).getName());
            }
            if (!queryPb.getStartCursor().isEmpty()) {
                this.startCursor(new Cursor(queryPb.getStartCursor()));
            }
            if (!queryPb.getEndCursor().isEmpty()) {
                this.endCursor(new Cursor(queryPb.getEndCursor()));
            }
            this.offset(queryPb.getOffset());
            if (queryPb.hasLimit()) {
                this.limit(queryPb.getLimit().getValue());
            }
            if (queryPb.hasFilter() && (currFilter = Filter.fromPb(queryPb.getFilter())) != null) {
                this.filter(currFilter);
            }
            for (PropertyOrder orderByPb : queryPb.getOrderList()) {
                this.addOrderBy(OrderBy.fromPb(orderByPb), new OrderBy[0]);
            }
            for (Projection projectionPb : queryPb.getProjectionList()) {
                this.addProjection(projectionPb.getProperty().getName(), new String[0]);
            }
            for (PropertyReference distinctOnPb : queryPb.getDistinctOnList()) {
                this.addDistinctOn(distinctOnPb.getName(), new String[0]);
            }
            return this.self();
        }
    }

    public static interface Builder<V> {
        public Builder<V> namespace(String var1);

        public Builder<V> kind(String var1);

        public Builder<V> startCursor(Cursor var1);

        public Builder<V> endCursor(Cursor var1);

        public Builder<V> offset(int var1);

        public Builder<V> limit(Integer var1);

        public Builder<V> filter(Filter var1);

        public Builder<V> clearOrderBy();

        public Builder<V> orderBy(OrderBy var1, OrderBy ... var2);

        public Builder<V> addOrderBy(OrderBy var1, OrderBy ... var2);

        public StructuredQuery<V> build();
    }

    public static final class OrderBy
    implements Serializable {
        private static final long serialVersionUID = 4091186784814400031L;
        private final String property;
        private final Direction direction;

        public OrderBy(String property, Direction direction) {
            this.property = (String)Preconditions.checkNotNull((Object)property);
            this.direction = (Direction)((Object)Preconditions.checkNotNull((Object)((Object)direction)));
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.property, this.direction});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof OrderBy)) {
                return false;
            }
            OrderBy other = (OrderBy)obj;
            return this.property.equals(other.property) && this.direction == other.direction;
        }

        public String property() {
            return this.property;
        }

        public Direction direction() {
            return this.direction;
        }

        PropertyOrder toPb() {
            return PropertyOrder.newBuilder().setDirection(this.direction.toPb()).setProperty(PropertyReference.newBuilder().setName(this.property).build()).build();
        }

        public static OrderBy asc(String property) {
            return new OrderBy(property, Direction.ASCENDING);
        }

        public static OrderBy desc(String property) {
            return new OrderBy(property, Direction.DESCENDING);
        }

        static OrderBy fromPb(PropertyOrder propertyOrderPb) {
            String property = propertyOrderPb.getProperty().getName();
            Direction direction = Direction.fromPb(propertyOrderPb.getDirection());
            return new OrderBy(property, direction);
        }

        public static enum Direction {
            ASCENDING,
            DESCENDING;


            PropertyOrder.Direction toPb() {
                return PropertyOrder.Direction.valueOf((String)this.name());
            }

            static Direction fromPb(PropertyOrder.Direction directionPb) {
                return Direction.valueOf(directionPb.name());
            }
        }
    }

    public static final class PropertyFilter
    extends Filter {
        private static final long serialVersionUID = -4514695915258598597L;
        private final String property;
        private final Operator operator;
        private final Value<?> value;

        private PropertyFilter(String property, Operator operator, Value<?> value) {
            this.property = (String)Preconditions.checkNotNull((Object)property);
            this.operator = (Operator)((Object)Preconditions.checkNotNull((Object)((Object)operator)));
            this.value = (Value)Preconditions.checkNotNull(value);
        }

        static PropertyFilter fromPb(com.google.datastore.v1.PropertyFilter propertyFilterPb) {
            String property = propertyFilterPb.getProperty().getName();
            Operator operator = Operator.fromPb(propertyFilterPb.getOp());
            Value<?> value = Value.fromPb(propertyFilterPb.getValue());
            return new PropertyFilter(property, operator, value);
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            toStringHelper.add("property", (Object)this.property);
            toStringHelper.add("operator", (Object)this.operator);
            toStringHelper.add("value", this.value);
            return toStringHelper.toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.property, this.operator, this.value});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PropertyFilter)) {
                return false;
            }
            PropertyFilter other = (PropertyFilter)obj;
            return this.property.equals(other.property) && this.operator == other.operator && Objects.equals(this.value, other.value);
        }

        public static PropertyFilter lt(String property, Value<?> value) {
            return new PropertyFilter(property, Operator.LESS_THAN, value);
        }

        public static PropertyFilter lt(String property, String value) {
            return new PropertyFilter(property, Operator.LESS_THAN, StringValue.of(value));
        }

        public static PropertyFilter lt(String property, long value) {
            return new PropertyFilter(property, Operator.LESS_THAN, LongValue.of(value));
        }

        public static PropertyFilter lt(String property, double value) {
            return new PropertyFilter(property, Operator.LESS_THAN, DoubleValue.of(value));
        }

        public static PropertyFilter lt(String property, boolean value) {
            return new PropertyFilter(property, Operator.LESS_THAN, BooleanValue.of(value));
        }

        public static PropertyFilter lt(String property, DateTime value) {
            return new PropertyFilter(property, Operator.LESS_THAN, DateTimeValue.of(value));
        }

        public static PropertyFilter lt(String property, Key value) {
            return new PropertyFilter(property, Operator.LESS_THAN, KeyValue.of(value));
        }

        public static PropertyFilter lt(String property, Blob value) {
            return new PropertyFilter(property, Operator.LESS_THAN, BlobValue.of(value));
        }

        public static PropertyFilter le(String property, Value<?> value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, value);
        }

        public static PropertyFilter le(String property, String value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, StringValue.of(value));
        }

        public static PropertyFilter le(String property, long value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, LongValue.of(value));
        }

        public static PropertyFilter le(String property, double value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, DoubleValue.of(value));
        }

        public static PropertyFilter le(String property, boolean value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, BooleanValue.of(value));
        }

        public static PropertyFilter le(String property, DateTime value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, DateTimeValue.of(value));
        }

        public static PropertyFilter le(String property, Key value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, KeyValue.of(value));
        }

        public static PropertyFilter le(String property, Blob value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, BlobValue.of(value));
        }

        public static PropertyFilter gt(String property, Value<?> value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, value);
        }

        public static PropertyFilter gt(String property, String value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, StringValue.of(value));
        }

        public static PropertyFilter gt(String property, long value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, LongValue.of(value));
        }

        public static PropertyFilter gt(String property, double value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, DoubleValue.of(value));
        }

        public static PropertyFilter gt(String property, boolean value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, BooleanValue.of(value));
        }

        public static PropertyFilter gt(String property, DateTime value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, DateTimeValue.of(value));
        }

        public static PropertyFilter gt(String property, Key value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, KeyValue.of(value));
        }

        public static PropertyFilter gt(String property, Blob value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, BlobValue.of(value));
        }

        public static PropertyFilter ge(String property, Value<?> value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, value);
        }

        public static PropertyFilter ge(String property, String value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, StringValue.of(value));
        }

        public static PropertyFilter ge(String property, long value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, LongValue.of(value));
        }

        public static PropertyFilter ge(String property, double value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, DoubleValue.of(value));
        }

        public static PropertyFilter ge(String property, boolean value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, BooleanValue.of(value));
        }

        public static PropertyFilter ge(String property, DateTime value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, DateTimeValue.of(value));
        }

        public static PropertyFilter ge(String property, Key value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, KeyValue.of(value));
        }

        public static PropertyFilter ge(String property, Blob value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, BlobValue.of(value));
        }

        public static PropertyFilter eq(String property, Value<?> value) {
            return new PropertyFilter(property, Operator.EQUAL, value);
        }

        public static PropertyFilter eq(String property, String value) {
            return new PropertyFilter(property, Operator.EQUAL, StringValue.of(value));
        }

        public static PropertyFilter eq(String property, long value) {
            return new PropertyFilter(property, Operator.EQUAL, LongValue.of(value));
        }

        public static PropertyFilter eq(String property, double value) {
            return new PropertyFilter(property, Operator.EQUAL, DoubleValue.of(value));
        }

        public static PropertyFilter eq(String property, boolean value) {
            return new PropertyFilter(property, Operator.EQUAL, BooleanValue.of(value));
        }

        public static PropertyFilter eq(String property, DateTime value) {
            return new PropertyFilter(property, Operator.EQUAL, DateTimeValue.of(value));
        }

        public static PropertyFilter eq(String property, Key value) {
            return new PropertyFilter(property, Operator.EQUAL, KeyValue.of(value));
        }

        public static PropertyFilter eq(String property, Blob value) {
            return new PropertyFilter(property, Operator.EQUAL, BlobValue.of(value));
        }

        public static PropertyFilter hasAncestor(Key key) {
            return new PropertyFilter(StructuredQuery.KEY_PROPERTY_NAME, Operator.HAS_ANCESTOR, KeyValue.of(key));
        }

        public static PropertyFilter isNull(String property) {
            return new PropertyFilter(property, Operator.EQUAL, NullValue.of());
        }

        @Override
        com.google.datastore.v1.Filter toPb() {
            Filter.Builder filterPb = com.google.datastore.v1.Filter.newBuilder();
            PropertyFilter.Builder propertyFilterPb = filterPb.getPropertyFilterBuilder();
            propertyFilterPb.getPropertyBuilder().setName(this.property);
            propertyFilterPb.setOp(this.operator.toPb());
            if (this.value != null) {
                propertyFilterPb.setValue(this.value.toPb());
            }
            return filterPb.build();
        }

        static enum Operator {
            LESS_THAN,
            LESS_THAN_OR_EQUAL,
            GREATER_THAN,
            GREATER_THAN_OR_EQUAL,
            EQUAL,
            HAS_ANCESTOR;


            PropertyFilter.Operator toPb() {
                return PropertyFilter.Operator.valueOf((String)this.name());
            }

            static Operator fromPb(PropertyFilter.Operator operatorPb) {
                return Operator.valueOf(operatorPb.name());
            }
        }
    }

    public static final class CompositeFilter
    extends Filter {
        private static final long serialVersionUID = 3610352685739360009L;
        private final Operator operator;
        private final ImmutableList<Filter> filters;

        private CompositeFilter(Operator operator, Filter first, Filter ... other) {
            this.operator = operator;
            this.filters = ImmutableList.builder().add((Object)first).addAll(Arrays.asList(other)).build();
        }

        private CompositeFilter(Operator operator, ImmutableList<Filter> filters) {
            this.operator = operator;
            this.filters = filters;
            Preconditions.checkArgument((!filters.isEmpty() ? 1 : 0) != 0, (Object)"filters list must not be empty");
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            toStringHelper.add("operator", (Object)this.operator);
            toStringHelper.add("filters", this.filters);
            return toStringHelper.toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.operator, this.filters});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CompositeFilter)) {
                return false;
            }
            CompositeFilter other = (CompositeFilter)obj;
            return this.operator == other.operator && this.filters.equals(other.filters);
        }

        static CompositeFilter fromPb(com.google.datastore.v1.CompositeFilter compositeFilterPb) {
            Operator operator = Operator.fromPb(compositeFilterPb.getOp());
            ImmutableList.Builder filters = ImmutableList.builder();
            for (com.google.datastore.v1.Filter filterPb : compositeFilterPb.getFiltersList()) {
                Filter currFilter = Filter.fromPb(filterPb);
                if (currFilter == null) continue;
                filters.add((Object)currFilter);
            }
            return new CompositeFilter(operator, (ImmutableList<Filter>)filters.build());
        }

        public static CompositeFilter and(Filter first, Filter ... other) {
            return new CompositeFilter(Operator.AND, first, other);
        }

        @Override
        com.google.datastore.v1.Filter toPb() {
            Filter.Builder filterPb = com.google.datastore.v1.Filter.newBuilder();
            CompositeFilter.Builder compositeFilterPb = filterPb.getCompositeFilterBuilder();
            compositeFilterPb.setOp(this.operator.toPb());
            for (Filter filter : this.filters) {
                compositeFilterPb.addFilters(filter.toPb());
            }
            return filterPb.build();
        }

        static enum Operator {
            AND;


            CompositeFilter.Operator toPb() {
                return CompositeFilter.Operator.valueOf((String)this.name());
            }

            static Operator fromPb(CompositeFilter.Operator operatorPb) {
                return Operator.valueOf(operatorPb.name());
            }
        }
    }

    public static abstract class Filter
    implements Serializable {
        private static final long serialVersionUID = -6443285436239990860L;

        Filter() {
        }

        abstract com.google.datastore.v1.Filter toPb();

        static Filter fromPb(com.google.datastore.v1.Filter filterPb) {
            switch (filterPb.getFilterTypeCase()) {
                case COMPOSITE_FILTER: {
                    return CompositeFilter.fromPb(filterPb.getCompositeFilter());
                }
                case PROPERTY_FILTER: {
                    return PropertyFilter.fromPb(filterPb.getPropertyFilter());
                }
            }
            throw new AssertionError((Object)("Unexpected enum value " + filterPb.getFilterTypeCase()));
        }
    }
}

