/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.BaseDatastoreBatchWriter;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreHelper;
import com.google.cloud.datastore.DatastoreImpl;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.Transaction;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.MutationResult;
import com.google.datastore.v1.ReadOptions;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class TransactionImpl
extends BaseDatastoreBatchWriter
implements Transaction {
    private final DatastoreImpl datastore;
    private final ByteString transaction;
    private boolean rolledback;

    TransactionImpl(DatastoreImpl datastore) {
        super("transaction");
        this.datastore = datastore;
        BeginTransactionRequest.Builder requestPb = BeginTransactionRequest.newBuilder();
        this.transaction = datastore.requestTransactionId(requestPb);
    }

    @Override
    public Entity get(Key key) {
        return DatastoreHelper.get(this, key);
    }

    @Override
    public Iterator<Entity> get(Key ... keys) {
        this.validateActive();
        ReadOptions.Builder readOptionsPb = ReadOptions.newBuilder();
        readOptionsPb.setTransaction(this.transaction);
        return this.datastore.get(readOptionsPb.build(), keys);
    }

    @Override
    public List<Entity> fetch(Key ... keys) {
        this.validateActive();
        return DatastoreHelper.fetch(this, keys);
    }

    @Override
    public <T> QueryResults<T> run(Query<T> query) {
        this.validateActive();
        ReadOptions.Builder readOptionsPb = ReadOptions.newBuilder();
        readOptionsPb.setTransaction(this.transaction);
        return this.datastore.run(readOptionsPb.build(), query);
    }

    @Override
    public Transaction.Response commit() {
        this.validateActive();
        List<Mutation> mutationsPb = this.toMutationPbList();
        CommitRequest.Builder requestPb = CommitRequest.newBuilder();
        requestPb.setMode(CommitRequest.Mode.TRANSACTIONAL);
        requestPb.setTransaction(this.transaction);
        requestPb.addAllMutations(mutationsPb);
        CommitResponse responsePb = this.datastore.commit(requestPb.build());
        this.deactivate();
        return new ResponseImpl(responsePb, this.toAddAutoId().size());
    }

    @Override
    public void rollback() {
        if (this.rolledback) {
            return;
        }
        this.validateActive();
        this.datastore.rollbackTransaction(this.transaction);
        this.deactivate();
        this.rolledback = true;
    }

    @Override
    public Datastore datastore() {
        return this.datastore;
    }

    static class ResponseImpl
    implements Transaction.Response {
        private final CommitResponse response;
        private final int numAutoAllocatedIds;

        ResponseImpl(CommitResponse response, int numAutoAllocatedIds) {
            this.response = response;
            this.numAutoAllocatedIds = numAutoAllocatedIds;
        }

        @Override
        public List<Key> generatedKeys() {
            Iterator results = this.response.getMutationResultsList().iterator();
            ArrayList<Key> generated = new ArrayList<Key>(this.numAutoAllocatedIds);
            for (int i = 0; i < this.numAutoAllocatedIds; ++i) {
                generated.add(Key.fromPb(((MutationResult)results.next()).getKey()));
            }
            return generated;
        }
    }
}

