/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.testing;

import com.google.cloud.RetryParams;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import java.util.UUID;

public class RemoteDatastoreHelper {
    private final DatastoreOptions options;
    private final Datastore datastore;
    private final String namespace;

    private RemoteDatastoreHelper(DatastoreOptions options) {
        this.options = options;
        this.datastore = (Datastore)options.service();
        this.namespace = options.namespace();
    }

    public DatastoreOptions options() {
        return this.options;
    }

    public void deleteNamespace() {
        KeyQuery query = ((KeyQuery.Builder)Query.keyQueryBuilder().namespace(this.namespace)).build();
        QueryResults keys = this.datastore.run(query);
        while (keys.hasNext()) {
            this.datastore.delete((Key)keys.next());
        }
    }

    public static RemoteDatastoreHelper create() {
        DatastoreOptions datastoreOption = ((DatastoreOptions.Builder)((DatastoreOptions.Builder)((DatastoreOptions.Builder)DatastoreOptions.builder().namespace(UUID.randomUUID().toString()).retryParams(RemoteDatastoreHelper.retryParams())).connectTimeout(60000)).readTimeout(60000)).build();
        return new RemoteDatastoreHelper(datastoreOption);
    }

    private static RetryParams retryParams() {
        return RetryParams.builder().retryMaxAttempts(10).retryMinAttempts(6).maxRetryDelayMillis(30000L).totalRetryPeriodMillis(120000L).initialRetryDelayMillis(250L).build();
    }
}

