/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.BaseKey;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.PathElement;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1.Key;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public final class Key
extends IncompleteKey {
    private static final long serialVersionUID = 2563249643000943477L;

    Key(String projectId, String namespace, ImmutableList<PathElement> path) {
        super(projectId, namespace, path);
        Preconditions.checkArgument((this.getNameOrId() != null ? 1 : 0) != 0);
    }

    public boolean hasId() {
        return this.getLeaf().hasId();
    }

    @Deprecated
    public Long id() {
        return this.getId();
    }

    public Long getId() {
        return this.getLeaf().getId();
    }

    public boolean hasName() {
        return this.getLeaf().hasName();
    }

    @Deprecated
    public String name() {
        return this.getName();
    }

    public String getName() {
        return this.getLeaf().getName();
    }

    @Deprecated
    public Object nameOrId() {
        return this.getLeaf().getNameOrId();
    }

    public Object getNameOrId() {
        return this.getLeaf().getNameOrId();
    }

    public String toUrlSafe() {
        try {
            return URLEncoder.encode(TextFormat.printToString((MessageOrBuilder)this.toPb()), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected encoding exception", e);
        }
    }

    public static Key fromUrlSafe(String urlSafe) {
        try {
            String utf8Str = URLDecoder.decode(urlSafe, StandardCharsets.UTF_8.name());
            Key.Builder builder = com.google.datastore.v1.Key.newBuilder();
            TextFormat.merge((CharSequence)utf8Str, (Message.Builder)builder);
            return Key.fromPb(builder.build());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected decoding exception", e);
        }
        catch (TextFormat.ParseException e) {
            throw new IllegalArgumentException("Could not parse key", e);
        }
    }

    static Key fromPb(com.google.datastore.v1.Key keyPb) {
        IncompleteKey key = IncompleteKey.fromPb(keyPb);
        Preconditions.checkState((boolean)(key instanceof Key), (Object)"Key is not complete");
        return (Key)key;
    }

    @Deprecated
    public static Builder builder(String projectId, String kind, String name) {
        return Key.newBuilder(projectId, kind, name);
    }

    public static Builder newBuilder(String projectId, String kind, String name) {
        return new Builder(projectId, kind, name);
    }

    @Deprecated
    public static Builder builder(String projectId, String kind, long id) {
        return Key.newBuilder(projectId, kind, id);
    }

    public static Builder newBuilder(String projectId, String kind, long id) {
        return new Builder(projectId, kind, id);
    }

    @Deprecated
    public static Builder builder(Key copyFrom) {
        return Key.newBuilder(copyFrom);
    }

    public static Builder newBuilder(Key copyFrom) {
        return new Builder(copyFrom);
    }

    @Deprecated
    public static Builder builder(IncompleteKey copyFrom, String name) {
        return Key.newBuilder(copyFrom, name);
    }

    public static Builder newBuilder(IncompleteKey copyFrom, String name) {
        return new Builder(copyFrom, name);
    }

    @Deprecated
    public static Builder builder(IncompleteKey copyFrom, long id) {
        return Key.newBuilder(copyFrom, id);
    }

    public static Builder newBuilder(IncompleteKey copyFrom, long id) {
        return new Builder(copyFrom, id);
    }

    @Deprecated
    public static Builder builder(Key parent, String kind, String name) {
        return Key.newBuilder(parent, kind, name);
    }

    public static Builder newBuilder(Key parent, String kind, String name) {
        Builder builder = Key.newBuilder(parent.getProjectId(), kind, name);
        Key.addParentToBuilder(parent, builder);
        return builder;
    }

    @Deprecated
    public static Builder builder(Key parent, String kind, long id) {
        return Key.newBuilder(parent, kind, id);
    }

    public static Builder newBuilder(Key parent, String kind, long id) {
        Builder builder = Key.newBuilder(parent.getProjectId(), kind, id);
        Key.addParentToBuilder(parent, builder);
        return builder;
    }

    private static void addParentToBuilder(Key parent, Builder builder) {
        builder.setNamespace(parent.getNamespace());
        builder.addAncestors(parent.getAncestors());
        if (parent.hasId()) {
            builder.addAncestors(PathElement.of(parent.getKind(), parent.getId()), new PathElement[0]);
        } else {
            builder.addAncestors(PathElement.of(parent.getKind(), parent.getName()), new PathElement[0]);
        }
    }

    public static final class Builder
    extends BaseKey.Builder<Builder> {
        private String name;
        private Long id;

        private Builder(String projectId, String kind, String name) {
            super(projectId, kind);
            this.name = name;
        }

        private Builder(String projectId, String kind, long id) {
            super(projectId, kind);
            this.id = id;
        }

        private Builder(IncompleteKey copyFrom, String name) {
            super(copyFrom);
            this.name = name;
        }

        private Builder(IncompleteKey copyFrom, long id) {
            super(copyFrom);
            this.id = id;
        }

        private Builder(Key copyFrom) {
            super(copyFrom);
            if (copyFrom.hasId()) {
                this.id = copyFrom.getId();
            } else {
                this.name = copyFrom.getName();
            }
        }

        @Deprecated
        public Builder name(String name) {
            return this.setName(name);
        }

        public Builder setName(String name) {
            this.name = name;
            this.id = null;
            return this;
        }

        @Deprecated
        public Builder id(long id) {
            return this.setId(id);
        }

        public Builder setId(long id) {
            this.id = id;
            this.name = null;
            return this;
        }

        @Override
        public Key build() {
            ImmutableList.Builder pathBuilder = ImmutableList.builder().addAll((Iterable)this.ancestors);
            if (this.id == null) {
                pathBuilder.add((Object)PathElement.of(this.kind, this.name));
            } else {
                pathBuilder.add((Object)PathElement.of(this.kind, this.id));
            }
            return new Key(this.projectId, this.namespace, (ImmutableList<PathElement>)pathBuilder.build());
        }
    }
}

