/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.DateTimeValue;
import com.google.cloud.datastore.DoubleValue;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Validator;
import com.google.cloud.datastore.Value;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.datastore.v1.GqlQuery;
import com.google.datastore.v1.GqlQueryParameter;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class GqlQuery<V>
extends Query<V> {
    private static final long serialVersionUID = -5514894742849230793L;
    private final String queryString;
    private final boolean allowLiteral;
    private final ImmutableMap<String, Binding> namedBindings;
    private final ImmutableList<Binding> positionalBindings;

    private GqlQuery(Builder<V> builder) {
        super(((Builder)builder).resultType, ((Builder)builder).namespace);
        this.queryString = ((Builder)builder).queryString;
        this.allowLiteral = ((Builder)builder).allowLiteral;
        this.namedBindings = ImmutableMap.copyOf((Map)((Builder)builder).namedBindings);
        this.positionalBindings = ImmutableList.copyOf((Collection)((Builder)builder).positionalBindings);
    }

    @Deprecated
    public String queryString() {
        return this.getQueryString();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean allowLiteral() {
        return this.allowLiteral;
    }

    @Deprecated
    public Map<String, Object> namedBindings() {
        return this.getNamedBindings();
    }

    public Map<String, Object> getNamedBindings() {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry binding : this.namedBindings.entrySet()) {
            builder.put(binding.getKey(), ((Binding)binding.getValue()).getCursorOrValue());
        }
        return builder.build();
    }

    @Deprecated
    public List<Object> numberArgs() {
        return this.getNumberArgs();
    }

    public List<Object> getNumberArgs() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Binding binding : this.positionalBindings) {
            builder.add(binding.getCursorOrValue());
        }
        return builder.build();
    }

    public String toString() {
        return super.toStringHelper().add("queryString", (Object)this.queryString).add("allowLiteral", this.allowLiteral).add("namedBindings", this.namedBindings).add("positionalBindings", this.positionalBindings).toString();
    }

    public int hashCode() {
        return Objects.hash(this.getNamespace(), this.queryString, this.allowLiteral, this.namedBindings, this.positionalBindings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GqlQuery)) {
            return false;
        }
        GqlQuery other = (GqlQuery)obj;
        return Objects.equals(this.getNamespace(), other.getNamespace()) && Objects.equals(this.queryString, other.queryString) && this.allowLiteral == other.allowLiteral && Objects.equals(this.namedBindings, other.namedBindings) && Objects.equals(this.positionalBindings, other.positionalBindings);
    }

    com.google.datastore.v1.GqlQuery toPb() {
        GqlQuery.Builder queryPb = com.google.datastore.v1.GqlQuery.newBuilder();
        queryPb.setQueryString(this.queryString);
        queryPb.setAllowLiterals(this.allowLiteral);
        for (Map.Entry entry : this.namedBindings.entrySet()) {
            queryPb.putNamedBindings((String)entry.getKey(), ((Binding)entry.getValue()).toPb());
        }
        for (Binding argument : this.positionalBindings) {
            queryPb.addPositionalBindings(argument.toPb());
        }
        return queryPb.build();
    }

    @Override
    void populatePb(RunQueryRequest.Builder requestPb) {
        requestPb.setGqlQuery(this.toPb());
    }

    @Override
    Query<V> nextQuery(RunQueryResponse responsePb) {
        return StructuredQuery.fromPb(this.getType(), this.getNamespace(), responsePb.getQuery()).nextQuery(responsePb);
    }

    public static final class Builder<V> {
        private final Query.ResultType<V> resultType;
        private String namespace;
        private String queryString;
        private boolean allowLiteral;
        private final Map<String, Binding> namedBindings = new TreeMap<String, Binding>();
        private final List<Binding> positionalBindings = new LinkedList<Binding>();

        Builder(Query.ResultType<V> resultType, String query) {
            this.resultType = (Query.ResultType)Preconditions.checkNotNull(resultType);
            this.queryString = (String)Preconditions.checkNotNull((Object)query);
        }

        @Deprecated
        public Builder<V> query(String query) {
            return this.setQuery(query);
        }

        public Builder<V> setQuery(String query) {
            this.queryString = (String)Preconditions.checkNotNull((Object)query);
            return this;
        }

        @Deprecated
        public Builder<V> namespace(String namespace) {
            return this.setNamespace(namespace);
        }

        public Builder<V> setNamespace(String namespace) {
            this.namespace = Validator.validateNamespace(namespace);
            return this;
        }

        @Deprecated
        public Builder<V> allowLiteral(boolean allowLiteral) {
            return this.setAllowLiteral(allowLiteral);
        }

        public Builder<V> setAllowLiteral(boolean allowLiteral) {
            this.allowLiteral = allowLiteral;
            return this;
        }

        public Builder<V> clearBindings() {
            this.namedBindings.clear();
            this.positionalBindings.clear();
            return this;
        }

        public Builder<V> setBinding(String name, Cursor cursor) {
            this.namedBindings.put(name, new Binding(cursor));
            return this;
        }

        public Builder<V> setBinding(String name, String ... value) {
            this.namedBindings.put(name, Builder.toBinding(StringValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, long ... value) {
            this.namedBindings.put(name, Builder.toBinding(LongValue.MARSHALLER, Longs.asList((long[])value)));
            return this;
        }

        public Builder<V> setBinding(String name, double ... value) {
            this.namedBindings.put(name, Builder.toBinding(DoubleValue.MARSHALLER, Doubles.asList((double[])value)));
            return this;
        }

        public Builder<V> setBinding(String name, boolean ... value) {
            this.namedBindings.put(name, Builder.toBinding(BooleanValue.MARSHALLER, Booleans.asList((boolean[])value)));
            return this;
        }

        public Builder<V> setBinding(String name, DateTime ... value) {
            this.namedBindings.put(name, Builder.toBinding(DateTimeValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, Key ... value) {
            this.namedBindings.put(name, Builder.toBinding(KeyValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, FullEntity<?> ... value) {
            this.namedBindings.put(name, Builder.toBinding(EntityValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, Blob ... value) {
            this.namedBindings.put(name, Builder.toBinding(BlobValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(Cursor cursor) {
            this.positionalBindings.add(new Binding(cursor));
            return this;
        }

        public Builder<V> addBinding(String ... value) {
            this.positionalBindings.add(Builder.toBinding(StringValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(long ... value) {
            this.positionalBindings.add(Builder.toBinding(LongValue.MARSHALLER, Longs.asList((long[])value)));
            return this;
        }

        public Builder<V> addBinding(double ... value) {
            this.positionalBindings.add(Builder.toBinding(DoubleValue.MARSHALLER, Doubles.asList((double[])value)));
            return this;
        }

        public Builder<V> addBinding(boolean ... value) {
            this.positionalBindings.add(Builder.toBinding(BooleanValue.MARSHALLER, Booleans.asList((boolean[])value)));
            return this;
        }

        public Builder<V> addBinding(DateTime ... value) {
            this.positionalBindings.add(Builder.toBinding(DateTimeValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(Key ... value) {
            this.positionalBindings.add(Builder.toBinding(KeyValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(FullEntity<?> ... value) {
            this.positionalBindings.add(Builder.toBinding(EntityValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(Blob ... value) {
            this.positionalBindings.add(Builder.toBinding(BlobValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public GqlQuery<V> build() {
            return new GqlQuery(this);
        }

        private static <V> Binding toBinding(Value.BuilderFactory<V, ?, ?> builderFactory, List<?> values) {
            ArrayList list = new ArrayList(values.size());
            Iterator<?> i$ = values.iterator();
            while (i$.hasNext()) {
                Object object;
                Object v = object = i$.next();
                list.add(builderFactory.newBuilder(v).build());
            }
            Value value = list.isEmpty() ? new NullValue() : (list.size() == 1 ? (Value)list.get(0) : new ListValue(list));
            return new Binding(value);
        }
    }

    static final class Binding
    implements Serializable {
        private static final long serialVersionUID = 2344746877591371548L;
        private final Cursor cursor;
        private final Value<?> value;

        Binding(Cursor cursor) {
            this.cursor = (Cursor)Preconditions.checkNotNull((Object)cursor);
            this.value = null;
        }

        Binding(Value<?> value) {
            this.value = (Value)Preconditions.checkNotNull(value);
            this.cursor = null;
        }

        Object getCursorOrValue() {
            return MoreObjects.firstNonNull((Object)this.cursor, this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("cursor", (Object)this.cursor).add("value", this.value).toString();
        }

        public int hashCode() {
            return Objects.hash(this.cursor, this.value);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Binding)) {
                return false;
            }
            Binding other = (Binding)obj;
            return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.value, other.value);
        }

        GqlQueryParameter toPb() {
            GqlQueryParameter.Builder argPb = GqlQueryParameter.newBuilder();
            if (this.cursor != null) {
                argPb.setCursor(this.cursor.getByteString());
            }
            if (this.value != null) {
                argPb.setValue(this.value.toPb());
            }
            return argPb.build();
        }

        static Binding fromPb(GqlQueryParameter argPb) {
            switch (argPb.getParameterTypeCase()) {
                case CURSOR: {
                    return new Binding(new Cursor(argPb.getCursor()));
                }
                case VALUE: {
                    return new Binding(Value.fromPb(argPb.getValue()));
                }
            }
            throw new AssertionError((Object)("Unexpected enum value " + argPb.getParameterTypeCase()));
        }
    }
}

