/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class LatLng
implements Serializable {
    private static final long serialVersionUID = -3739859034159591779L;
    private final double latitude;
    private final double longitude;

    LatLng(double latitude, double longitude) {
        Preconditions.checkArgument((latitude >= -90.0 && latitude <= 90.0 ? 1 : 0) != 0, (Object)"latitude must be in the range [-90, 90] degrees");
        Preconditions.checkArgument((longitude >= -180.0 && longitude <= 180.0 ? 1 : 0) != 0, (Object)"latitude must be in the range [-180, 180] degrees");
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @Deprecated
    public double latitude() {
        return this.getLatitude();
    }

    public double getLatitude() {
        return this.latitude;
    }

    @Deprecated
    public double longitude() {
        return this.getLongitude();
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String toString() {
        return Double.toString(this.latitude) + ", " + Double.toString(this.longitude);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LatLng && this.latitude == ((LatLng)obj).latitude && this.longitude == ((LatLng)obj).longitude;
    }

    public static LatLng of(double latitude, double longitude) {
        return new LatLng(latitude, longitude);
    }

    protected com.google.type.LatLng toPb() {
        return com.google.type.LatLng.newBuilder().setLatitude(this.latitude).setLongitude(this.longitude).build();
    }
}

