/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;

public final class DatastoreException
extends BaseServiceException {
    private static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(10), "ABORTED", false), (Object)new BaseServiceException.Error(Integer.valueOf(4), "DEADLINE_EXCEEDED", false), (Object)new BaseServiceException.Error(Integer.valueOf(14), "UNAVAILABLE", true));
    private static final long serialVersionUID = 2663750991205874435L;

    public DatastoreException(int code, String message, String reason) {
        this(code, message, reason, true, null);
    }

    public DatastoreException(int code, String message, String reason, Throwable cause) {
        super(code, message, reason, true, cause);
    }

    public DatastoreException(int code, String message, String reason, boolean idempotent, Throwable cause) {
        super(code, message, reason, idempotent, cause);
    }

    public DatastoreException(IOException exception) {
        super(exception, true);
    }

    protected Set<BaseServiceException.Error> getRetryableErrors() {
        return RETRYABLE_ERRORS;
    }

    static DatastoreException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translateAndPropagateIfPossible((RetryHelper.RetryHelperException)ex);
        throw new DatastoreException(0, ex.getMessage(), null, ex.getCause());
    }

    static DatastoreException throwInvalidRequest(String massage, Object ... params) {
        throw new DatastoreException(0, String.format(massage, params), "FAILED_PRECONDITION");
    }

    static DatastoreException propagateUserException(Exception ex) {
        throw new DatastoreException(0, ex.getMessage(), null, ex);
    }
}

